/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.machine.tile;

import com.codetaylor.mc.athenaeum.integration.gamestages.Stages;
import com.codetaylor.mc.athenaeum.interaction.api.InteractionBounds;
import com.codetaylor.mc.athenaeum.interaction.api.Transform;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.ITileInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionItemStack;
import com.codetaylor.mc.athenaeum.inventory.LargeObservableStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataLargeItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.util.AABBHelper;
import com.codetaylor.mc.athenaeum.util.BlockHelper;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.athenaeum.util.RandomHelper;
import com.codetaylor.mc.athenaeum.util.SoundHelper;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.core.item.ItemMulch;
import com.codetaylor.mc.pyrotech.modules.storage.tile.TileStash;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachine;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachineConfig;
import com.codetaylor.mc.pyrotech.modules.tech.machine.client.render.MechanicalMulchSpreaderInteractionMulchRenderer;
import com.codetaylor.mc.pyrotech.modules.tech.machine.tile.spi.TileCogWorkerBase;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileMechanicalMulchSpreader
extends TileCogWorkerBase
implements ITileInteractable {
    private MulchStackHandler mulchStackHandler = new MulchStackHandler(this.getCapacity(), this::isValidMulch);
    private int[] cogData = new int[2];

    public TileMechanicalMulchSpreader() {
        super(ModuleTechMachine.TILE_DATA_SERVICE);
        this.registerTileDataForNetwork(new ITileData[]{new TileDataLargeItemStackHandler((ItemStackHandler)this.mulchStackHandler)});
        this.addInteractions(new IInteraction[]{new InteractionMulch(this, (ItemStackHandler)this.mulchStackHandler, this::isValidMulch)});
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == EnumFacing.UP;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.hasCapability(capability, facing)) {
            return (T)((Object)this.mulchStackHandler);
        }
        return null;
    }

    public MulchStackHandler getMulchStackHandler() {
        return this.mulchStackHandler;
    }

    private boolean isValidMulch(ItemStack itemStack) {
        return itemStack.func_77973_b() == ModuleCore.Items.MULCH;
    }

    public int getCapacity() {
        return ModuleTechMachineConfig.MECHANICAL_MULCH_SPREADER.CAPACITY;
    }

    @Override
    protected boolean isValidCog(ItemStack itemStack) {
        int[] result;
        ResourceLocation registryName = itemStack.func_77973_b().getRegistryName();
        return ModuleTechMachineConfig.MECHANICAL_MULCH_SPREADER.getCogData(registryName, result = new int[2])[0] != -1;
    }

    @Override
    protected int getUpdateIntervalTicks() {
        return ModuleTechMachineConfig.MECHANICAL_MULCH_SPREADER.WORK_INTERVAL_TICKS;
    }

    private int[] getCogData(ItemStack cog) {
        return ModuleTechMachineConfig.MECHANICAL_MULCH_SPREADER.getCogData(cog.func_77973_b().getRegistryName(), this.cogData);
    }

    @Override
    protected int doWork(ItemStack cog) {
        ItemStack mulchStack = this.mulchStackHandler.getStackInSlot(0);
        if (mulchStack.func_190926_b()) {
            return 0;
        }
        SoundHelper.playSoundServer((World)this.field_145850_b, (BlockPos)this.field_174879_c, (SoundEvent)SoundEvents.field_187715_dR, (SoundCategory)SoundCategory.BLOCKS, (float)0.5f, (float)(RandomHelper.random().nextFloat() * 0.2f + 0.8f));
        int[] cogData = this.getCogData(cog);
        int cogRange = cogData[0];
        int[] cogAttempts = new int[]{Math.min(cogData[1], mulchStack.func_190916_E())};
        int[] placedMulch = new int[]{0};
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        EnumFacing facing = ModuleTechMachine.Blocks.MECHANICAL_MULCH_SPREADER.getFacing(blockState);
        BlockPos origin = this.field_174879_c.func_177967_a(facing, cogRange + 1).func_177977_b();
        BlockHelper.forBlocksInCubeShuffled((World)this.field_145850_b, (BlockPos)origin, (int)cogRange, (int)0, (int)cogRange, (w, p, bs) -> {
            if (ItemMulch.canMulch(bs)) {
                this.mulchStackHandler.extractItem(0, 1, false);
                w.func_175656_a(p, ModuleCore.Blocks.FARMLAND_MULCHED.func_176223_P());
                SoundHelper.playSoundServer((World)this.field_145850_b, (BlockPos)this.field_174879_c, (SoundEvent)SoundEvents.field_187577_bU, (SoundCategory)SoundCategory.BLOCKS);
                placedMulch[0] = placedMulch[0] + 1;
            }
            cogAttempts[0] = cogAttempts[0] - 1;
            return cogAttempts[0] > 0;
        });
        if (ModuleTechMachineConfig.MECHANICAL_MULCH_SPREADER.COG_DAMAGE_TYPE == ModuleTechMachineConfig.MechanicalMulchSpreader.EnumCogDamageType.PerItem) {
            return Math.max(1, placedMulch[0]);
        }
        return 1;
    }

    @Override
    protected boolean isPowered() {
        return this.field_145850_b.func_175640_z(this.field_174879_c);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("stackHandler", (NBTBase)this.mulchStackHandler.serializeNBT());
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.mulchStackHandler.deserializeNBT(compound.func_74775_l("stackHandler"));
    }

    @Nullable
    public Stages getStages() {
        return ModuleTechMachineConfig.STAGES_MECHANICAL_MULCHER;
    }

    public EnumFacing getTileFacing(World world, BlockPos pos, IBlockState blockState) {
        if (blockState.func_177230_c() == ModuleTechMachine.Blocks.MECHANICAL_MULCH_SPREADER) {
            return (EnumFacing)blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        }
        return super.getTileFacing(world, pos, blockState);
    }

    public boolean isExtendedInteraction(World world, BlockPos pos, IBlockState blockState) {
        if (blockState.func_177230_c() == ModuleTechMachine.Blocks.MECHANICAL_MULCH_SPREADER) {
            BlockPos blockPos = this.func_174877_v();
            EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
            return (blockPos = blockPos.func_177972_a(facing.func_176734_d())).func_177958_n() == pos.func_177958_n() && blockPos.func_177956_o() == pos.func_177956_o() && blockPos.func_177952_p() == pos.func_177952_p();
        }
        return false;
    }

    @Override
    protected Transform getCogInteractionTransform() {
        return new Transform(Transform.translate((double)0.5, (double)0.5, (double)1.3125), Transform.rotate(), Transform.scale((double)0.75, (double)0.75, (double)2.0));
    }

    @Override
    protected AxisAlignedBB getCogInteractionBounds() {
        return AABBHelper.create((double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0, (double)20.0);
    }

    public static class MulchStackHandler
    extends LargeObservableStackHandler
    implements ITileDataItemStackHandler {
        private final int maxStacks;
        private final Predicate<ItemStack> filter;

        MulchStackHandler(int maxStacks, Predicate<ItemStack> filter) {
            super(1);
            this.maxStacks = maxStacks;
            this.filter = filter;
        }

        public int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return stack.func_77976_d() * this.maxStacks;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.filter.test(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    }

    public static class InteractionMulch
    extends InteractionItemStack<TileStash> {
        private final TileMechanicalMulchSpreader tile;
        private final Predicate<ItemStack> filter;

        InteractionMulch(TileMechanicalMulchSpreader tile, ItemStackHandler stackHandler, Predicate<ItemStack> filter) {
            super(new ItemStackHandler[]{stackHandler}, 0, new EnumFacing[]{EnumFacing.UP}, InteractionBounds.BLOCK, new Transform(Transform.translate((double)0.5, (double)1.0, (double)0.5), Transform.rotate(), Transform.scale((double)0.5, (double)0.5, (double)0.5)));
            this.tile = tile;
            this.filter = filter;
        }

        public TileMechanicalMulchSpreader getTile() {
            return this.tile;
        }

        protected boolean doItemStackValidation(ItemStack itemStack) {
            return this.filter.test(itemStack);
        }

        public Vec3d getTextOffset(EnumFacing tileFacing, EnumFacing playerHorizontalFacing, EnumFacing sideHit) {
            return new Vec3d(0.0, 0.1, 0.0);
        }

        public void renderSolidPass(World world, RenderItem renderItem, BlockPos pos, IBlockState blockState, float partialTicks) {
            MechanicalMulchSpreaderInteractionMulchRenderer.INSTANCE.renderSolidPass(this, world, renderItem, pos, blockState, partialTicks);
        }

        public void renderSolidPassText(World world, FontRenderer fontRenderer, int yaw, Vec3d offset, BlockPos pos, IBlockState blockState, float partialTicks) {
            MechanicalMulchSpreaderInteractionMulchRenderer.INSTANCE.renderSolidPassText(this, world, fontRenderer, yaw, offset, pos, blockState, partialTicks);
        }

        public boolean renderAdditivePass(World world, RenderItem renderItem, EnumFacing hitSide, Vec3d hitVec, BlockPos hitPos, IBlockState blockState, ItemStack heldItemMainHand, float partialTicks) {
            return MechanicalMulchSpreaderInteractionMulchRenderer.INSTANCE.renderAdditivePass(this, world, renderItem, hitSide, hitVec, hitPos, blockState, heldItemMainHand, partialTicks);
        }
    }
}

