/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.machine.recipe;

import com.codetaylor.mc.athenaeum.util.RecipeHelper;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachine;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachineConfig;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.spi.MachineRecipeItemInItemOutBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.Ingredient;

public class BrickOvenRecipe
extends MachineRecipeItemInItemOutBase<BrickOvenRecipe> {
    private static final Map<String, BrickOvenRecipe> SMELTING_RECIPES = new HashMap<String, BrickOvenRecipe>();
    private static final List<Ingredient> WHITELIST = new ArrayList<Ingredient>();
    private static final List<Ingredient> BLACKLIST = new ArrayList<Ingredient>();
    private static boolean BLACKLIST_ALL = false;

    public static void blacklistAll() {
        BLACKLIST_ALL = true;
    }

    @Nullable
    public static BrickOvenRecipe getRecipe(ItemStack input) {
        String key = BrickOvenRecipe.getRecipeKey(input);
        BrickOvenRecipe result = SMELTING_RECIPES.get(key);
        if (result != null) {
            return result;
        }
        if (!BLACKLIST_ALL && RecipeHelper.hasFurnaceFoodRecipe((ItemStack)input)) {
            FurnaceRecipes furnaceRecipes = FurnaceRecipes.func_77602_a();
            ItemStack output = furnaceRecipes.func_151395_a(input);
            if (BrickOvenRecipe.hasWhitelist()) {
                if (BrickOvenRecipe.isWhitelisted(output)) {
                    result = new BrickOvenRecipe(output, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{input}));
                    SMELTING_RECIPES.put(key, result);
                    return result;
                }
                return BrickOvenRecipe.getCustomRecipe(input);
            }
            if (BrickOvenRecipe.hasBlacklist()) {
                if (!BrickOvenRecipe.isBlacklisted(output)) {
                    result = new BrickOvenRecipe(output, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{input}));
                    SMELTING_RECIPES.put(key, result);
                    return result;
                }
                return BrickOvenRecipe.getCustomRecipe(input);
            }
            result = new BrickOvenRecipe(output, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{input}));
            SMELTING_RECIPES.put(key, result);
            return result;
        }
        return BrickOvenRecipe.getCustomRecipe(input);
    }

    @Nullable
    private static BrickOvenRecipe getCustomRecipe(ItemStack input) {
        for (BrickOvenRecipe recipe : ModuleTechMachine.Registries.BRICK_OVEN_RECIPES) {
            if (!recipe.matches(input)) continue;
            return recipe;
        }
        return null;
    }

    private static String getRecipeKey(ItemStack itemStack) {
        return itemStack.func_77973_b().func_77658_a() + ":" + itemStack.func_77952_i();
    }

    public static boolean removeRecipes(Ingredient output) {
        return RecipeHelper.removeRecipesByOutput(ModuleTechMachine.Registries.BRICK_OVEN_RECIPES, (Ingredient)output);
    }

    public static void blacklistSmeltingRecipe(Ingredient output) {
        BLACKLIST.add(output);
    }

    public static void whitelistSmeltingRecipe(Ingredient output) {
        WHITELIST.add(output);
    }

    public static boolean hasBlacklist() {
        return !BLACKLIST.isEmpty();
    }

    public static boolean hasWhitelist() {
        return !WHITELIST.isEmpty();
    }

    public static boolean isBlacklisted(ItemStack output) {
        for (Ingredient ingredient : BLACKLIST) {
            if (!ingredient.apply(output)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWhitelisted(ItemStack output) {
        for (Ingredient ingredient : WHITELIST) {
            if (!ingredient.apply(output)) continue;
            return true;
        }
        return false;
    }

    public BrickOvenRecipe(ItemStack output, Ingredient input) {
        super(input, output, ModuleTechMachineConfig.BRICK_OVEN.COOK_TIME_TICKS);
    }

    public BrickOvenRecipe(ItemStack output, Ingredient input, int cookTimeTicks) {
        super(input, output, cookTimeTicks);
    }
}

