/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.machine.plugin.jei.wrapper;

import com.codetaylor.mc.pyrotech.library.spi.plugin.jei.JEIRecipeWrapperTimed;
import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.spi.MachineRecipeBaseKiln;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class JEIRecipeWrapperKiln
extends JEIRecipeWrapperTimed {
    private final ResourceLocation registryName;
    private final List<List<ItemStack>> inputs;
    private final List<List<ItemStack>> outputs;
    private final String failureChance;

    public JEIRecipeWrapperKiln(MachineRecipeBaseKiln recipe) {
        super(recipe);
        this.registryName = recipe.getRegistryName();
        this.inputs = Collections.singletonList(Arrays.asList(recipe.getInput().func_193365_a()));
        this.outputs = new ArrayList<List<ItemStack>>();
        this.outputs.add(Collections.singletonList(recipe.getOutput()));
        this.outputs.add(Arrays.asList(recipe.getFailureItems()));
        this.failureChance = Util.translateFormatted("gui.pyrotech.jei.failure", (int)(recipe.getFailureChance() * 100.0f));
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.inputs);
        ingredients.setOutputLists(VanillaTypes.ITEM, this.outputs);
    }

    @Override
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
        int stringWidth = minecraft.field_71466_p.func_78256_a(this.failureChance);
        minecraft.field_71466_p.func_78276_b(this.failureChance, recipeWidth - stringWidth, 36, Color.DARK_GRAY.getRGB());
    }

    @Override
    protected int getTimeDisplayY() {
        return 24;
    }

    @Override
    @Nullable
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }
}

