/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.machine.plugin.jei;

import com.codetaylor.mc.athenaeum.util.RecipeHelper;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachine;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachineConfig;
import com.codetaylor.mc.pyrotech.modules.tech.machine.plugin.jei.category.JEIRecipeCategoryBrickCrucible;
import com.codetaylor.mc.pyrotech.modules.tech.machine.plugin.jei.category.JEIRecipeCategoryBrickKiln;
import com.codetaylor.mc.pyrotech.modules.tech.machine.plugin.jei.category.JEIRecipeCategoryBrickOven;
import com.codetaylor.mc.pyrotech.modules.tech.machine.plugin.jei.category.JEIRecipeCategoryBrickSawmill;
import com.codetaylor.mc.pyrotech.modules.tech.machine.plugin.jei.category.JEIRecipeCategoryMechanicalCompactingBin;
import com.codetaylor.mc.pyrotech.modules.tech.machine.plugin.jei.category.JEIRecipeCategoryStoneCrucible;
import com.codetaylor.mc.pyrotech.modules.tech.machine.plugin.jei.category.JEIRecipeCategoryStoneKiln;
import com.codetaylor.mc.pyrotech.modules.tech.machine.plugin.jei.category.JEIRecipeCategoryStoneOven;
import com.codetaylor.mc.pyrotech.modules.tech.machine.plugin.jei.category.JEIRecipeCategoryStoneSawmill;
import com.codetaylor.mc.pyrotech.modules.tech.machine.plugin.jei.wrapper.JEIRecipeWrapperCrucible;
import com.codetaylor.mc.pyrotech.modules.tech.machine.plugin.jei.wrapper.JEIRecipeWrapperKiln;
import com.codetaylor.mc.pyrotech.modules.tech.machine.plugin.jei.wrapper.JEIRecipeWrapperMechanicalCompactingBin;
import com.codetaylor.mc.pyrotech.modules.tech.machine.plugin.jei.wrapper.JEIRecipeWrapperOven;
import com.codetaylor.mc.pyrotech.modules.tech.machine.plugin.jei.wrapper.JEIRecipeWrapperSawmill;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.BrickCrucibleRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.BrickKilnRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.BrickOvenRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.BrickSawmillRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.MechanicalCompactingBinRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.StoneCrucibleRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.StoneKilnRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.StoneOvenRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.StoneSawmillRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class PluginJEI
implements IModPlugin {
    public void registerCategories(IRecipeCategoryRegistration registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new JEIRecipeCategoryStoneKiln(guiHelper), new JEIRecipeCategoryStoneSawmill(guiHelper), new JEIRecipeCategoryStoneOven(guiHelper), new JEIRecipeCategoryStoneCrucible(guiHelper), new JEIRecipeCategoryBrickKiln(guiHelper), new JEIRecipeCategoryBrickSawmill(guiHelper), new JEIRecipeCategoryBrickOven(guiHelper), new JEIRecipeCategoryBrickCrucible(guiHelper), new JEIRecipeCategoryMechanicalCompactingBin(guiHelper)});
    }

    public void register(IModRegistry registry) {
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleTechMachine.Blocks.STONE_OVEN), new String[]{"pyrotech.stone.oven"});
        registry.handleRecipes(StoneOvenRecipe.class, JEIRecipeWrapperOven::new, "pyrotech.stone.oven");
        List<JEIRecipeWrapperOven> furnaceRecipes = PluginJEI.getFurnaceRecipesForOven(input -> {
            ItemStack output = FurnaceRecipes.func_77602_a().func_151395_a(input);
            if (StoneOvenRecipe.hasWhitelist()) {
                return StoneOvenRecipe.isWhitelisted(output);
            }
            if (StoneOvenRecipe.hasBlacklist()) {
                return !StoneOvenRecipe.isBlacklisted(output);
            }
            return RecipeHelper.hasFurnaceFoodRecipe((ItemStack)input);
        }, ModuleTechMachineConfig.STONE_OVEN.COOK_TIME_TICKS);
        registry.addRecipes(furnaceRecipes, "pyrotech.stone.oven");
        ArrayList recipeList = new ArrayList(ModuleTechMachine.Registries.STONE_OVEN_RECIPES.getValuesCollection());
        registry.addRecipes(recipeList, "pyrotech.stone.oven");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleTechMachine.Blocks.BRICK_OVEN), new String[]{"pyrotech.brick.oven"});
        registry.handleRecipes(BrickOvenRecipe.class, JEIRecipeWrapperOven::new, "pyrotech.brick.oven");
        furnaceRecipes = PluginJEI.getFurnaceRecipesForOven(input -> {
            ItemStack output = FurnaceRecipes.func_77602_a().func_151395_a(input);
            if (BrickOvenRecipe.hasWhitelist()) {
                return BrickOvenRecipe.isWhitelisted(output);
            }
            if (BrickOvenRecipe.hasBlacklist()) {
                return !BrickOvenRecipe.isBlacklisted(output);
            }
            return RecipeHelper.hasFurnaceFoodRecipe((ItemStack)input);
        }, ModuleTechMachineConfig.BRICK_OVEN.COOK_TIME_TICKS);
        registry.addRecipes(furnaceRecipes, "pyrotech.brick.oven");
        recipeList = new ArrayList(ModuleTechMachine.Registries.BRICK_OVEN_RECIPES.getValuesCollection());
        registry.addRecipes(recipeList, "pyrotech.brick.oven");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleTechMachine.Blocks.MECHANICAL_COMPACTING_BIN), new String[]{"pyrotech.mechanical.compacting.bin"});
        registry.handleRecipes(MechanicalCompactingBinRecipe.class, JEIRecipeWrapperMechanicalCompactingBin::new, "pyrotech.mechanical.compacting.bin");
        ArrayList recipeList2 = new ArrayList(ModuleTechMachine.Registries.MECHANICAL_COMPACTING_BIN_RECIPES.getValuesCollection());
        registry.addRecipes(recipeList2, "pyrotech.mechanical.compacting.bin");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleTechMachine.Blocks.STONE_CRUCIBLE), new String[]{"pyrotech.stone.crucible"});
        registry.handleRecipes(StoneCrucibleRecipe.class, JEIRecipeWrapperCrucible::new, "pyrotech.stone.crucible");
        recipeList2 = new ArrayList(ModuleTechMachine.Registries.STONE_CRUCIBLE_RECIPES.getValuesCollection());
        registry.addRecipes(recipeList2, "pyrotech.stone.crucible");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleTechMachine.Blocks.BRICK_CRUCIBLE), new String[]{"pyrotech.brick.crucible"});
        registry.handleRecipes(BrickCrucibleRecipe.class, JEIRecipeWrapperCrucible::new, "pyrotech.brick.crucible");
        recipeList2 = new ArrayList(ModuleTechMachine.Registries.BRICK_CRUCIBLE_RECIPES.getValuesCollection());
        registry.addRecipes(recipeList2, "pyrotech.brick.crucible");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleTechMachine.Blocks.STONE_SAWMILL), new String[]{"pyrotech.stone.mill"});
        registry.handleRecipes(StoneSawmillRecipe.class, JEIRecipeWrapperSawmill::new, "pyrotech.stone.mill");
        recipeList2 = new ArrayList(ModuleTechMachine.Registries.STONE_SAWMILL_RECIPES.getValuesCollection());
        String[] validBladeStrings = ModuleTechMachineConfig.STONE_SAWMILL.SAWMILL_BLADES;
        List validBlades = Stream.of(validBladeStrings).map(s -> {
            ResourceLocation resourceLocation = new ResourceLocation(s);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
            return item == null ? ItemStack.field_190927_a : new ItemStack(item);
        }).filter(itemStack -> !itemStack.func_190926_b()).collect(Collectors.toList());
        List validRecipeList = recipeList2.stream().filter(recipe -> {
            for (ItemStack validBlade : validBlades) {
                if (!recipe.getBlade().apply(validBlade)) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        registry.addRecipes(validRecipeList, "pyrotech.stone.mill");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleTechMachine.Blocks.BRICK_SAWMILL), new String[]{"pyrotech.brick.mill"});
        registry.handleRecipes(BrickSawmillRecipe.class, JEIRecipeWrapperSawmill::new, "pyrotech.brick.mill");
        recipeList2 = new ArrayList(ModuleTechMachine.Registries.BRICK_SAWMILL_RECIPES.getValuesCollection());
        validBladeStrings = ModuleTechMachineConfig.BRICK_SAWMILL.SAWMILL_BLADES;
        validBlades = Stream.of(validBladeStrings).map(s -> {
            ResourceLocation resourceLocation = new ResourceLocation(s);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
            return item == null ? ItemStack.field_190927_a : new ItemStack(item);
        }).filter(itemStack -> !itemStack.func_190926_b()).collect(Collectors.toList());
        validRecipeList = recipeList2.stream().filter(recipe -> {
            for (ItemStack validBlade : validBlades) {
                if (!recipe.getBlade().apply(validBlade)) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        registry.addRecipes(validRecipeList, "pyrotech.brick.mill");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleTechMachine.Blocks.STONE_KILN), new String[]{"pyrotech.stone.kiln"});
        registry.handleRecipes(StoneKilnRecipe.class, JEIRecipeWrapperKiln::new, "pyrotech.stone.kiln");
        recipeList2 = new ArrayList(ModuleTechMachine.Registries.STONE_KILN_RECIPES.getValuesCollection());
        registry.addRecipes(recipeList2, "pyrotech.stone.kiln");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModuleTechMachine.Blocks.BRICK_KILN), new String[]{"pyrotech.brick.kiln"});
        registry.handleRecipes(BrickKilnRecipe.class, JEIRecipeWrapperKiln::new, "pyrotech.brick.kiln");
        recipeList2 = new ArrayList(ModuleTechMachine.Registries.BRICK_KILN_RECIPES.getValuesCollection());
        registry.addRecipes(recipeList2, "pyrotech.brick.kiln");
    }

    private static List<JEIRecipeWrapperOven> getFurnaceRecipesForOven(Predicate<ItemStack> filter, int cookTimeTicks) {
        FurnaceRecipes furnaceRecipes = FurnaceRecipes.func_77602_a();
        Map smeltingMap = furnaceRecipes.func_77599_b();
        ArrayList<JEIRecipeWrapperOven> recipes = new ArrayList<JEIRecipeWrapperOven>();
        for (Map.Entry entry : smeltingMap.entrySet()) {
            ItemStack input = (ItemStack)entry.getKey();
            if (!filter.test(input)) continue;
            ItemStack output = (ItemStack)entry.getValue();
            recipes.add(new JEIRecipeWrapperOven(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{input}), output, cookTimeTicks));
        }
        return recipes;
    }
}

