/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.machine;

import com.codetaylor.mc.athenaeum.module.ModuleBase;
import com.codetaylor.mc.athenaeum.network.IPacketService;
import com.codetaylor.mc.athenaeum.network.tile.ITileDataService;
import com.codetaylor.mc.athenaeum.registry.Registry;
import com.codetaylor.mc.pyrotech.ModPyrotech;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.machine.block.BlockBellows;
import com.codetaylor.mc.pyrotech.modules.tech.machine.block.BlockBrickCrucible;
import com.codetaylor.mc.pyrotech.modules.tech.machine.block.BlockBrickKiln;
import com.codetaylor.mc.pyrotech.modules.tech.machine.block.BlockBrickOven;
import com.codetaylor.mc.pyrotech.modules.tech.machine.block.BlockBrickSawmill;
import com.codetaylor.mc.pyrotech.modules.tech.machine.block.BlockMechanicalBellows;
import com.codetaylor.mc.pyrotech.modules.tech.machine.block.BlockMechanicalCompactingBin;
import com.codetaylor.mc.pyrotech.modules.tech.machine.block.BlockMechanicalHopper;
import com.codetaylor.mc.pyrotech.modules.tech.machine.block.BlockMechanicalMulchSpreader;
import com.codetaylor.mc.pyrotech.modules.tech.machine.block.BlockStoneCrucible;
import com.codetaylor.mc.pyrotech.modules.tech.machine.block.BlockStoneKiln;
import com.codetaylor.mc.pyrotech.modules.tech.machine.block.BlockStoneOven;
import com.codetaylor.mc.pyrotech.modules.tech.machine.block.BlockStoneSawmill;
import com.codetaylor.mc.pyrotech.modules.tech.machine.event.CogTooltipEventHandler;
import com.codetaylor.mc.pyrotech.modules.tech.machine.init.BlockInitializer;
import com.codetaylor.mc.pyrotech.modules.tech.machine.init.ItemInitializer;
import com.codetaylor.mc.pyrotech.modules.tech.machine.init.RegistryInitializer;
import com.codetaylor.mc.pyrotech.modules.tech.machine.init.recipe.BrickCrucibleRecipesAdd;
import com.codetaylor.mc.pyrotech.modules.tech.machine.init.recipe.BrickKilnRecipesAdd;
import com.codetaylor.mc.pyrotech.modules.tech.machine.init.recipe.BrickOvenRecipesAdd;
import com.codetaylor.mc.pyrotech.modules.tech.machine.init.recipe.BrickSawmillRecipesAdd;
import com.codetaylor.mc.pyrotech.modules.tech.machine.init.recipe.MechanicalCompactingBinRecipesAdd;
import com.codetaylor.mc.pyrotech.modules.tech.machine.init.recipe.StoneCrucibleRecipesAdd;
import com.codetaylor.mc.pyrotech.modules.tech.machine.init.recipe.StoneKilnRecipesAdd;
import com.codetaylor.mc.pyrotech.modules.tech.machine.init.recipe.StoneOvenRecipesAdd;
import com.codetaylor.mc.pyrotech.modules.tech.machine.init.recipe.StoneSawmillRecipesAdd;
import com.codetaylor.mc.pyrotech.modules.tech.machine.item.ItemCog;
import com.codetaylor.mc.pyrotech.modules.tech.machine.item.ItemSawmillBlade;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.BrickCrucibleRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.BrickKilnRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.BrickOvenRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.BrickSawmillRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.MechanicalCompactingBinRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.StoneCrucibleRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.StoneKilnRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.StoneOvenRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.StoneSawmillRecipe;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModuleTechMachine
extends ModuleBase {
    public static final String MODULE_ID = "module.tech.machine";
    public static final String MOD_ID = "pyrotech";
    public static final CreativeTabs CREATIVE_TAB = ModPyrotech.CREATIVE_TAB;
    public static final Logger LOGGER = LogManager.getLogger((String)("pyrotech." + ModuleTechMachine.class.getSimpleName()));
    public static IPacketService PACKET_SERVICE;
    public static ITileDataService TILE_DATA_SERVICE;

    public ModuleTechMachine() {
        super(0, MOD_ID);
        String[] craftTweakerPlugins;
        this.setRegistry(new Registry(MOD_ID, CREATIVE_TAB));
        this.enableAutoRegistry();
        PACKET_SERVICE = this.enableNetwork();
        TILE_DATA_SERVICE = this.enableNetworkTileDataService(PACKET_SERVICE);
        MinecraftForge.EVENT_BUS.register((Object)this);
        for (String plugin : craftTweakerPlugins = new String[]{"ZenStoneKiln", "ZenStoneSawmill", "ZenStoneCrucible", "ZenStoneOven", "ZenBrickKiln", "ZenBrickSawmill", "ZenBrickCrucible", "ZenBrickOven", "ZenMechanicalCompactingBin", "ZenMechanicalHopper", "ZenMechanicalMulcher", "ZenMechanicalBellows", "ZenBellows"}) {
            this.registerIntegrationPlugin("crafttweaker", "com.codetaylor.mc.pyrotech.modules.tech.machine.plugin.crafttweaker." + plugin);
        }
        this.registerIntegrationPlugin("jei", "com.codetaylor.mc.pyrotech.modules.tech.machine.plugin.jei.PluginJEI");
    }

    @SubscribeEvent
    public void onNewRegistryEvent(RegistryEvent.NewRegistry event) {
        RegistryInitializer.createRegistries(event);
    }

    public void onPreInitializationEvent(FMLPreInitializationEvent event) {
        super.onPreInitializationEvent(event);
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)"com.codetaylor.mc.pyrotech.modules.tech.machine.plugin.top.PluginTOP$Callback");
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientPreInitializationEvent(FMLPreInitializationEvent event) {
        super.onClientPreInitializationEvent(event);
        MinecraftForge.EVENT_BUS.register((Object)new CogTooltipEventHandler());
        FMLInterModComms.sendMessage((String)"waila", (String)"register", (String)"com.codetaylor.mc.pyrotech.modules.tech.machine.plugin.waila.PluginWaila.wailaCallback");
    }

    @SubscribeEvent
    public void on(RegistryEvent.Register<SoundEvent> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)Sounds.SAWMILL_IDLE);
        registry.register((IForgeRegistryEntry)Sounds.SAWMILL_ACTIVE);
        registry.register((IForgeRegistryEntry)Sounds.SAWMILL_ACTIVE_SHORT_A);
        registry.register((IForgeRegistryEntry)Sounds.SAWMILL_ACTIVE_SHORT_B);
    }

    public void onRegisterRecipesEvent(RegistryEvent.Register<IRecipe> event) {
        super.onRegisterRecipesEvent(event);
        StoneKilnRecipesAdd.apply(Registries.STONE_KILN_RECIPES);
        StoneSawmillRecipesAdd.apply(Registries.STONE_SAWMILL_RECIPES);
        StoneCrucibleRecipesAdd.apply(Registries.STONE_CRUCIBLE_RECIPES);
        StoneOvenRecipesAdd.apply(Registries.STONE_OVEN_RECIPES);
        BrickKilnRecipesAdd.apply(Registries.BRICK_KILN_RECIPES);
        BrickSawmillRecipesAdd.apply(Registries.BRICK_SAWMILL_RECIPES);
        BrickCrucibleRecipesAdd.apply(Registries.BRICK_CRUCIBLE_RECIPES);
        BrickOvenRecipesAdd.apply(Registries.BRICK_OVEN_RECIPES);
        MechanicalCompactingBinRecipesAdd.apply(Registries.MECHANICAL_COMPACTING_BIN_RECIPES);
        StoneKilnRecipesAdd.registerInheritedRecipes(ModuleTechBasic.Registries.KILN_PIT_RECIPE, Registries.STONE_KILN_RECIPES);
        StoneOvenRecipesAdd.registerInheritedDryingRackRecipes(ModuleTechBasic.Registries.DRYING_RACK_RECIPE, Registries.STONE_OVEN_RECIPES);
        StoneSawmillRecipesAdd.registerInheritedChoppingBlockRecipes(ModuleTechBasic.Registries.CHOPPING_BLOCK_RECIPE, Registries.STONE_SAWMILL_RECIPES);
        BrickKilnRecipesAdd.registerInheritedRecipes(Registries.STONE_KILN_RECIPES, Registries.BRICK_KILN_RECIPES);
        BrickOvenRecipesAdd.registerInheritedRecipes(Registries.STONE_OVEN_RECIPES, Registries.BRICK_OVEN_RECIPES);
        BrickSawmillRecipesAdd.registerInheritedRecipes(Registries.STONE_SAWMILL_RECIPES, Registries.BRICK_SAWMILL_RECIPES);
        BrickCrucibleRecipesAdd.registerInheritedRecipes(Registries.STONE_CRUCIBLE_RECIPES, Registries.BRICK_CRUCIBLE_RECIPES);
        MechanicalCompactingBinRecipesAdd.registerInheritedRecipes(ModuleTechBasic.Registries.COMPACTING_BIN_RECIPE, Registries.MECHANICAL_COMPACTING_BIN_RECIPES);
    }

    public void onRegister(Registry registry) {
        BlockInitializer.onRegister(registry);
        ItemInitializer.onRegister(registry);
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientRegister(Registry registry) {
        BlockInitializer.onClientRegister(registry);
        ItemInitializer.onClientRegister(registry);
    }

    public static class Registries {
        public static final IForgeRegistryModifiable<StoneKilnRecipe> STONE_KILN_RECIPES = null;
        public static final IForgeRegistryModifiable<StoneSawmillRecipe> STONE_SAWMILL_RECIPES = null;
        public static final IForgeRegistryModifiable<StoneOvenRecipe> STONE_OVEN_RECIPES = null;
        public static final IForgeRegistryModifiable<StoneCrucibleRecipe> STONE_CRUCIBLE_RECIPES = null;
        public static final IForgeRegistryModifiable<BrickKilnRecipe> BRICK_KILN_RECIPES = null;
        public static final IForgeRegistryModifiable<BrickSawmillRecipe> BRICK_SAWMILL_RECIPES = null;
        public static final IForgeRegistryModifiable<BrickOvenRecipe> BRICK_OVEN_RECIPES = null;
        public static final IForgeRegistryModifiable<BrickCrucibleRecipe> BRICK_CRUCIBLE_RECIPES = null;
        public static final IForgeRegistryModifiable<MechanicalCompactingBinRecipe> MECHANICAL_COMPACTING_BIN_RECIPES = null;
    }

    public static class Sounds {
        public static final SoundEvent SAWMILL_IDLE;
        public static final SoundEvent SAWMILL_ACTIVE;
        public static final SoundEvent SAWMILL_ACTIVE_SHORT_A;
        public static final SoundEvent SAWMILL_ACTIVE_SHORT_B;

        static {
            ResourceLocation sawmill_idle = new ResourceLocation(ModuleTechMachine.MOD_ID, "sawmill_idle");
            SAWMILL_IDLE = (SoundEvent)new SoundEvent(sawmill_idle).setRegistryName(sawmill_idle);
            ResourceLocation sawmill_active = new ResourceLocation(ModuleTechMachine.MOD_ID, "sawmill_active");
            SAWMILL_ACTIVE = (SoundEvent)new SoundEvent(sawmill_active).setRegistryName(sawmill_active);
            ResourceLocation sawmill_active_short_a = new ResourceLocation(ModuleTechMachine.MOD_ID, "sawmill_active_short_a");
            SAWMILL_ACTIVE_SHORT_A = (SoundEvent)new SoundEvent(sawmill_active_short_a).setRegistryName(sawmill_active_short_a);
            ResourceLocation sawmill_active_short_b = new ResourceLocation(ModuleTechMachine.MOD_ID, "sawmill_active_short_b");
            SAWMILL_ACTIVE_SHORT_B = (SoundEvent)new SoundEvent(sawmill_active_short_b).setRegistryName(sawmill_active_short_b);
        }
    }

    @GameRegistry.ObjectHolder(value="pyrotech")
    public static class Items {
        @GameRegistry.ObjectHolder(value="sawmill_blade_stone")
        public static final ItemSawmillBlade STONE_MILL_BLADE = null;
        @GameRegistry.ObjectHolder(value="sawmill_blade_flint")
        public static final ItemSawmillBlade FLINT_MILL_BLADE = null;
        @GameRegistry.ObjectHolder(value="sawmill_blade_bone")
        public static final ItemSawmillBlade BONE_MILL_BLADE = null;
        @GameRegistry.ObjectHolder(value="sawmill_blade_iron")
        public static final ItemSawmillBlade IRON_MILL_BLADE = null;
        @GameRegistry.ObjectHolder(value="sawmill_blade_gold")
        public static final ItemSawmillBlade GOLD_MILL_BLADE = null;
        @GameRegistry.ObjectHolder(value="sawmill_blade_diamond")
        public static final ItemSawmillBlade DIAMOND_MILL_BLADE = null;
        @GameRegistry.ObjectHolder(value="sawmill_blade_obsidian")
        public static final ItemSawmillBlade OBSIDIAN_MILL_BLADE = null;
        @GameRegistry.ObjectHolder(value="cog_wood")
        public static final ItemCog WOOD_COG = null;
        @GameRegistry.ObjectHolder(value="cog_stone")
        public static final ItemCog STONE_COG = null;
        @GameRegistry.ObjectHolder(value="cog_flint")
        public static final ItemCog FLINT_COG = null;
        @GameRegistry.ObjectHolder(value="cog_bone")
        public static final ItemCog BONE_COG = null;
        @GameRegistry.ObjectHolder(value="cog_iron")
        public static final ItemCog IRON_COG = null;
        @GameRegistry.ObjectHolder(value="cog_gold")
        public static final ItemCog GOLD_COG = null;
        @GameRegistry.ObjectHolder(value="cog_diamond")
        public static final ItemCog DIAMOND_COG = null;
        @GameRegistry.ObjectHolder(value="cog_obsidian")
        public static final ItemCog OBSIDIAN_COG = null;
    }

    @GameRegistry.ObjectHolder(value="pyrotech")
    public static class Blocks {
        @GameRegistry.ObjectHolder(value="stone_kiln")
        public static final BlockStoneKiln STONE_KILN = null;
        @GameRegistry.ObjectHolder(value="brick_kiln")
        public static final BlockBrickKiln BRICK_KILN;
        @GameRegistry.ObjectHolder(value="stone_oven")
        public static final BlockStoneOven STONE_OVEN;
        @GameRegistry.ObjectHolder(value="brick_oven")
        public static final BlockBrickOven BRICK_OVEN;
        @GameRegistry.ObjectHolder(value="stone_sawmill")
        public static final BlockStoneSawmill STONE_SAWMILL;
        @GameRegistry.ObjectHolder(value="brick_sawmill")
        public static final BlockBrickSawmill BRICK_SAWMILL;
        @GameRegistry.ObjectHolder(value="stone_crucible")
        public static final BlockStoneCrucible STONE_CRUCIBLE;
        @GameRegistry.ObjectHolder(value="brick_crucible")
        public static final BlockBrickCrucible BRICK_CRUCIBLE;
        @GameRegistry.ObjectHolder(value="mechanical_hopper")
        public static final BlockMechanicalHopper STONE_HOPPER;
        @GameRegistry.ObjectHolder(value="mechanical_compacting_bin")
        public static final BlockMechanicalCompactingBin MECHANICAL_COMPACTING_BIN;
        @GameRegistry.ObjectHolder(value="mechanical_mulch_spreader")
        public static final BlockMechanicalMulchSpreader MECHANICAL_MULCH_SPREADER;
        @GameRegistry.ObjectHolder(value="bellows")
        public static final BlockBellows BELLOWS;
        @GameRegistry.ObjectHolder(value="mechanical_bellows")
        public static final BlockMechanicalBellows MECHANICAL_BELLOWS;

        static {
            STONE_OVEN = null;
            STONE_SAWMILL = null;
            STONE_CRUCIBLE = null;
            BRICK_KILN = null;
            BRICK_OVEN = null;
            BRICK_SAWMILL = null;
            BRICK_CRUCIBLE = null;
            STONE_HOPPER = null;
            MECHANICAL_COMPACTING_BIN = null;
            MECHANICAL_MULCH_SPREADER = null;
            BELLOWS = null;
            MECHANICAL_BELLOWS = null;
        }
    }
}

