/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.bloomery.recipe;

import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.AnvilRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.ModuleTechBloomery;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.recipe.BloomeryRecipeBase;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;

public abstract class BloomeryRecipeBuilderBase<R extends BloomeryRecipeBase, B extends BloomeryRecipeBuilderBase> {
    @Nullable
    protected final ResourceLocation resourceLocation;
    protected ItemStack output;
    protected Ingredient input;
    protected int burnTimeTicks;
    protected float failureChance;
    protected int bloomYieldMin;
    protected int bloomYieldMax;
    protected int slagCount;
    protected ItemStack slagItem;
    protected List<BloomeryRecipeBase.FailureItem> failureItems;
    protected AnvilRecipe.EnumTier[] anvilTiers;
    @Nullable
    protected String langKey;

    public BloomeryRecipeBuilderBase(@Nullable ResourceLocation resourceLocation, ItemStack output, Ingredient input) {
        this.resourceLocation = resourceLocation;
        this.output = (ItemStack)Preconditions.checkNotNull((Object)output);
        this.input = (Ingredient)Preconditions.checkNotNull((Object)input);
        this.burnTimeTicks = 21600;
        this.failureChance = 0.25f;
        this.bloomYieldMin = 8;
        this.bloomYieldMax = 10;
        this.slagCount = 4;
        this.slagItem = new ItemStack(ModuleTechBloomery.Items.SLAG);
        this.failureItems = new ArrayList<BloomeryRecipeBase.FailureItem>(1);
        this.anvilTiers = AnvilRecipe.EnumTier.values();
    }

    public B setBurnTimeTicks(int burnTimeTicks) {
        this.burnTimeTicks = burnTimeTicks;
        return (B)this;
    }

    public B setFailureChance(float failureChance) {
        this.failureChance = failureChance;
        return (B)this;
    }

    public B setBloomYield(int min, int max) {
        this.bloomYieldMin = min;
        this.bloomYieldMax = max;
        return (B)this;
    }

    public B setSlagItem(ItemStack slagItem, int slagCount) {
        this.slagItem = slagItem.func_77946_l();
        this.slagItem.func_190920_e(1);
        this.slagCount = slagCount;
        return (B)this;
    }

    public B addFailureItem(ItemStack itemStack, int weight) {
        this.failureItems.add(new BloomeryRecipeBase.FailureItem(itemStack, weight));
        return (B)this;
    }

    public B setAnvilTiers(AnvilRecipe.EnumTier[] anvilTiers) {
        this.anvilTiers = Arrays.copyOf(anvilTiers, anvilTiers.length);
        return (B)this;
    }

    public B setLangKey(@Nullable String langKey) {
        this.langKey = langKey;
        return (B)this;
    }

    public abstract R create();
}

