/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.bloomery.plugin.waila.delegate;

import com.codetaylor.mc.pyrotech.library.waila.ProviderDelegateBase;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.recipe.BloomeryRecipeBase;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.tile.TileBloomery;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class BloomeryProviderDelegate
extends ProviderDelegateBase<IBloomeryDisplay, TileBloomery> {
    public BloomeryProviderDelegate(IBloomeryDisplay display) {
        super(display);
    }

    @Override
    public void display(TileBloomery tile) {
        float progress = tile.getRecipeProgress();
        TileBloomery.InputStackHandler stackHandler = tile.getInputStackHandler();
        TileBloomery.OutputStackHandler outputStackHandler = tile.getOutputStackHandler();
        TileBloomery.FuelStackHandler fuelStackHandler = tile.getFuelStackHandler();
        ItemStack input = stackHandler.getStackInSlot(0);
        boolean hasOutput = !outputStackHandler.getStackInSlot(0).func_190926_b();
        int fuelCount = fuelStackHandler.getTotalItemCount();
        if (!input.func_190926_b()) {
            BloomeryRecipeBase recipe = tile.getCurrentRecipe();
            if (recipe != null) {
                ItemStack recipeOutput = recipe.getOutputBloom();
                ((IBloomeryDisplay)this.display).setRecipeProgress(input, recipeOutput, (int)(100.0f * progress), 100);
            } else {
                ((IBloomeryDisplay)this.display).setInput(input);
            }
        } else if (hasOutput) {
            ((IBloomeryDisplay)this.display).setOutputItems((ItemStackHandler)outputStackHandler);
        }
        if (fuelCount > 0) {
            ((IBloomeryDisplay)this.display).setFuelItems((ItemStackHandler)fuelStackHandler);
        }
        ((IBloomeryDisplay)this.display).setSpeed("gui.pyrotech.waila.speed", (int)(tile.getSpeed() * 100.0f));
        ((IBloomeryDisplay)this.display).setAirflow("gui.pyrotech.waila.bloomery.airflow", (int)(tile.getAirflow() * 100.0f));
        ((IBloomeryDisplay)this.display).setFuelCount("gui.pyrotech.waila.bloomery.fuel", tile.getFuelCount(), tile.getMaxFuelCount());
    }

    public static interface IBloomeryDisplay {
        public void setRecipeProgress(ItemStack var1, ItemStack var2, int var3, int var4);

        public void setInput(ItemStack var1);

        public void setOutputItems(ItemStackHandler var1);

        public void setFuelItems(ItemStackHandler var1);

        public void setSpeed(String var1, int var2);

        public void setAirflow(String var1, int var2);

        public void setFuelCount(String var1, int var2, int var3);
    }
}

