/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.bloomery.plugin.jei;

import com.codetaylor.mc.pyrotech.library.spi.plugin.jei.PyrotechRecipeCategory;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.plugin.jei.JEIRecipeWrapperBloomery;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class JEIRecipeCategoryBloomery
extends PyrotechRecipeCategory<JEIRecipeWrapperBloomery> {
    public static final String UID_BLOOMERY = "pyrotech.bloomery";
    public static final String UID_WITHER_FORGE = "pyrotech.wither.forge";
    private final IDrawableAnimated animatedFlame;
    private final IDrawableAnimated arrow;
    private final IDrawable background;
    private final String title;
    private final String uid;

    public JEIRecipeCategoryBloomery(IGuiHelper guiHelper, String uid, String langKey) {
        this.uid = uid;
        ResourceLocation resourceLocation = new ResourceLocation("pyrotech", "textures/gui/jei7.png");
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(resourceLocation, 101, 14, 24, 17);
        IDrawableStatic staticFlame = guiHelper.createDrawable(resourceLocation, 101, 0, 14, 14);
        IDrawableAnimated.StartDirection left = IDrawableAnimated.StartDirection.LEFT;
        IDrawableAnimated.StartDirection top = IDrawableAnimated.StartDirection.TOP;
        this.animatedFlame = guiHelper.createAnimatedDrawable(staticFlame, 300, top, true);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, left, false);
        this.background = guiHelper.createDrawable(resourceLocation, 0, 0, 101, 40);
        this.title = Translator.translateToLocal((String)langKey);
    }

    @Nonnull
    public String getUid() {
        return this.uid;
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    @Nonnull
    public String getModName() {
        return "pyrotech";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
        this.animatedFlame.draw(minecraft, 1, 7);
        this.arrow.draw(minecraft, 24, 18);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void setRecipe(IRecipeLayout recipeLayout, JEIRecipeWrapperBloomery recipeWrapper, IIngredients ingredients) {
        super.setRecipe(recipeLayout, recipeWrapper, ingredients);
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 0, 22);
        itemStacks.init(1, false, 60, 18);
        itemStacks.init(2, false, 83, 22);
        itemStacks.set(ingredients);
    }

    @Override
    protected int getOutputSlotIndex() {
        return 1;
    }
}

