/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.bloomery.item.spi;

import com.codetaylor.mc.athenaeum.interaction.spi.IInteractionItem;
import com.codetaylor.mc.athenaeum.util.BlockHelper;
import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.spi.TileAnvilBase;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.ModuleTechBloomery;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.item.spi.ItemTongsEmptyBase;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.tile.TileBloom;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.util.BloomHelper;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class ItemTongsFullBase
extends Item
implements IInteractionItem {
    private final Supplier<ItemTongsEmptyBase> otherTongsSupplier;

    public ItemTongsFullBase(Supplier<ItemTongsEmptyBase> otherTongsSupplier, int durability) {
        this.otherTongsSupplier = otherTongsSupplier;
        this.func_77625_d(1);
        this.func_77656_e(durability);
    }

    public ItemTongsEmptyBase getItemTongsEmpty() {
        return this.otherTongsSupplier.get();
    }

    public boolean func_77616_k(@Nonnull ItemStack stack) {
        return false;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (hand != EnumHand.MAIN_HAND || heldItem.func_77973_b() != this) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)heldItem);
        }
        RayTraceResult target = this.func_77621_a(world, player, false);
        if (target == null || target.field_72313_a != RayTraceResult.Type.BLOCK) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)heldItem);
        }
        return this.onItemRightClick(world, player, heldItem, target);
    }

    private ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, ItemStack heldItem, RayTraceResult target) {
        EnumFacing sideHit = target.field_178784_b;
        BlockPos pos = target.func_178782_a();
        BlockPos offset = pos.func_177972_a(sideHit);
        NBTTagCompound tagCompound = heldItem.func_77978_p();
        if (ModuleTechBloomery.Blocks.BLOOM.func_176196_c(world, offset) && tagCompound != null) {
            ItemStack itemStack;
            if (!world.field_72995_K) {
                world.func_175656_a(offset, ModuleTechBloomery.Blocks.BLOOM.func_176223_P());
                TileBloom tile = (TileBloom)world.func_175625_s(offset);
                if (tile != null) {
                    BlockPos tilePos = tile.func_174877_v();
                    tile.func_145839_a(tagCompound.func_74775_l("BlockEntityTag"));
                    tile.func_174878_a(tilePos);
                    BlockHelper.notifyBlockUpdate((World)world, (BlockPos)offset);
                }
            }
            if ((itemStack = BloomHelper.createItemTongsEmpty(heldItem, !player.func_184812_l_())).func_190926_b()) {
                if (!world.field_72995_K) {
                    world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 1.0f, Util.RANDOM.nextFloat() * 0.4f + 0.8f);
                }
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)ItemStack.field_190927_a);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)heldItem);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        NBTTagCompound teCompound;
        String langKey;
        if (stack.func_77973_b() != this) {
            return;
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("BlockEntityTag") && I18n.func_94522_b((String)(langKey = (teCompound = tagCompound.func_74775_l("BlockEntityTag")).func_74779_i("langKey") + ".name"))) {
            String translatedLangKey = I18n.func_74838_a((String)langKey);
            String translatedTooltip = I18n.func_74837_a((String)(ModuleTechBloomery.Blocks.BLOOM.func_149739_a() + ".unique.name"), (Object[])new Object[]{translatedLangKey}).trim();
            if (tooltip.size() > 1) {
                tooltip.add(1, TextFormatting.DARK_RED + translatedTooltip + TextFormatting.RESET);
            } else {
                tooltip.add(TextFormatting.GOLD + translatedTooltip + TextFormatting.RESET);
            }
        }
        if (this.getDamage(stack) == 0) {
            tooltip.add(I18n.func_74837_a((String)"gui.pyrotech.tooltip.durability.full", (Object[])new Object[]{this.getMaxDamage(stack)}));
        }
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        return this.otherTongsSupplier.get().func_77653_i(stack);
    }

    public boolean allowInteraction(TileEntity tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
        if (tile instanceof TileAnvilBase) {
            return ((TileAnvilBase)tile).getStackHandler().getStackInSlot(0).func_190926_b();
        }
        return false;
    }

    public boolean doInteraction(TileEntity tile, World world, ItemStack heldItem, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
        if (tile instanceof TileAnvilBase) {
            NBTTagCompound tagCompound = heldItem.func_77978_p();
            if (tagCompound == null) {
                return false;
            }
            NBTTagCompound tileTag = tagCompound.func_74775_l("BlockEntityTag");
            ItemStack bloomStack = BloomHelper.createBloomAsItemStack(new ItemStack((Block)ModuleTechBloomery.Blocks.BLOOM), tileTag);
            ((TileAnvilBase)tile).getStackHandler().insertItem(0, bloomStack, false);
            ItemStack emptyTongsStack = BloomHelper.createItemTongsEmpty(heldItem, !player.func_184812_l_());
            heldItem.func_190918_g(1);
            if (!emptyTongsStack.func_190926_b()) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)emptyTongsStack, (int)player.field_71071_by.field_70461_c);
            }
            return true;
        }
        return false;
    }

    public void applyItemDamage(ItemStack itemStack, EntityPlayer player) {
    }
}

