/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.bloomery.item.spi;

import com.codetaylor.mc.athenaeum.interaction.spi.IInteractionItem;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.spi.TileAnvilBase;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.ModuleTechBloomery;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.item.spi.ItemTongsFullBase;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.tile.TileBloom;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.tile.TileBloomery;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.util.BloomHelper;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class ItemTongsEmptyBase
extends Item
implements IInteractionItem {
    private final Supplier<ItemTongsFullBase> otherTongsSupplier;

    public ItemTongsEmptyBase(Supplier<ItemTongsFullBase> otherTongsSupplier, int durability) {
        this.otherTongsSupplier = otherTongsSupplier;
        this.func_77625_d(1);
        this.func_77656_e(durability);
    }

    public ItemTongsFullBase getItemTongsFull() {
        return this.otherTongsSupplier.get();
    }

    public boolean func_77616_k(@Nonnull ItemStack stack) {
        return true;
    }

    public boolean allowInteraction(TileEntity tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
        if (tile instanceof TileAnvilBase) {
            return ((TileAnvilBase)tile).getStackHandler().getStackInSlot(0).func_77973_b() == ModuleTechBloomery.Items.BLOOM;
        }
        if (tile instanceof TileBloomery) {
            return ((TileBloomery)tile).getOutputStackHandler().getStackInSlot(0).func_77973_b() == ModuleTechBloomery.Items.BLOOM;
        }
        return tile instanceof TileBloom;
    }

    public boolean doInteraction(TileEntity tile, World world, ItemStack heldItem, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
        if (tile instanceof TileAnvilBase) {
            ItemStack bloomStack = ((TileAnvilBase)tile).getStackHandler().extractItem(0, 1, false);
            ItemStack tongsFull = BloomHelper.createItemTongsFull(heldItem, bloomStack);
            heldItem.func_190918_g(1);
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)tongsFull, (int)player.field_71071_by.field_70461_c);
            return true;
        }
        if (tile instanceof TileBloomery) {
            ItemStack bloomStack = ((TileBloomery)tile).getOutputStackHandler().extractItem(0, 1, false);
            ItemStack tongsFull = BloomHelper.createItemTongsFull(heldItem, bloomStack);
            heldItem.func_190918_g(1);
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)tongsFull, (int)player.field_71071_by.field_70461_c);
            return true;
        }
        if (tile instanceof TileBloom) {
            ItemStack bloomStack = BloomHelper.toItemStack((TileBloom)tile, new ItemStack((Block)ModuleTechBloomery.Blocks.BLOOM));
            ItemStack tongsFull = BloomHelper.createItemTongsFull(heldItem, bloomStack);
            if (!world.field_72995_K) {
                world.func_175698_g(tile.func_174877_v());
            }
            heldItem.func_190918_g(1);
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)tongsFull, (int)player.field_71071_by.field_70461_c);
        }
        return false;
    }

    public void applyItemDamage(ItemStack itemStack, EntityPlayer player) {
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        if (this.getDamage(stack) == 0) {
            tooltip.add(I18n.func_74837_a((String)"gui.pyrotech.tooltip.durability.full", (Object[])new Object[]{this.getMaxDamage(stack)}));
        }
    }
}

