/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.bloomery.block;

import com.codetaylor.mc.athenaeum.interaction.spi.IBlockInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.spi.IVariant;
import com.codetaylor.mc.athenaeum.util.AABBHelper;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.athenaeum.util.RandomHelper;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.library.spi.block.IBlockIgnitableAdjacentIgniterBlock;
import com.codetaylor.mc.pyrotech.library.spi.block.IBlockIgnitableWithIgniterItem;
import com.codetaylor.mc.pyrotech.library.spi.tile.ITileContainer;
import com.codetaylor.mc.pyrotech.modules.ignition.item.ItemIgniterBase;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.ModuleTechBloomeryConfig;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.client.particles.ParticleBloomeryDrip;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.tile.TileBloomery;
import java.util.Comparator;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBloomery
extends Block
implements IBlockInteractable,
IBlockIgnitableAdjacentIgniterBlock,
IBlockIgnitableWithIgniterItem {
    public static final String NAME = "bloomery";
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);
    private static final AxisAlignedBB AABB_TOP = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.5, 0.875);
    private static final AxisAlignedBB[] AABB_BOTTOM = new AxisAlignedBB[]{AABBHelper.create((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), AABBHelper.create((double)1.0, (double)8.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)};

    public BlockBloomery() {
        super(Material.field_151576_e);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(2.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)EnumFacing.NORTH).func_177226_a(TYPE, (Comparable)((Object)EnumType.Bottom)));
    }

    public boolean isTop(IBlockState state) {
        return state.func_177229_b(TYPE) == EnumType.Top;
    }

    @Override
    public void igniteWithAdjacentIgniterBlock(World world, BlockPos pos, IBlockState blockState, EnumFacing facing) {
        TileEntity tile;
        if (!this.isTop(blockState) && (tile = world.func_175625_s(pos)) instanceof TileBloomery) {
            ((TileBloomery)tile).setActive();
        }
    }

    @Override
    public void igniteWithIgniterItem(World world, BlockPos pos, IBlockState blockState, EnumFacing facing) {
        TileEntity candidate;
        TileEntity tile;
        if (this.isTop(blockState) && facing == EnumFacing.UP && (tile = world.func_175625_s(pos)) instanceof TileBloomery.Top && (candidate = world.func_175625_s(pos.func_177977_b())) instanceof TileBloomery) {
            ((TileBloomery)candidate).setActive();
        }
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (this.isTop(state)) {
            return AABB_TOP;
        }
        return super.func_185496_a(state, source, pos);
    }

    public boolean isSideSolid(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing face) {
        if (this.isTop(state)) {
            return false;
        }
        return face == EnumFacing.DOWN;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return this.func_149730_j(state);
    }

    public boolean func_149662_c(IBlockState state) {
        return this.func_149730_j(state);
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_149730_j(state);
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        if (this.isTop(state)) {
            return 0;
        }
        return super.quantityDropped(state, fortune, random);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem;
        if (this.isTop(state) && (heldItem = player.func_184614_ca()).func_77973_b() instanceof ItemIgniterBase) {
            return false;
        }
        return this.interact(IInteraction.EnumType.MouseClick, world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public boolean interact(IInteraction.EnumType type, World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.isTop(state)) {
            return super.interact(type, world, pos.func_177977_b(), state, player, hand, facing, hitX, hitY + 1.0f, hitZ);
        }
        return super.interact(type, world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileBloomery) {
            ((TileBloomery)tileEntity).updateAirflow();
        }
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        TileEntity tileEntity;
        if (this.getEntityWalkBurnDamage() > 0.0 && this.isTop(world.func_180495_p(pos)) && (tileEntity = world.func_175625_s(pos.func_177977_b())) instanceof TileBloomery && ((TileBloomery)tileEntity).isActive() && !entity.func_70045_F() && entity instanceof EntityLivingBase && !EnchantmentHelper.func_189869_j((EntityLivingBase)((EntityLivingBase)entity))) {
            entity.func_70097_a(DamageSource.field_190095_e, (float)this.getEntityWalkBurnDamage());
            entity.func_70015_d(4);
        }
        super.func_176199_a(world, pos, entity);
    }

    protected double getEntityWalkBurnDamage() {
        return ModuleTechBloomeryConfig.BLOOMERY.ENTITY_WALK_BURN_DAMAGE;
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        boolean hit;
        RayTraceResult result = super.func_180636_a(blockState, world, pos, start, end);
        if (this.isTop(blockState)) {
            return this.interactionRayTrace(result, blockState, world, pos.func_177977_b(), start, end);
        }
        boolean bl = hit = this.func_185503_a(pos, start, end, AABB_BOTTOM[0]) != null || this.func_185503_a(pos, start, end, AABB_BOTTOM[1]) != null;
        if (hit) {
            return this.interactionRayTrace(result, blockState, world, pos, start, end);
        }
        return null;
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (this.isTop(state)) {
            BlockPos down = pos.func_177977_b();
            if (world.func_180495_p(down).func_177230_c() == this) {
                TileEntity tileEntity = world.func_175625_s(down);
                if (tileEntity instanceof ITileContainer) {
                    ITileContainer tile = (ITileContainer)tileEntity;
                    tile.dropContents();
                }
                StackHelper.spawnStackOnTop((World)world, (ItemStack)new ItemStack((Block)this), (BlockPos)down);
                world.func_175698_g(down);
            }
        } else {
            TileEntity tileEntity;
            BlockPos up = pos.func_177984_a();
            if (world.func_180495_p(up).func_177230_c() == this) {
                world.func_175698_g(up);
            }
            if ((tileEntity = world.func_175625_s(pos)) instanceof ITileContainer) {
                ITileContainer tile = (ITileContainer)tileEntity;
                tile.dropContents();
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        BlockPos up;
        if (!this.isTop(state) && super.func_176196_c(world, up = pos.func_177984_a())) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
            world.func_175656_a(up, this.func_176223_P().func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)facing).func_177226_a(TYPE, (Comparable)((Object)EnumType.Top)));
        }
    }

    public boolean canSilkHarvest(World world, BlockPos pos, @Nonnull IBlockState state, EntityPlayer player) {
        return false;
    }

    public boolean func_176196_c(World world, @Nonnull BlockPos pos) {
        return super.func_176196_c(world, pos) && super.func_176196_c(world, pos.func_177984_a());
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.func_176221_a(state, world, pos).func_177229_b(TYPE) == EnumType.BottomLit) {
            return 12;
        }
        return super.getLightValue(state, world, pos);
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity;
        if (!this.isTop(state) && (tileEntity = world.func_175625_s(pos)) instanceof TileBloomery && ((TileBloomery)tileEntity).isActive()) {
            return state.func_177226_a(TYPE, (Comparable)((Object)EnumType.BottomLit));
        }
        return super.func_176221_a(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.isTop(state)) {
            TileEntity tileEntity = world.func_175625_s(pos.func_177977_b());
            if (tileEntity instanceof TileBloomery && ((TileBloomery)tileEntity).isActive()) {
                double offsetZ;
                double offsetX;
                int i;
                double x = (double)pos.func_177958_n() + 0.5;
                double y = (double)pos.func_177956_o() + 0.25 + rand.nextDouble() * 2.0 / 16.0;
                double z = (double)pos.func_177952_p() + 0.5;
                if (rand.nextDouble() < 0.1) {
                    world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                }
                for (i = 0; i < 8; ++i) {
                    offsetX = (rand.nextDouble() * 2.0 - 1.0) * 0.2;
                    double offsetY = 0.25 + (rand.nextDouble() * 2.0 - 1.0) * 0.25;
                    double offsetZ2 = (rand.nextDouble() * 2.0 - 1.0) * 0.2;
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + offsetX, y + offsetY, z + offsetZ2, 0.0, 0.0, 0.0, new int[0]);
                }
                for (i = 0; i < 4; ++i) {
                    offsetX = (rand.nextDouble() * 2.0 - 1.0) * 0.2;
                    offsetZ = (rand.nextDouble() * 2.0 - 1.0) * 0.2;
                    world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, x + offsetX, y, z + offsetZ, 0.0, 0.0, 0.0, new int[0]);
                }
                for (i = 0; i < 4; ++i) {
                    offsetX = (rand.nextDouble() * 2.0 - 1.0) * 0.2;
                    offsetZ = (rand.nextDouble() * 2.0 - 1.0) * 0.2;
                    world.func_175688_a(EnumParticleTypes.FLAME, x + offsetX, y, z + offsetZ, 0.0, 0.0, 0.0, new int[0]);
                }
                if ((double)RandomHelper.random().nextFloat() < 0.05) {
                    double offsetX2 = (rand.nextDouble() * 2.0 - 1.0) * 0.2;
                    double offsetZ3 = (rand.nextDouble() * 2.0 - 1.0) * 0.2;
                    world.func_175688_a(EnumParticleTypes.LAVA, x + offsetX2, y, z + offsetZ3, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        } else {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TileBloomery && ((TileBloomery)tileEntity).isActive()) {
                EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
                double offsetY = rand.nextDouble() * 6.0 / 16.0;
                double x = (double)pos.func_177958_n() + 0.5;
                double y = (double)pos.func_177956_o() + offsetY;
                double z = (double)pos.func_177952_p() + 0.5;
                double randomOffset = rand.nextDouble() * 0.4 - 0.2;
                if (rand.nextDouble() < 0.1) {
                    world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                }
                double offset = 0.55;
                double lavaOffset = 0.075;
                double dripChance = 0.25;
                switch (enumfacing) {
                    case WEST: {
                        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x - offset, y, z + randomOffset, 0.0, 0.0, 0.0, new int[0]);
                        world.func_175688_a(EnumParticleTypes.FLAME, x - offset, y, z + randomOffset, 0.0, 0.0, 0.0, new int[0]);
                        if (!((double)rand.nextFloat() < dripChance)) break;
                        world.func_175688_a(EnumParticleTypes.FLAME, x - offset, y, z + randomOffset, 0.0, 0.0, 0.0, new int[0]);
                        Minecraft.func_71410_x().field_71452_i.func_78873_a(ParticleBloomeryDrip.createParticle(world, x - offset - lavaOffset, y - offsetY, z));
                        break;
                    }
                    case EAST: {
                        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + offset, y, z + randomOffset, 0.0, 0.0, 0.0, new int[0]);
                        world.func_175688_a(EnumParticleTypes.FLAME, x + offset, y, z + randomOffset, 0.0, 0.0, 0.0, new int[0]);
                        if (!((double)rand.nextFloat() < dripChance)) break;
                        world.func_175688_a(EnumParticleTypes.FLAME, x + offset, y, z + randomOffset, 0.0, -0.1, 0.0, new int[0]);
                        Minecraft.func_71410_x().field_71452_i.func_78873_a(ParticleBloomeryDrip.createParticle(world, x + offset + lavaOffset, y - offsetY, z));
                        break;
                    }
                    case NORTH: {
                        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + randomOffset, y, z - offset, 0.0, 0.0, 0.0, new int[0]);
                        world.func_175688_a(EnumParticleTypes.FLAME, x + randomOffset, y, z - offset, 0.0, 0.0, 0.0, new int[0]);
                        if (!((double)rand.nextFloat() < dripChance)) break;
                        world.func_175688_a(EnumParticleTypes.FLAME, x + randomOffset, y, z - offset, 0.0, -0.1, 0.0, new int[0]);
                        Minecraft.func_71410_x().field_71452_i.func_78873_a(ParticleBloomeryDrip.createParticle(world, x, y - offsetY, z - offset - lavaOffset));
                        break;
                    }
                    case SOUTH: {
                        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + randomOffset, y, z + offset, 0.0, 0.0, 0.0, new int[0]);
                        world.func_175688_a(EnumParticleTypes.FLAME, x + randomOffset, y, z + offset, 0.0, 0.0, 0.0, new int[0]);
                        if (!((double)rand.nextFloat() < dripChance)) break;
                        world.func_175688_a(EnumParticleTypes.FLAME, x + randomOffset, y, z + offset, 0.0, -0.1, 0.0, new int[0]);
                        Minecraft.func_71410_x().field_71452_i.func_78873_a(ParticleBloomeryDrip.createParticle(world, x, y - offsetY, z + offset + lavaOffset));
                    }
                }
            }
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        if (this.isTop(state)) {
            return new TileBloomery.Top();
        }
        return new TileBloomery();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{Properties.FACING_HORIZONTAL, TYPE});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        int type = meta >> 2 & 3;
        int facingIndex = (meta & 3) + 2;
        return this.func_176223_P().func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)EnumFacing.field_82609_l[facingIndex]).func_177226_a(TYPE, (Comparable)((Object)EnumType.fromMeta(type)));
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        EnumType type = (EnumType)((Object)state.func_177229_b(TYPE));
        int meta = facing.func_176745_a() - 2;
        return meta |= type.getMeta() << 2;
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, EnumHand hand) {
        EnumFacing opposite = placer.func_174811_aO().func_176734_d();
        return this.func_176223_P().func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)opposite);
    }

    public static enum EnumType implements IVariant
    {
        Top(0, "top"),
        Bottom(1, "bottom"),
        BottomLit(2, "bottom_lit");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public static EnumType fromMeta(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = (EnumType[])Stream.of(EnumType.values()).sorted(Comparator.comparing(EnumType::getMeta)).toArray(EnumType[]::new);
        }
    }
}

