/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.bloomery.block;

import com.codetaylor.mc.athenaeum.interaction.spi.IBlockInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.spi.BlockPartialBase;
import com.codetaylor.mc.athenaeum.util.AABBHelper;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.ModuleTechBloomeryConfig;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.tile.TileBloom;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.util.BloomHelper;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBloom
extends BlockPartialBase
implements IBlockInteractable {
    public static final AxisAlignedBB AABB = AABBHelper.create((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    public static final String NAME = "bloom";

    public BlockBloom() {
        super(Material.field_151576_e);
        this.func_149711_c(7.5f);
        this.func_149752_b(30.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149675_a(true);
    }

    public CreativeTabs func_149708_J() {
        return null;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 9;
    }

    public int func_149750_m(IBlockState state) {
        return 9;
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        if (ModuleTechBloomeryConfig.BLOOM.ENTITY_WALK_DAMAGE > 0.0 && !entity.func_70045_F() && entity instanceof EntityLivingBase && !EnchantmentHelper.func_189869_j((EntityLivingBase)((EntityLivingBase)entity))) {
            entity.func_70097_a(DamageSource.field_190095_e, (float)ModuleTechBloomeryConfig.BLOOM.ENTITY_WALK_DAMAGE);
        }
        super.func_176199_a(world, pos, entity);
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        return this.interactionRayTrace(super.func_180636_a(blockState, world, pos, start, end), blockState, world, pos, start, end);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.interact(IInteraction.EnumType.MouseClick, world, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(@Nonnull World world, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        if (!world.field_72995_K) {
            world.func_175698_g(pos);
        }
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_176196_c(World world, @Nonnull BlockPos pos) {
        BlockPos down = pos.func_177977_b();
        IBlockState blockState = world.func_180495_p(down);
        return super.func_176196_c(world, pos) && blockState.func_177230_c().isSideSolid(blockState, (IBlockAccess)world, down, EnumFacing.UP);
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        TileBloom tile;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileBloom && (tile = (TileBloom)tileEntity).getIntegrity() > 0) {
            drops.add((Object)BloomHelper.toItemStack(tile));
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.checkFire(world, pos, rand);
        this.checkFall(world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 0.25 + rand.nextDouble() * 2.0 / 16.0;
        double z = (double)pos.func_177952_p() + 0.5;
        if (rand.nextDouble() < 0.1) {
            world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double offsetX = (rand.nextDouble() * 2.0 - 1.0) * 0.3;
            double offsetY = (rand.nextDouble() * 2.0 - 1.0) * 0.3;
            double offsetZ = (rand.nextDouble() * 2.0 - 1.0) * 0.3;
            world.func_175688_a(EnumParticleTypes.FLAME, x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
    }

    public int func_149738_a(World world) {
        return 2;
    }

    private void checkFall(World world, BlockPos pos) {
        if ((world.func_175623_d(pos.func_177977_b()) || BlockFalling.func_185759_i((IBlockState)world.func_180495_p(pos.func_177977_b()))) && pos.func_177956_o() >= 0) {
            if (!BlockFalling.field_149832_M && world.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32))) {
                TileEntity tileEntity;
                if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) != null) {
                    EntityFallingBlock entityfallingblock = new EntityFallingBlock(world, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, world.func_180495_p(pos)){

                        @Nullable
                        public EntityItem func_70099_a(ItemStack stack, float offsetY) {
                            if (stack.func_190926_b()) {
                                return null;
                            }
                            if (this.field_145810_d != null) {
                                BloomHelper.createBloomAsItemStack(stack, this.field_145810_d);
                            }
                            EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)offsetY, this.field_70161_v, stack);
                            entityitem.func_174869_p();
                            if (this.captureDrops) {
                                this.capturedDrops.add(entityitem);
                            } else {
                                this.field_70170_p.func_72838_d((Entity)entityitem);
                            }
                            return entityitem;
                        }
                    };
                    entityfallingblock.field_145810_d = tileEntity.func_189515_b(new NBTTagCompound());
                    world.func_72838_d((Entity)entityfallingblock);
                }
            } else {
                IBlockState state = world.func_180495_p(pos);
                world.func_175698_g(pos);
                BlockPos blockpos = pos.func_177977_b();
                while ((world.func_175623_d(blockpos) || BlockFalling.func_185759_i((IBlockState)world.func_180495_p(blockpos))) && blockpos.func_177956_o() > 0) {
                    blockpos = blockpos.func_177977_b();
                }
                if (blockpos.func_177956_o() > 0) {
                    world.func_175656_a(blockpos.func_177984_a(), state);
                }
            }
        }
    }

    private void checkFire(World world, BlockPos pos, Random rand) {
        int age = 0;
        int humidityModifier = 0;
        if (world.func_180502_D(pos)) {
            humidityModifier = -50;
        }
        this.tryCatchFire(world, pos.func_177974_f(), 300 + humidityModifier, rand, age, EnumFacing.WEST);
        this.tryCatchFire(world, pos.func_177976_e(), 300 + humidityModifier, rand, age, EnumFacing.EAST);
        this.tryCatchFire(world, pos.func_177977_b(), 50, rand, age, EnumFacing.UP);
        this.tryCatchFire(world, pos.func_177984_a(), 250 + humidityModifier, rand, age, EnumFacing.DOWN);
        this.tryCatchFire(world, pos.func_177978_c(), 300 + humidityModifier, rand, age, EnumFacing.SOUTH);
        this.tryCatchFire(world, pos.func_177968_d(), 300 + humidityModifier, rand, age, EnumFacing.NORTH);
        int flammability = world.func_180495_p(pos.func_177977_b()).func_177230_c().getFlammability((IBlockAccess)world, pos, EnumFacing.UP);
        if (flammability > 0) {
            world.func_180501_a(pos.func_177977_b(), Blocks.field_150480_ab.func_176223_P(), 3);
        }
        BloomHelper.trySpawnFire(world, pos, rand, ModuleTechBloomeryConfig.BLOOM.FIRE_SPAWN_CHANCE_RANDOM);
    }

    private void tryCatchFire(World world, BlockPos pos, int chance, Random random, int age, EnumFacing face) {
        int flammability = world.func_180495_p(pos).func_177230_c().getFlammability((IBlockAccess)world, pos, face);
        if (random.nextInt(chance) < flammability) {
            IBlockState blockState = world.func_180495_p(pos);
            if (random.nextInt(age + 10) < 5 && !world.func_175727_C(pos)) {
                int j = age + random.nextInt(5) / 4;
                if (j > 15) {
                    j = 15;
                }
                world.func_180501_a(pos, Blocks.field_150480_ab.func_176223_P().func_177226_a((IProperty)BlockFire.field_176543_a, (Comparable)Integer.valueOf(j)), 3);
            }
            if (blockState.func_177230_c() == Blocks.field_150335_W) {
                Blocks.field_150335_W.func_176206_d(world, pos, blockState.func_177226_a((IProperty)BlockTNT.field_176246_a, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileBloom();
    }

    public static class ItemBlockBloom
    extends ItemBlock {
        public ItemBlockBloom(Block block) {
            super(block);
            this.func_77625_d(1);
        }

        public int getMaxIntegrity(ItemStack itemStack) {
            return this.getTileInteger(itemStack, "maxIntegrity");
        }

        public int getIntegrity(ItemStack itemStack) {
            return this.getTileInteger(itemStack, "integrity");
        }

        public void setIntegrity(ItemStack itemStack, int integrity) {
            NBTTagCompound tagCompound;
            if (itemStack.func_77973_b() == this && (tagCompound = itemStack.func_77978_p()) != null) {
                NBTTagCompound tileTag = tagCompound.func_74775_l("BlockEntityTag");
                tileTag.func_74768_a("integrity", integrity);
            }
        }

        private int getTileInteger(ItemStack itemStack, String key) {
            NBTTagCompound tagCompound;
            if (itemStack.func_77973_b() == this && (tagCompound = itemStack.func_77978_p()) != null) {
                NBTTagCompound tileTag = tagCompound.func_74775_l("BlockEntityTag");
                return tileTag.func_74762_e(key);
            }
            return 0;
        }

        @Nullable
        public String getRecipeId(ItemStack itemStack) {
            NBTTagCompound tagCompound;
            if (itemStack.func_77973_b() == this && (tagCompound = itemStack.func_77978_p()) != null) {
                NBTTagCompound tileTag = tagCompound.func_74775_l("BlockEntityTag");
                return tileTag.func_74779_i("recipeId");
            }
            return null;
        }

        public boolean hasCustomEntity(ItemStack stack) {
            return true;
        }

        @Nullable
        public Entity createEntity(World world, Entity entity, ItemStack itemstack) {
            EntityItemBloom entityItemBloom = new EntityItemBloom(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, itemstack);
            entityItemBloom.field_70159_w = entity.field_70159_w;
            entityItemBloom.field_70181_x = entity.field_70181_x;
            entityItemBloom.field_70179_y = entity.field_70179_y;
            entityItemBloom.func_174867_a(40);
            return entityItemBloom;
        }

        @Nonnull
        public String func_77653_i(@Nonnull ItemStack stack) {
            if (stack.func_77973_b() != this) {
                return super.func_77653_i(stack);
            }
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound != null && tagCompound.func_74764_b("BlockEntityTag")) {
                NBTTagCompound teCompound = tagCompound.func_74775_l("BlockEntityTag");
                String[] langKeys = teCompound.func_74779_i("langKey").split(";");
                if (langKeys.length == 1) {
                    String langKey;
                    String string = langKey = langKeys[0].endsWith(".name") ? langKeys[0] : langKeys[0] + ".name";
                    if (I18n.func_94522_b((String)langKey)) {
                        String translatedLangKey = I18n.func_74838_a((String)langKey);
                        return I18n.func_74837_a((String)(this.func_77657_g(stack) + ".unique.name"), (Object[])new Object[]{translatedLangKey}).trim();
                    }
                } else if (langKeys.length > 1) {
                    String translatedLangKey = null;
                    for (int i = 0; i < langKeys.length; ++i) {
                        String langKey;
                        String string = langKey = langKeys[i].endsWith(".name") ? langKeys[i] : langKeys[i] + ".name";
                        if (!I18n.func_94522_b((String)langKey)) continue;
                        translatedLangKey = translatedLangKey == null ? I18n.func_74838_a((String)langKey) : I18n.func_74837_a((String)langKey, (Object[])new Object[]{translatedLangKey});
                    }
                    if (translatedLangKey != null) {
                        return I18n.func_74837_a((String)(this.func_77657_g(stack) + ".unique.name"), (Object[])new Object[]{translatedLangKey}).trim();
                    }
                }
            }
            return I18n.func_74838_a((String)(this.func_77657_g(stack) + ".name")).trim();
        }

        public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
            if (world.field_72995_K) {
                return;
            }
            if (world.func_82737_E() % 20L != 0L) {
                return;
            }
            float playerDamagePerSecond = (float)ModuleTechBloomeryConfig.BLOOM.FIRE_DAMAGE_PER_SECOND;
            if (playerDamagePerSecond > 0.0f) {
                entity.func_70097_a(DamageSource.field_76372_a, playerDamagePerSecond);
                entity.func_70015_d(1);
            }
        }

        public static class EntityItemBloom
        extends EntityItem {
            public static final String NAME = "pyrotech.EntityItemBloom";

            public EntityItemBloom(World world) {
                super(world);
                this.func_174873_u();
                this.func_184224_h(true);
                this.field_70178_ae = true;
            }

            EntityItemBloom(World world, double x, double y, double z, ItemStack stack) {
                super(world, x, y, z, stack);
                this.func_174873_u();
                this.func_184224_h(true);
                this.field_70178_ae = true;
            }

            public void func_70071_h_() {
                super.func_70071_h_();
            }

            public void func_70030_z() {
                super.func_70030_z();
                if (this.field_70170_p != null && this.field_70170_p.field_72995_K && this.field_70170_p.func_82737_E() % 5L == 0L) {
                    double x = this.field_70165_t;
                    double y = this.field_70163_u + 0.25 + this.field_70146_Z.nextDouble() * 2.0 / 16.0;
                    double z = this.field_70161_v;
                    if (this.field_70146_Z.nextDouble() < 0.1) {
                        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                    }
                    double offsetX = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * 0.1;
                    double offsetY = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * 0.1;
                    double offsetZ = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * 0.1;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }
}

