/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.tile;

import com.codetaylor.mc.athenaeum.integration.gamestages.GameStages;
import com.codetaylor.mc.athenaeum.integration.gamestages.Stages;
import com.codetaylor.mc.athenaeum.interaction.api.InteractionBounds;
import com.codetaylor.mc.athenaeum.interaction.api.Quaternion;
import com.codetaylor.mc.athenaeum.interaction.api.Transform;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.ITileInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionItemStack;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionUseItemBase;
import com.codetaylor.mc.athenaeum.inventory.ObservableStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataFloat;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataInteger;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileEntityDataBase;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.athenaeum.util.RandomHelper;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCoreConfig;
import com.codetaylor.mc.pyrotech.modules.core.network.SCPacketParticleProgress;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.WorktableRecipe;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemStackHandler;

public class TileWorktable
extends TileEntityDataBase
implements ITileInteractable {
    private InventoryWrapper inventoryWrapper = new InventoryWrapper(this);
    private TileDataItemStackHandler<InputStackHandler> inputTileDataItemStackHandler;
    private InputStackHandler inputStackHandler = new InputStackHandler(this.getGridMaxStackSize());
    private ShelfStackHandler shelfStackHandler;
    private TileDataInteger remainingDurability;
    private TileDataFloat recipeProgress;
    private IInteraction[] interactions;
    private WorktableRecipe recipe;
    private ResourceLocation retainedRecipe;

    public TileWorktable() {
        super(ModuleTechBasic.TILE_DATA_SERVICE);
        int x;
        int i;
        this.inputStackHandler.addObserver((handler, slot) -> {
            this.recipeProgress.set(0.0f);
            this.updateRecipe();
            this.func_70296_d();
        });
        this.shelfStackHandler = new ShelfStackHandler(this.getShelfMaxStackSize());
        this.shelfStackHandler.addObserver((handler, slot) -> this.func_70296_d());
        this.recipeProgress = new TileDataFloat(0.0f);
        this.remainingDurability = new TileDataInteger(this.getDurability());
        this.inputTileDataItemStackHandler = new TileDataItemStackHandler((ItemStackHandler)this.inputStackHandler);
        this.registerTileDataForNetwork(new ITileData[]{this.inputTileDataItemStackHandler, new TileDataItemStackHandler((ItemStackHandler)this.shelfStackHandler), this.recipeProgress, this.remainingDurability});
        this.interactions = new IInteraction[12];
        ArrayList<Object> interactionList = new ArrayList<Object>();
        interactionList.add((Object)new InteractionHammer(this.inventoryWrapper));
        for (i = 0; i < 9; ++i) {
            x = 2 - i % 3;
            int z = 2 - i / 3;
            interactionList.add((Object)new InputInteraction((ItemStackHandler)this.inputStackHandler, i, x, z));
        }
        for (i = 0; i < 3; ++i) {
            x = i % 3;
            interactionList.add((Object)new ShelfInteraction((ItemStackHandler)this.shelfStackHandler, i, x));
        }
        this.interactions = interactionList.toArray(new IInteraction[0]);
    }

    public float getRecipeProgress() {
        return this.recipeProgress.get();
    }

    public int getRemainingDurability() {
        return this.remainingDurability.get();
    }

    public ItemStackHandler getInputStackHandler() {
        return this.inputStackHandler;
    }

    public WorktableRecipe getWorktableRecipe() {
        return this.recipe;
    }

    public IRecipe getRecipe() {
        if (this.recipe == null) {
            return null;
        }
        return this.recipe.getRecipe();
    }

    protected int getGridMaxStackSize() {
        return ModuleTechBasicConfig.WORKTABLE.GRID_MAX_STACK_SIZE;
    }

    protected int getShelfMaxStackSize() {
        return ModuleTechBasicConfig.WORKTABLE.SHELF_MAX_STACK_SIZE;
    }

    protected int getToolDamagePerCraft() {
        return ModuleTechBasicConfig.WORKTABLE.TOOL_DAMAGE_PER_CRAFT;
    }

    protected boolean usesDurability() {
        return ModuleTechBasicConfig.WORKTABLE.USES_DURABILITY;
    }

    public int getDurability() {
        return ModuleTechBasicConfig.WORKTABLE.DURABILITY;
    }

    protected int getHitsPerCraft() {
        return ModuleTechBasicConfig.WORKTABLE.HITS_PER_CRAFT;
    }

    protected int getMinimumHungerToUse() {
        return ModuleTechBasicConfig.WORKTABLE.MINIMUM_HUNGER_TO_USE;
    }

    protected double getExhaustionCostPerHit() {
        return ModuleTechBasicConfig.WORKTABLE.EXHAUSTION_COST_PER_HIT;
    }

    protected double getExhaustionCostPerCraftComplete() {
        return ModuleTechBasicConfig.WORKTABLE.EXHAUSTION_COST_PER_CRAFT_COMPLETE;
    }

    private void setRetainedRecipe(ResourceLocation resourceLocation) {
        this.retainedRecipe = resourceLocation;
    }

    public InventoryWrapper getInventoryWrapper() {
        return this.inventoryWrapper;
    }

    public void dropContents() {
        StackHelper.spawnStackHandlerContentsOnTop((World)this.field_145850_b, (ItemStackHandler)this.inputStackHandler, (BlockPos)this.field_174879_c);
        StackHelper.spawnStackHandlerContentsOnTop((World)this.field_145850_b, (ItemStackHandler)this.shelfStackHandler, (BlockPos)this.field_174879_c);
    }

    public void onTileDataUpdate() {
        if (this.inputTileDataItemStackHandler.isDirty()) {
            this.updateRecipe();
        }
    }

    private void updateRecipe() {
        this.recipe = WorktableRecipe.getRecipe(this.inventoryWrapper, this.field_145850_b);
    }

    protected void func_190201_b(World world) {
        this.field_145850_b = world;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inputStackHandler.deserializeNBT(compound.func_74775_l("inputStackHandler"));
        this.shelfStackHandler.deserializeNBT(compound.func_74775_l("shelfStackHandler"));
        this.remainingDurability.set(compound.func_74762_e("remainingDurability"));
        if (compound.func_74764_b("retainedRecipe")) {
            this.retainedRecipe = new ResourceLocation(compound.func_74779_i("retainedRecipe"));
        }
        this.updateRecipe();
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("inputStackHandler", (NBTBase)this.inputStackHandler.serializeNBT());
        compound.func_74782_a("shelfStackHandler", (NBTBase)this.shelfStackHandler.serializeNBT());
        compound.func_74768_a("remainingDurability", this.remainingDurability.get());
        if (this.retainedRecipe != null) {
            compound.func_74778_a("retainedRecipe", this.retainedRecipe.toString());
        }
        return compound;
    }

    @Nullable
    public Stages getStages() {
        return ModuleTechBasicConfig.STAGES_WORKTABLE;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    public IInteraction[] getInteractions() {
        return this.interactions;
    }

    public EnumFacing getTileFacing(World world, BlockPos pos, IBlockState blockState) {
        if (blockState.func_177230_c() == ModuleTechBasic.Blocks.WORKTABLE || blockState.func_177230_c() == ModuleTechBasic.Blocks.WORKTABLE_STONE) {
            return (EnumFacing)blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        }
        return super.getTileFacing(world, pos, blockState);
    }

    protected int getBlockStateIdForParticles() {
        IBlockState state = Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.OAK);
        return Block.func_176210_f((IBlockState)state);
    }

    private class InventoryWrapper
    extends InventoryCrafting {
        private final TileWorktable tile;

        InventoryWrapper(TileWorktable tile) {
            super(new Container(){

                public boolean func_75145_c(@Nonnull EntityPlayer player) {
                    return true;
                }
            }, 3, 3);
            this.tile = tile;
        }

        @Nonnull
        public ItemStack func_70301_a(int index) {
            if (index >= this.func_70302_i_()) {
                return ItemStack.field_190927_a;
            }
            return this.tile.inputStackHandler.getStackInSlot(index);
        }

        public void func_70299_a(int index, @Nonnull ItemStack stack) {
            this.tile.inputStackHandler.setStackInSlot(index, stack);
        }

        @Nonnull
        public ItemStack func_70463_b(int x, int y) {
            if (x >= 0 && x < 3 && y >= 0 && y < 3) {
                int index = x + y * 3;
                return this.tile.inputStackHandler.getStackInSlot(index);
            }
            return ItemStack.field_190927_a;
        }

        public void func_70296_d() {
            this.tile.func_70296_d();
        }
    }

    private class ShelfStackHandler
    extends ObservableStackHandler
    implements ITileDataItemStackHandler {
        private final int maxStackSize;

        ShelfStackHandler(int maxStackSize) {
            super(3);
            this.maxStackSize = maxStackSize;
        }

        public int getSlotLimit(int slot) {
            return this.maxStackSize;
        }
    }

    private class InputStackHandler
    extends ObservableStackHandler
    implements ITileDataItemStackHandler {
        private final int maxStackSize;

        InputStackHandler(int maxStackSize) {
            super(9);
            this.maxStackSize = maxStackSize;
        }

        public int getSlotLimit(int slot) {
            return this.maxStackSize;
        }
    }

    private class ShelfInteraction
    extends InteractionItemStack<TileWorktable> {
        private static final double ONE_THIRD = 0.3333333333333333;
        private static final double ONE_SIXTH = 0.16666666666666666;

        ShelfInteraction(ItemStackHandler stackHandler, int slot, double x) {
            super(new ItemStackHandler[]{stackHandler}, slot, new EnumFacing[]{EnumFacing.UP}, new AxisAlignedBB(x * 0.3333333333333333, 0.0, 0.0, x * 0.3333333333333333 + 0.3333333333333333, 0.3125, 0.3333333333333333), new Transform(Transform.translate((double)(x * 0.3083333333333333 + 0.16666666666666666 + 0.025), (double)0.3125, (double)0.19166666666666665), Transform.rotate((Quaternion[])new Quaternion[]{Transform.rotate((double)0.0, (double)1.0, (double)0.0, (double)180.0), Transform.rotate((double)1.0, (double)0.0, (double)0.0, (double)-90.0)}), Transform.scale((double)0.2, (double)0.2, (double)0.2)));
        }
    }

    private class InputInteraction
    extends InteractionItemStack<TileWorktable> {
        private static final double ONE_THIRD = 0.3333333333333333;
        private static final double ONE_SIXTH = 0.16666666666666666;
        private final Vec3d textOffset;

        InputInteraction(ItemStackHandler stackHandler, int slot, double x, double z) {
            super(new ItemStackHandler[]{stackHandler}, slot, new EnumFacing[]{EnumFacing.UP}, new AxisAlignedBB(x * 0.3333333333333333, 0.875, z * 0.3333333333333333, x * 0.3333333333333333 + 0.3333333333333333, 0.9375, z * 0.3333333333333333 + 0.3333333333333333), new Transform(Transform.translate((double)(x * 0.3083333333333333 + 0.16666666666666666 + 0.025), (double)0.96875, (double)(z * 0.3083333333333333 + 0.16666666666666666 + 0.025)), Transform.rotate((Quaternion[])new Quaternion[]{Transform.rotate((double)0.0, (double)1.0, (double)0.0, (double)180.0), Transform.rotate((double)1.0, (double)0.0, (double)0.0, (double)-90.0)}), Transform.scale((double)0.2, (double)0.2, (double)0.2)));
            this.textOffset = new Vec3d(0.0, 0.25, 0.0);
        }

        public Vec3d getTextOffset(EnumFacing tileFacing, EnumFacing playerHorizontalFacing, EnumFacing sideHit) {
            return this.textOffset;
        }

        protected boolean doItemStackValidation(ItemStack itemStack) {
            Item item = itemStack.func_77973_b();
            ResourceLocation registryName = item.getRegistryName();
            if (registryName == null) {
                return false;
            }
            if (WorktableRecipe.hasRecipeWithTool(item)) {
                return false;
            }
            return ModuleCoreConfig.HAMMERS.getHammerHarvestLevel(registryName) == -1;
        }

        protected int getInsertItemCount(IInteraction.EnumType type, ItemStack itemStack) {
            return 1;
        }
    }

    private class InteractionHammer
    extends InteractionUseItemBase<TileWorktable> {
        private InventoryWrapper wrapper;

        InteractionHammer(InventoryWrapper inventoryWrapper) {
            super(new EnumFacing[]{EnumFacing.UP}, InteractionBounds.BLOCK);
            this.wrapper = inventoryWrapper;
        }

        protected boolean allowInteraction(TileWorktable tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            if (player.func_71024_bL().func_75116_a() < tile.getMinimumHungerToUse()) {
                return false;
            }
            ItemStack heldItemStack = player.func_184586_b(hand);
            if (heldItemStack.func_190926_b() && player.func_70093_af() && ModuleTechBasicConfig.WORKTABLE_COMMON.ALLOW_RECIPE_CLEAR) {
                return true;
            }
            if (heldItemStack.func_190926_b()) {
                return false;
            }
            Item item = heldItemStack.func_77973_b();
            ResourceLocation registryName = item.getRegistryName();
            if (registryName == null) {
                return false;
            }
            WorktableRecipe recipe = tile.getWorktableRecipe();
            boolean sneaking = player.func_70093_af();
            if (sneaking) {
                return ModuleCoreConfig.HAMMERS.getHammerHarvestLevel(registryName) > -1;
            }
            if (recipe == null) {
                return false;
            }
            return !recipe.getRecipe().func_77572_b((InventoryCrafting)this.wrapper).func_190926_b() && this.isValidTool(player, item, registryName, recipe);
        }

        private boolean isValidTool(EntityPlayer player, Item item, ResourceLocation registryName, WorktableRecipe recipe) {
            Stages stages;
            if (Loader.isModLoaded((String)"gamestages") && !GameStages.allowed((EntityPlayer)player, (Stages)(stages = recipe.getStages()))) {
                return false;
            }
            List<Item> toolList = recipe.getToolList();
            if (toolList.isEmpty()) {
                return ModuleCoreConfig.HAMMERS.getHammerHarvestLevel(registryName) > -1;
            }
            return toolList.contains(item);
        }

        protected void applyItemDamage(ItemStack itemStack, EntityPlayer player) {
        }

        protected boolean doInteraction(TileWorktable tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            ItemStack heldItem = player.func_184614_ca();
            if (player.func_70093_af()) {
                if (heldItem.func_190926_b()) {
                    this.doRecipeClear(tile, world, player);
                } else if (ModuleTechBasicConfig.WORKTABLE_COMMON.ALLOW_RECIPE_REPEAT) {
                    this.doRecipeRepeat(tile, player, heldItem);
                }
            } else {
                this.doRecipeProgress(tile, world, hitPos, player, hitX, hitY, hitZ, heldItem);
            }
            return true;
        }

        private void doRecipeClear(TileWorktable tile, World world, EntityPlayer player) {
            int slots = tile.inputStackHandler.getSlots();
            for (int i = 0; i < slots; ++i) {
                int slotLimit = tile.inputStackHandler.getSlotLimit(i);
                ItemStack itemStack = tile.inputStackHandler.extractItem(i, slotLimit, false);
                StackHelper.addToInventoryOrSpawn((World)world, (EntityPlayer)player, (ItemStack)itemStack, (BlockPos)tile.func_174877_v(), (double)1.0, (boolean)false, (boolean)true);
            }
        }

        private void doRecipeRepeat(TileWorktable tile, EntityPlayer player, ItemStack heldItem) {
            int i;
            IRecipe iRecipe;
            WorktableRecipe existingRecipe = tile.getWorktableRecipe();
            if (existingRecipe != null) {
                iRecipe = existingRecipe.getRecipe();
            } else {
                if (tile.retainedRecipe == null) {
                    return;
                }
                WorktableRecipe retainedRecipe = WorktableRecipe.getRecipe(tile.retainedRecipe);
                if (retainedRecipe == null) {
                    return;
                }
                iRecipe = retainedRecipe.getRecipe();
            }
            NonNullList ingredients = iRecipe.func_192400_c();
            ItemStackHandler inputStackHandler = tile.getInputStackHandler();
            ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>(ingredients.size());
            block0: for (Ingredient ingredient : ingredients) {
                if (ingredient.apply(ItemStack.field_190927_a)) {
                    itemStackList.add(ItemStack.field_190927_a);
                    continue;
                }
                for (ItemStack itemStack : player.field_71071_by.field_70462_a) {
                    if (!ingredient.apply(itemStack)) continue;
                    ItemStack copy = itemStack.func_77946_l();
                    copy.func_190920_e(1);
                    itemStackList.add(copy);
                    itemStack.func_190918_g(1);
                    continue block0;
                }
            }
            if (ingredients.size() != itemStackList.size()) {
                for (ItemStack itemStack : itemStackList) {
                    player.func_191521_c(itemStack);
                }
                return;
            }
            boolean tableHasRoom = true;
            for (i = 0; i < itemStackList.size(); ++i) {
                ItemStack remainingItemStack = inputStackHandler.insertItem(i, (ItemStack)itemStackList.get(i), true);
                if (remainingItemStack.func_190926_b()) continue;
                tableHasRoom = false;
                break;
            }
            if (!tableHasRoom) {
                for (ItemStack itemStack : itemStackList) {
                    player.func_191521_c(itemStack);
                }
                return;
            }
            for (i = 0; i < itemStackList.size(); ++i) {
                inputStackHandler.insertItem(i, (ItemStack)itemStackList.get(i), false);
            }
            int toolDamage = ModuleTechBasicConfig.WORKTABLE_COMMON.RECIPE_REPEAT_TOOL_DAMAGE;
            if (!((TileWorktable)tile).field_145850_b.field_72995_K && toolDamage > 0) {
                heldItem.func_96631_a(toolDamage, RandomHelper.random(), (EntityPlayerMP)player);
            }
        }

        private void doRecipeProgress(TileWorktable tile, World world, BlockPos hitPos, EntityPlayer player, float hitX, float hitY, float hitZ, ItemStack heldItem) {
            block11: {
                block10: {
                    IRecipe recipe = tile.getRecipe();
                    WorktableRecipe worktableRecipe = tile.getWorktableRecipe();
                    if (recipe == null) {
                        tile.updateRecipe();
                        recipe = tile.getRecipe();
                    }
                    if (world.field_72995_K) break block10;
                    world.func_184133_a(null, hitPos, SoundEvents.field_187889_gU, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    if (recipe == null) break block11;
                    tile.recipeProgress.add(1.0f / (float)tile.getHitsPerCraft());
                    if (tile.getExhaustionCostPerHit() > 0.0) {
                        player.func_71020_j((float)tile.getExhaustionCostPerHit());
                    }
                    ModuleCore.PACKET_SERVICE.sendToAllAround((IMessage)new SCPacketParticleProgress((double)hitPos.func_177958_n() + 0.5, hitPos.func_177956_o() + 1, (double)hitPos.func_177952_p() + 0.5, 2), world.field_73011_w.getDimension(), hitPos);
                    if (!((double)tile.recipeProgress.get() >= 0.9999)) break block11;
                    tile.recipeProgress.set(0.0f);
                    tile.setRetainedRecipe(worktableRecipe.getRegistryName());
                    ItemStack result = recipe.func_77572_b((InventoryCrafting)this.wrapper).func_77946_l();
                    FMLCommonHandler.instance().firePlayerCraftingEvent(player, result, (IInventory)this.wrapper);
                    NonNullList remainingItems = recipe.func_179532_b((InventoryCrafting)this.wrapper);
                    if (!remainingItems.isEmpty()) {
                        for (int slot = 0; slot < 9; ++slot) {
                            ItemStack remainingItemStack = (ItemStack)remainingItems.get(slot);
                            ItemStack stackInSlot = tile.inputStackHandler.getStackInSlot(slot);
                            if (!remainingItemStack.func_190926_b()) {
                                if (remainingItemStack.func_77973_b() != stackInSlot.func_77973_b()) {
                                    StackHelper.spawnStackOnTop((World)world, (ItemStack)remainingItemStack, (BlockPos)tile.func_174877_v(), (double)0.75);
                                    StackHelper.decreaseStackInSlot((ItemStackHandler)tile.inputStackHandler, (int)slot, (int)1, (boolean)true);
                                    continue;
                                }
                                tile.inputStackHandler.setStackInSlot(slot, remainingItemStack);
                                continue;
                            }
                            StackHelper.decreaseStackInSlot((ItemStackHandler)tile.inputStackHandler, (int)slot, (int)1, (boolean)true);
                        }
                    }
                    StackHelper.spawnStackOnTop((World)world, (ItemStack)result, (BlockPos)tile.func_174877_v(), (double)0.75);
                    int toolDamagePerCraft = tile.getToolDamagePerCraft();
                    if (!worktableRecipe.getToolList().isEmpty()) {
                        toolDamagePerCraft = worktableRecipe.getToolDamage();
                    }
                    if (toolDamagePerCraft > 0) {
                        heldItem.func_77972_a(toolDamagePerCraft, (EntityLivingBase)player);
                    }
                    if (tile.usesDurability() && tile.remainingDurability.add(-1) == 0) {
                        tile.dropContents();
                        world.func_175655_b(tile.field_174879_c, false);
                        world.func_184133_a(null, tile.field_174879_c, SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 1.0f, Util.RANDOM.nextFloat() * 0.4f + 0.8f);
                    }
                    if (!(tile.getExhaustionCostPerCraftComplete() > 0.0)) break block11;
                    player.func_71020_j((float)tile.getExhaustionCostPerCraftComplete());
                    break block11;
                }
                int stateId = tile.getBlockStateIdForParticles();
                for (int i = 0; i < 2; ++i) {
                    world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, (double)((float)tile.field_174879_c.func_177958_n() + hitX) + (double)(((TileWorktable)tile).field_145850_b.field_73012_v.nextFloat() * 2.0f - 1.0f) * 0.1, (double)((float)tile.field_174879_c.func_177956_o() + hitY) + 0.1, (double)((float)tile.field_174879_c.func_177952_p() + hitZ) + (double)(((TileWorktable)tile).field_145850_b.field_73012_v.nextFloat() * 2.0f - 1.0f) * 0.1, 0.0, 0.0, 0.0, new int[]{stateId});
                }
            }
        }
    }
}

