/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.tile;

import com.codetaylor.mc.athenaeum.integration.gamestages.Stages;
import com.codetaylor.mc.athenaeum.interaction.api.Transform;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.ITileInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionItemStack;
import com.codetaylor.mc.athenaeum.util.AABBHelper;
import com.codetaylor.mc.athenaeum.util.ParticleHelper;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCoreConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.block.BlockDryingRack;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.DryingRackRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.spi.DryingRackRecipeBase;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.spi.TileDryingRackBase;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class TileDryingRack
extends TileDryingRackBase
implements ITileInteractable {
    private IInteraction[] interactions = new IInteraction[4];

    public TileDryingRack() {
        super(4);
        for (int slot = 0; slot < 4; ++slot) {
            int qX = slot & 1;
            int qZ = slot >> 1 & 1;
            this.interactions[slot] = new Interaction(new ItemStackHandler[]{this.inputStackHandler, this.outputStackHandler}, slot, qX, qZ);
        }
    }

    @Override
    public DryingRackRecipeBase getRecipe(ItemStack itemStack) {
        return DryingRackRecipe.getRecipe(itemStack);
    }

    @Override
    protected ModuleTechBasicConfig.DryingRackConditionalModifiers getConditionalModifiers() {
        return ModuleTechBasicConfig.DRYING_RACK.CONDITIONAL_MODIFIERS;
    }

    @Override
    protected int getSlotCount() {
        return 4;
    }

    @Override
    protected float getMultiplicativeSpeedModifier() {
        return (float)ModuleTechBasicConfig.DRYING_RACK.SPEED_MODIFIER;
    }

    @Override
    protected Map<String, Float> getBiomeSpeeds() {
        return ModuleTechBasicConfig.DryingRack.BIOME_MODIFIERS;
    }

    public IInteraction[] getInteractions() {
        return this.interactions;
    }

    public EnumFacing getTileFacing(World world, BlockPos pos, IBlockState blockState) {
        if (blockState.func_177230_c() == ModuleTechBasic.Blocks.DRYING_RACK) {
            return (EnumFacing)blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        }
        return super.getTileFacing(world, pos, blockState);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (ModuleTechBasicConfig.DRYING_RACK.USE_AS_LADDER) {
            IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
            IBlockState blockStateUp = this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a());
            IBlockState blockStateDown = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
            if (blockState.func_177229_b(BlockDryingRack.VARIANT) == BlockDryingRack.EnumType.NORMAL && (blockStateUp.func_177230_c() == ModuleTechBasic.Blocks.DRYING_RACK && blockStateUp.func_177229_b(BlockDryingRack.VARIANT) == BlockDryingRack.EnumType.NORMAL || blockStateDown.func_177230_c() == ModuleTechBasic.Blocks.DRYING_RACK && blockStateDown.func_177229_b(BlockDryingRack.VARIANT) == BlockDryingRack.EnumType.NORMAL)) {
                this.tryClimb();
            }
        }
        if (this.field_145850_b.field_72995_K && ModuleCoreConfig.CLIENT.SHOW_RECIPE_PROGRESSION_PARTICLES && this.getSpeed() > 0.0f && this.hasInput() && this.field_145850_b.func_82737_E() % 40L == 0L) {
            ParticleHelper.spawnProgressParticlesClient((int)1, (double)((double)this.field_174879_c.func_177958_n() + 0.5), (double)((double)this.field_174879_c.func_177956_o() + 0.75), (double)((double)this.field_174879_c.func_177952_p() + 0.5), (double)0.5, (double)0.15, (double)0.5);
        }
    }

    private void tryClimb() {
        List playerList = this.field_145850_b.func_72872_a(EntityPlayer.class, AABBHelper.create((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0).func_72317_d(0.5, 0.5, 0.5).func_186670_a(this.field_174879_c).func_72314_b(0.6, 0.2, 0.6));
        if (!playerList.isEmpty()) {
            double climbSpeed = ModuleTechBasicConfig.DRYING_RACK.CLIMB_SPEED;
            for (EntityPlayer player : playerList) {
                if (player.func_70093_af()) {
                    player.field_70181_x = 0.0;
                } else if (player.field_70123_F) {
                    if (player.field_191988_bg > 0.0f && player.field_70181_x < climbSpeed) {
                        player.field_70181_x = climbSpeed;
                    }
                } else if (player.field_70181_x < -climbSpeed) {
                    player.field_70181_x = -climbSpeed;
                }
                player.field_70143_R = 0.0f;
            }
        }
    }

    @Nullable
    public Stages getStages() {
        return ModuleTechBasicConfig.STAGES_DRYING_RACK;
    }

    private class Interaction
    extends InteractionItemStack<TileDryingRack> {
        Interaction(ItemStackHandler[] stackHandlers, int slot, double x, double z) {
            super(stackHandlers, slot, new EnumFacing[]{EnumFacing.UP}, new AxisAlignedBB(x * 0.5, 0.0, z * 0.5, x * 0.5 + 0.5, 0.75, z * 0.5 + 0.5), new Transform(Transform.translate((double)(x * 0.375 + 0.25 + 0.0625), (double)0.78125, (double)(z * 0.375 + 0.25 + 0.0625)), Transform.rotate((double)1.0, (double)0.0, (double)0.0, (double)-90.0), Transform.scale((double)0.25, (double)0.25, (double)0.25)));
        }

        protected int getInsertionIndex(TileDryingRack tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            if (!this.stackHandlers[0].getStackInSlot(this.slot).func_190926_b()) {
                return 0;
            }
            if (!this.stackHandlers[1].getStackInSlot(this.slot).func_190926_b()) {
                return 1;
            }
            return DryingRackRecipe.getRecipe(player.func_184614_ca()) != null ? 0 : 1;
        }
    }
}

