/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.tile;

import com.codetaylor.mc.athenaeum.integration.gamestages.Stages;
import com.codetaylor.mc.athenaeum.interaction.api.InteractionBounds;
import com.codetaylor.mc.athenaeum.interaction.api.Transform;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.ITileInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionItemStack;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionUseItemBase;
import com.codetaylor.mc.athenaeum.inventory.DynamicStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataFloat;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileEntityDataBase;
import com.codetaylor.mc.athenaeum.util.ArrayHelper;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.library.CompactingBinRecipeBase;
import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.client.render.CompactingBinInteractionInputRenderer;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.CompactingBinRecipe;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileCompactingBin
extends TileEntityDataBase
implements ITileInteractable {
    private InputStackHandler inputStackHandler = new InputStackHandler(this);
    private TileDataFloat recipeProgress;
    private TileDataItemStackHandler tileDataInputStackHandler;
    private CompactingBinRecipeBase currentRecipe;
    private IInteraction[] interactions;

    public TileCompactingBin() {
        super(ModuleTechBasic.TILE_DATA_SERVICE);
        this.inputStackHandler.addObserver((handler, slot) -> {
            this.updateRecipe();
            if (this.currentRecipe != null) {
                if (this.currentRecipe.getAmount() > this.inputStackHandler.getTotalItemCount()) {
                    this.recipeProgress.set(0.0f);
                }
            } else {
                this.recipeProgress.set(0.0f);
            }
            this.func_70296_d();
        });
        this.recipeProgress = new TileDataFloat(0.0f);
        this.tileDataInputStackHandler = new TileDataItemStackHandler((ItemStackHandler)this.inputStackHandler);
        this.registerTileDataForNetwork(new ITileData[]{this.tileDataInputStackHandler, this.recipeProgress});
        this.interactions = new IInteraction[]{new InteractionInput(this, (ItemStackHandler)this.inputStackHandler), new InteractionShovel()};
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.allowAutomation() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.allowAutomation() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.inputStackHandler);
        }
        return null;
    }

    public void onTileDataUpdate() {
        if (this.tileDataInputStackHandler.isDirty()) {
            this.updateRecipe();
        }
    }

    private void updateRecipe() {
        ItemStack itemStack = this.inputStackHandler.getFirstNonEmptyItemStack();
        this.currentRecipe = !itemStack.func_190926_b() ? this.getRecipe(itemStack) : null;
    }

    private boolean isItemValidForInsertion(ItemStack itemStack) {
        CompactingBinRecipeBase recipe = this.getRecipe(itemStack);
        if (recipe == null) {
            return false;
        }
        if (this.currentRecipe == null) {
            return true;
        }
        return recipe == this.currentRecipe;
    }

    public CompactingBinRecipeBase getRecipe(ItemStack itemStack) {
        return CompactingBinRecipe.getRecipe(itemStack);
    }

    public float getRecipeProgress() {
        return this.recipeProgress.get();
    }

    public float addRecipeProgress(float progress) {
        return this.recipeProgress.add(progress);
    }

    public void resetRecipeProgress() {
        this.recipeProgress.set(0.0f);
    }

    public InputStackHandler getInputStackHandler() {
        return this.inputStackHandler;
    }

    public CompactingBinRecipeBase getCurrentRecipe() {
        return this.currentRecipe;
    }

    protected boolean allowAutomation() {
        return ModuleTechBasicConfig.COMPACTING_BIN.ALLOW_AUTOMATION;
    }

    protected int getMinimumHungerToUse() {
        return ModuleTechBasicConfig.COMPACTING_BIN.MINIMUM_HUNGER_TO_USE;
    }

    protected String[] getShovelBlacklist() {
        return ModuleTechBasicConfig.COMPACTING_BIN.SHOVEL_BLACKLIST;
    }

    protected String[] getShovelWhitelist() {
        return ModuleTechBasicConfig.COMPACTING_BIN.SHOVEL_WHITELIST;
    }

    protected double getExhaustionCostPerHit() {
        return ModuleTechBasicConfig.COMPACTING_BIN.EXHAUSTION_COST_PER_HIT;
    }

    protected int getToolDamagePerCraft() {
        return ModuleTechBasicConfig.COMPACTING_BIN.TOOL_DAMAGE_PER_CRAFT;
    }

    protected double getExhaustionCostPerCraftComplete() {
        return ModuleTechBasicConfig.COMPACTING_BIN.EXHAUSTION_COST_PER_CRAFT_COMPLETE;
    }

    public int getInputCapacity() {
        return ModuleTechBasicConfig.COMPACTING_BIN.MAX_CAPACITY;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("inputStackHandler", (NBTBase)this.inputStackHandler.serializeNBT());
        compound.func_74776_a("recipeProgress", this.recipeProgress.get());
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inputStackHandler.deserializeNBT(compound.func_74775_l("inputStackHandler"));
        this.recipeProgress.set(compound.func_74760_g("recipeProgress"));
        this.updateRecipe();
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    @Nullable
    public Stages getStages() {
        return ModuleTechBasicConfig.STAGES_COMPACTING_BIN;
    }

    public IInteraction[] getInteractions() {
        return this.interactions;
    }

    public class InputStackHandler
    extends DynamicStackHandler {
        private final TileCompactingBin tile;

        InputStackHandler(TileCompactingBin tile) {
            super(1);
            this.tile = tile;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.tile.isItemValidForInsertion(stack)) {
                return stack;
            }
            CompactingBinRecipeBase recipe = this.tile.getRecipe(stack);
            if (recipe == null) {
                return stack;
            }
            int max = this.tile.getInputCapacity() * recipe.getAmount();
            int currentTotal = this.tile.getInputStackHandler().getTotalItemCount();
            if (currentTotal == max) {
                return stack;
            }
            if (currentTotal + stack.func_190916_E() <= max) {
                this.insertItem(stack, simulate);
                return ItemStack.field_190927_a;
            }
            ItemStack toInsert = stack.func_77946_l();
            int insertCount = max - currentTotal;
            toInsert.func_190920_e(insertCount);
            this.insertItem(toInsert, simulate);
            ItemStack toReturn = stack.func_77946_l();
            toReturn.func_190920_e(toReturn.func_190916_E() - insertCount);
            return toReturn;
        }

        public int removeItems(int amount) {
            int remaining = amount;
            for (int i = this.getSlots() - 1; i >= 0; --i) {
                if (this.getStackInSlot(i).func_190926_b() || (remaining -= super.extractItem(i, remaining, false).func_190916_E()) != 0) continue;
                return amount;
            }
            return amount - remaining;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            for (int i = this.getSlots() - 1; i >= 0; --i) {
                if (this.getStackInSlot(i).func_190926_b()) continue;
                return super.extractItem(i, amount, simulate);
            }
            return ItemStack.field_190927_a;
        }
    }

    private class InteractionShovel
    extends InteractionUseItemBase<TileCompactingBin> {
        InteractionShovel() {
            super(new EnumFacing[]{EnumFacing.UP}, InteractionBounds.BLOCK);
        }

        protected boolean allowInteraction(TileCompactingBin tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            if (player.func_71024_bL().func_75116_a() < tile.getMinimumHungerToUse()) {
                return false;
            }
            if (tile.currentRecipe == null || tile.currentRecipe.getAmount() > tile.getInputStackHandler().getTotalItemCount()) {
                return false;
            }
            ItemStack heldItemStack = player.func_184586_b(hand);
            Item heldItem = heldItemStack.func_77973_b();
            ResourceLocation resourceLocation = heldItem.getRegistryName();
            if (resourceLocation == null) {
                return false;
            }
            String registryName = resourceLocation.toString();
            if (heldItem.getToolClasses(heldItemStack).contains("shovel")) {
                return !ArrayHelper.contains((Object[])tile.getShovelBlacklist(), (Object)registryName);
            }
            return ArrayHelper.contains((Object[])tile.getShovelWhitelist(), (Object)registryName);
        }

        protected void applyItemDamage(ItemStack itemStack, EntityPlayer player) {
        }

        protected boolean doInteraction(TileCompactingBin tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            ItemStack heldItem = player.func_184614_ca();
            if (!world.field_72995_K) {
                if (tile.getExhaustionCostPerHit() > 0.0) {
                    player.func_71020_j((float)tile.getExhaustionCostPerHit());
                }
                int harvestLevel = heldItem.func_77973_b().getHarvestLevel(heldItem, "shovel", player, null);
                int[] requiredToolUses = tile.currentRecipe.getRequiredToolUses();
                tile.recipeProgress.add(1.0f / (float)ArrayHelper.getOrLast((int[])requiredToolUses, (int)harvestLevel));
                if ((double)tile.recipeProgress.get() > 0.9999) {
                    StackHelper.spawnStackOnTop((World)world, (ItemStack)tile.currentRecipe.getOutput(), (BlockPos)hitPos, (double)1.0);
                    tile.getInputStackHandler().removeItems(tile.currentRecipe.getAmount());
                    heldItem.func_77972_a(tile.getToolDamagePerCraft(), (EntityLivingBase)player);
                    if (tile.getExhaustionCostPerCraftComplete() > 0.0) {
                        player.func_71020_j((float)tile.getExhaustionCostPerCraftComplete());
                    }
                    tile.recipeProgress.set(0.0f);
                }
            }
            return true;
        }
    }

    public static class InteractionInput
    extends InteractionItemStack<TileCompactingBin> {
        private final TileCompactingBin tile;

        InteractionInput(TileCompactingBin tile, ItemStackHandler stackHandler) {
            super(new ItemStackHandler[]{stackHandler}, 0, new EnumFacing[]{EnumFacing.UP}, InteractionBounds.BLOCK, new Transform(Transform.translate((double)0.5, (double)1.0, (double)0.5), Transform.rotate(), Transform.scale((double)0.75, (double)0.75, (double)0.75)));
            this.tile = tile;
        }

        public TileCompactingBin getTile() {
            return this.tile;
        }

        protected boolean doItemStackValidation(ItemStack itemStack) {
            return this.tile.isItemValidForInsertion(itemStack);
        }

        protected void onInsert(IInteraction.EnumType type, ItemStack itemStack, World world, EntityPlayer player, BlockPos pos) {
            super.onInsert(type, itemStack, world, player, pos);
            if (!world.field_72995_K && type == IInteraction.EnumType.MouseClick) {
                world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 0.5f, (float)(1.0 + Util.RANDOM.nextGaussian() * (double)0.4f));
            }
        }

        public void renderSolidPass(World world, RenderItem renderItem, BlockPos pos, IBlockState blockState, float partialTicks) {
            CompactingBinInteractionInputRenderer.INSTANCE.renderSolidPass(this, world, renderItem, pos, blockState, partialTicks);
        }

        public void renderSolidPassText(World world, FontRenderer fontRenderer, int yaw, Vec3d offset, BlockPos pos, IBlockState blockState, float partialTicks) {
            CompactingBinInteractionInputRenderer.INSTANCE.renderSolidPassText(this, world, fontRenderer, yaw, offset, pos, blockState, partialTicks);
        }

        public boolean renderAdditivePass(World world, RenderItem renderItem, EnumFacing hitSide, Vec3d hitVec, BlockPos hitPos, IBlockState blockState, ItemStack heldItemMainHand, float partialTicks) {
            return CompactingBinInteractionInputRenderer.INSTANCE.renderAdditivePass(this, world, renderItem, hitSide, hitVec, hitPos, blockState, heldItemMainHand, partialTicks);
        }
    }
}

