/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.recipe;

import com.codetaylor.mc.athenaeum.util.RecipeHelper;
import com.codetaylor.mc.pyrotech.library.CompostBinRecipeBase;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryModifiable;

public class CompostBinRecipe
extends CompostBinRecipeBase<CompostBinRecipe> {
    @Nullable
    public static CompostBinRecipe getRecipe(ItemStack input) {
        ResourceLocation resourceLocation = CompostBinRecipe.getResourceLocation("pyrotech", input, input.func_77960_j());
        CompostBinRecipe recipe = (CompostBinRecipe)ModuleTechBasic.Registries.COMPOST_BIN_RECIPE.getValue(resourceLocation);
        if (recipe != null) {
            return recipe;
        }
        resourceLocation = CompostBinRecipe.getResourceLocation("pyrotech", input, Short.MAX_VALUE);
        return (CompostBinRecipe)ModuleTechBasic.Registries.COMPOST_BIN_RECIPE.getValue(resourceLocation);
    }

    @Nullable
    public static CompostBinRecipe getRecipe(ItemStack input, ItemStack output) {
        ResourceLocation resourceLocation = CompostBinRecipe.getResourceLocation("pyrotech", input, input.func_77960_j());
        CompostBinRecipe recipe = (CompostBinRecipe)ModuleTechBasic.Registries.COMPOST_BIN_RECIPE.getValue(resourceLocation);
        if (recipe != null && recipe.matches(input, output)) {
            return recipe;
        }
        resourceLocation = CompostBinRecipe.getResourceLocation("pyrotech", input, Short.MAX_VALUE);
        recipe = (CompostBinRecipe)ModuleTechBasic.Registries.COMPOST_BIN_RECIPE.getValue(resourceLocation);
        if (recipe != null && recipe.matches(input, output)) {
            return recipe;
        }
        return null;
    }

    public static ResourceLocation getResourceLocation(String resourceDomain, ItemStack itemStack, int meta) {
        Item item = itemStack.func_77973_b();
        ResourceLocation resourceLocation = item.getRegistryName();
        if (resourceLocation == null) {
            throw new NullPointerException(String.format("Item %s is missing a resource location", itemStack.toString()));
        }
        String domain = resourceLocation.func_110624_b().toLowerCase();
        String path = resourceLocation.func_110623_a().toLowerCase();
        return new ResourceLocation(resourceDomain, domain + "_" + path + "_" + meta);
    }

    public static boolean removeRecipesByOutput(Ingredient output) {
        return RecipeHelper.removeRecipesByOutput(ModuleTechBasic.Registries.COMPOST_BIN_RECIPE, (Ingredient)output);
    }

    public static boolean removeRecipesByInput(Ingredient output) {
        IForgeRegistryModifiable<CompostBinRecipe> registry = ModuleTechBasic.Registries.COMPOST_BIN_RECIPE;
        Collection recipes = registry.getValuesCollection();
        ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>(1);
        for (CompostBinRecipe recipe : recipes) {
            if (!output.apply(recipe.getInput())) continue;
            toRemove.add(recipe.getRegistryName());
        }
        for (ResourceLocation resourceLocation : toRemove) {
            registry.remove(resourceLocation);
        }
        return !toRemove.isEmpty();
    }

    public CompostBinRecipe(ItemStack output, ItemStack input) {
        super(output, input);
    }

    public CompostBinRecipe(ItemStack output, ItemStack input, int compostValue) {
        super(output, input, compostValue);
    }
}

