/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.waila.provider;

import com.codetaylor.mc.pyrotech.library.spi.plugin.waila.BodyProviderAdapter;
import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.library.util.plugin.waila.WailaUtil;
import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.waila.delegate.DryingRackProviderDelegate;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.spi.TileDryingRackBase;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.ItemStackHandler;

public class DryingRackProvider
extends BodyProviderAdapter
implements DryingRackProviderDelegate.IDryingRackDisplay {
    private final DryingRackProviderDelegate delegate = new DryingRackProviderDelegate(this);
    private List<String> tooltip;

    @Nonnull
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity tileEntity = accessor.getTileEntity();
        if (tileEntity instanceof TileDryingRackBase) {
            this.tooltip = tooltip;
            this.delegate.display((TileDryingRackBase)tileEntity);
            this.tooltip = null;
        }
        return tooltip;
    }

    @Override
    public void setSpeed(String langKey, int speed) {
        this.tooltip.add(Util.translateFormatted(langKey, speed));
    }

    @Override
    public void setRecipeProgress(ItemStack input, ItemStack output, int progress, int maxProgress) {
        String renderString = WailaUtil.getStackRenderString(input) + WailaUtil.getProgressRenderString(progress, maxProgress) + WailaUtil.getStackRenderString(output);
        this.tooltip.add(renderString);
    }

    @Override
    public void setOutputItems(ItemStackHandler outputStackHandler) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < outputStackHandler.getSlots(); ++i) {
            ItemStack stackInSlot = outputStackHandler.getStackInSlot(i);
            if (stackInSlot.func_190926_b()) continue;
            builder.append(WailaUtil.getStackRenderString(stackInSlot));
        }
        if (builder.length() > 0) {
            this.tooltip.add(builder.toString());
        }
    }
}

