/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.waila.delegate;

import com.codetaylor.mc.pyrotech.library.waila.ProviderDelegateBase;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.AnvilRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.spi.TileAnvilBase;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.block.BlockBloom;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.recipe.BloomAnvilRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.util.BloomHelper;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.items.ItemStackHandler;

public class AnvilProviderDelegate
extends ProviderDelegateBase<IAnvilDisplay, TileAnvilBase> {
    private final AnvilRecipe.EnumTier tier;

    public AnvilProviderDelegate(AnvilRecipe.EnumTier tier, IAnvilDisplay display) {
        super(display);
        this.tier = tier;
    }

    @Override
    public void display(TileAnvilBase tile) {
        throw new UnsupportedOperationException();
    }

    public void display(TileAnvilBase tile, EntityPlayer player) {
        float progress = tile.getRecipeProgress();
        ItemStackHandler stackHandler = tile.getStackHandler();
        ItemStack input = stackHandler.getStackInSlot(0);
        if (!input.func_190926_b()) {
            AnvilRecipe recipe = AnvilRecipe.getRecipe(input, this.tier);
            if (recipe != null) {
                String typeLangKey;
                ItemStack recipeOutput = recipe.getOutput();
                if (!recipeOutput.func_190926_b()) {
                    if (recipe instanceof BloomAnvilRecipe) {
                        recipeOutput.func_190920_e(1);
                    }
                    ((IAnvilDisplay)this.display).setRecipeProgress(input, recipeOutput, (int)(100.0f * progress), 100);
                }
                AnvilRecipe.EnumType recipeType = recipe.getType();
                String langKey = "gui.pyrotech.waila.anvil.recipe.type";
                if (recipeType == AnvilRecipe.EnumType.HAMMER) {
                    typeLangKey = "gui.pyrotech.waila.anvil.recipe.type.hammer";
                    ((IAnvilDisplay)this.display).setRecipeType(langKey, typeLangKey);
                } else if (recipeType == AnvilRecipe.EnumType.PICKAXE) {
                    typeLangKey = "gui.pyrotech.waila.anvil.recipe.type.pickaxe";
                    ((IAnvilDisplay)this.display).setRecipeType(langKey, typeLangKey);
                } else {
                    throw new RuntimeException("Unknown recipe type: " + (Object)((Object)recipeType));
                }
            }
            if (recipe instanceof BloomAnvilRecipe) {
                ((IAnvilDisplay)this.display).setBloomName(TextFormatting.GOLD, input);
                Item item = input.func_77973_b();
                if (item instanceof BlockBloom.ItemBlockBloom) {
                    BlockBloom.ItemBlockBloom bloom = (BlockBloom.ItemBlockBloom)item;
                    int integrity = (int)((float)bloom.getIntegrity(input) / (float)bloom.getMaxIntegrity(input) * 100.0f);
                    String langKey = "gui.pyrotech.waila.bloom.integrity";
                    ((IAnvilDisplay)this.display).setIntegrity(langKey, integrity);
                    int hammerPower = (int)(BloomHelper.calculateHammerPower(tile.func_174877_v(), player) * 100.0);
                    langKey = "gui.pyrotech.waila.bloom.hammer.power";
                    if (hammerPower > 0) {
                        ((IAnvilDisplay)this.display).setHammerPower(null, langKey, hammerPower);
                    } else {
                        ((IAnvilDisplay)this.display).setHammerPower(TextFormatting.RED, langKey, hammerPower);
                    }
                }
            }
        }
    }

    public static interface IAnvilDisplay {
        public void setRecipeProgress(ItemStack var1, ItemStack var2, int var3, int var4);

        public void setRecipeType(String var1, String var2);

        public void setBloomName(@Nullable TextFormatting var1, ItemStack var2);

        public void setIntegrity(String var1, int var2);

        public void setHammerPower(@Nullable TextFormatting var1, String var2, int var3);
    }
}

