/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.category;

import com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.wrapper.JEIRecipeWrapperWorktableShapeless;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import mezz.jei.api.recipe.wrapper.ICustomCraftingRecipeWrapper;
import mezz.jei.api.recipe.wrapper.IShapedCraftingRecipeWrapper;
import mezz.jei.config.Constants;
import mezz.jei.startup.ForgeModIdHelper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class JEIRecipeCategoryWorktable
implements IRecipeCategory<IRecipeWrapper> {
    public static final String UID = "pyrotech.worktable";
    private static final int CRAFT_OUTPUT_SLOT_INDEX = 0;
    private static final int CRAFT_INPUT_SLOT_INDEX = 1;
    private static final int TOOL_SLOT_INDEX = 10;
    private final IDrawable background;
    private final String title;
    private final ICraftingGridHelper craftingGridHelper;

    public JEIRecipeCategoryWorktable(IGuiHelper guiHelper) {
        ResourceLocation location = Constants.RECIPE_GUI_VANILLA;
        this.background = guiHelper.createDrawable(location, 0, 60, 116, 54);
        this.title = Translator.translateToLocal((String)"gui.pyrotech.jei.category.worktable");
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(1, 0);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    @Nonnull
    public String getModName() {
        return "pyrotech";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @ParametersAreNonnullByDefault
    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        ICraftingRecipeWrapper craftingRecipeWrapper;
        ResourceLocation registryName;
        JEIRecipeWrapperWorktableShapeless worktableRecipeWrapper;
        List<ItemStack> toolList;
        JEIRecipeWrapperWorktableShapeless worktableRecipeWrapper2;
        List<ItemStack> toolList2;
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, false, 94, 18);
        if (recipeWrapper instanceof JEIRecipeWrapperWorktableShapeless && !(toolList2 = (worktableRecipeWrapper2 = (JEIRecipeWrapperWorktableShapeless)recipeWrapper).getToolList()).isEmpty()) {
            guiItemStacks.init(10, true, 54, 0);
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = 1 + x + y * 3;
                guiItemStacks.init(index, true, x * 18, y * 18);
            }
        }
        if (recipeWrapper instanceof ICustomCraftingRecipeWrapper) {
            ICustomCraftingRecipeWrapper customWrapper = (ICustomCraftingRecipeWrapper)recipeWrapper;
            customWrapper.setRecipe(recipeLayout, ingredients);
            return;
        }
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        if (recipeWrapper instanceof IShapedCraftingRecipeWrapper) {
            IShapedCraftingRecipeWrapper wrapper = (IShapedCraftingRecipeWrapper)recipeWrapper;
            this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs, wrapper.getWidth(), wrapper.getHeight());
        } else {
            this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs);
            recipeLayout.setShapeless();
        }
        guiItemStacks.set(0, (List)outputs.get(0));
        if (recipeWrapper instanceof JEIRecipeWrapperWorktableShapeless && !(toolList = (worktableRecipeWrapper = (JEIRecipeWrapperWorktableShapeless)recipeWrapper).getToolList()).isEmpty()) {
            guiItemStacks.set(10, toolList);
        }
        if (recipeWrapper instanceof ICraftingRecipeWrapper && (registryName = (craftingRecipeWrapper = (ICraftingRecipeWrapper)recipeWrapper).getRegistryName()) != null) {
            guiItemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
                if (slotIndex == 0) {
                    boolean showAdvanced;
                    String modName;
                    String recipeModId = registryName.func_110624_b();
                    boolean modIdDifferent = false;
                    ResourceLocation itemRegistryName = ingredient.func_77973_b().getRegistryName();
                    if (itemRegistryName != null) {
                        String itemModId = itemRegistryName.func_110624_b();
                        boolean bl = modIdDifferent = !recipeModId.equals(itemModId);
                    }
                    if (modIdDifferent && (modName = ForgeModIdHelper.getInstance().getFormattedModNameForModId(recipeModId)) != null) {
                        tooltip.add(TextFormatting.GRAY + Translator.translateToLocalFormatted((String)"jei.tooltip.recipe.by", (Object[])new Object[]{modName}));
                    }
                    boolean bl = showAdvanced = Minecraft.func_71410_x().field_71474_y.field_82882_x || GuiScreen.func_146272_n();
                    if (showAdvanced) {
                        tooltip.add(TextFormatting.DARK_GRAY + Translator.translateToLocalFormatted((String)"jei.tooltip.recipe.id", (Object[])new Object[]{registryName.toString()}));
                    }
                }
            });
        }
    }
}

