/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.item;

import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.item.ItemMarshmallow;
import com.codetaylor.mc.pyrotech.modules.tech.basic.network.SCPacketMarshmallowStickTimestamp;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.TileCampfire;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMarshmallowStick
extends ItemFood {
    public static final String NAME = "marshmallow_stick";
    private static final MethodHandle entityLivingBase$activeItemStackUseCountSetter;
    private static final int ROASTING_DURATION = 12000;
    private static final int EATING_DURATION = 32;

    public ItemMarshmallowStick() {
        super(ModuleTechBasicConfig.CAMPFIRE_MARSHMALLOWS.ROASTED_MARSHMALLOW_HUNGER, (float)ModuleTechBasicConfig.CAMPFIRE_MARSHMALLOWS.ROASTED_MARSHMALLOW_SATURATION, false);
        this.func_77625_d(1);
        this.func_77656_e(ModuleTechBasicConfig.CAMPFIRE_MARSHMALLOWS.MARSHMALLOW_STICK_DURABILITY);
        this.func_185043_a(new ResourceLocation("pyrotech", "marshmallow_type"), (itemStack, world, entity) -> ItemMarshmallowStick.getType(itemStack).id);
    }

    public int getMaxDamage(ItemStack stack) {
        return ModuleTechBasicConfig.CAMPFIRE_MARSHMALLOWS.MARSHMALLOW_STICK_DURABILITY;
    }

    public int func_77626_a(ItemStack stack) {
        if (ItemMarshmallowStick.getRoastByTimestamp(stack) < Long.MAX_VALUE) {
            return 12000;
        }
        return 32;
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        if (ItemMarshmallowStick.getRoastByTimestamp(stack) < Long.MAX_VALUE) {
            return EnumAction.DRINK;
        }
        return EnumAction.EAT;
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        EnumType type = ItemMarshmallowStick.getType(stack);
        if (type == EnumType.MARSHMALLOW) {
            return "item.pyrotech.marshmallow.on.stick";
        }
        if (type == EnumType.MARSHMALLOW_BURNED) {
            return "item.pyrotech.marshmallow.on.stick.burned";
        }
        if (type == EnumType.MARSHMALLOW_ROASTED) {
            return "item.pyrotech.marshmallow.on.stick.roasted";
        }
        return super.func_77667_c(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return ItemMarshmallowStick.getType(oldStack) != ItemMarshmallowStick.getType(newStack);
    }

    @Nullable
    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound tag = super.getNBTShareTag(stack);
        if (tag != null) {
            tag = tag.func_74737_b();
            tag.func_82580_o("RoastByTimestamp");
        }
        return tag;
    }

    public static void setType(EnumType type, ItemStack itemStack) {
        NBTTagCompound tag = StackHelper.getTagSafe((ItemStack)itemStack);
        tag.func_74768_a("MarshmallowType", type.id);
        itemStack.func_77982_d(tag);
    }

    public static EnumType getType(ItemStack itemStack) {
        NBTTagCompound tag = StackHelper.getTagSafe((ItemStack)itemStack);
        return EnumType.from(tag.func_74762_e("MarshmallowType"));
    }

    public static void setRoastByTimestamp(ItemStack itemStack, long timestamp) {
        NBTTagCompound tag = StackHelper.getTagSafe((ItemStack)itemStack);
        tag.func_74772_a("RoastByTimestamp", timestamp);
        itemStack.func_77982_d(tag);
    }

    public static long getRoastByTimestamp(ItemStack itemStack) {
        NBTTagCompound tag = StackHelper.getTagSafe((ItemStack)itemStack);
        if (!tag.func_74764_b("RoastByTimestamp")) {
            return Long.MAX_VALUE;
        }
        return tag.func_74763_f("RoastByTimestamp");
    }

    public static void setRoastedAtTimestamp(ItemStack itemStack, long timestamp) {
        NBTTagCompound tag = StackHelper.getTagSafe((ItemStack)itemStack);
        tag.func_74772_a("RoastedAtTimestamp", timestamp);
        itemStack.func_77982_d(tag);
    }

    public static long getRoastedAtTimestamp(ItemStack itemStack) {
        NBTTagCompound tag = StackHelper.getTagSafe((ItemStack)itemStack);
        if (!tag.func_74764_b("RoastedAtTimestamp")) {
            return 0L;
        }
        return tag.func_74763_f("RoastedAtTimestamp");
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND) {
            ItemStack itemMainHand = player.func_184614_ca();
            ItemStack itemOffhand = player.func_184592_cb();
            RayTraceResult rayTraceResult = this.func_77621_a(world, player, false);
            if (ItemMarshmallowStick.getRoastedAtTimestamp(itemMainHand) == 0L && rayTraceResult != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK && this.isRoastingBlock(world, rayTraceResult.func_178782_a()) && this.isWithinRoastingRange((EntityLivingBase)player, rayTraceResult.func_178782_a())) {
                if (!world.field_72995_K && ItemMarshmallowStick.getRoastByTimestamp(itemMainHand) == Long.MAX_VALUE) {
                    int roastDuration = ModuleTechBasicConfig.CAMPFIRE_MARSHMALLOWS.ROASTING_DURATION_TICKS;
                    double roastVariance = (world.field_73012_v.nextDouble() * 2.0 - 1.0) * ModuleTechBasicConfig.CAMPFIRE_MARSHMALLOWS.ROASTING_DURATION_VARIANCE_PERCENTAGE;
                    roastDuration = Math.max(0, (int)((double)roastDuration + (double)roastDuration * roastVariance));
                    long timestamp = world.func_82737_E() + (long)roastDuration;
                    ItemMarshmallowStick.setRoastByTimestamp(itemMainHand, timestamp);
                    ModuleTechBasic.PACKET_SERVICE.sendToAll((IMessage)new SCPacketMarshmallowStickTimestamp(player, timestamp));
                }
                player.func_184598_c(hand);
                if (world.field_72995_K) {
                    try {
                        entityLivingBase$activeItemStackUseCountSetter.invokeExact((EntityLivingBase)player, 12000);
                    }
                    catch (Throwable t) {
                        throw new RuntimeException("Error setting activeItemStackUseCount", t);
                    }
                }
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemMainHand);
            }
            ActionResult eatActionResult = super.func_77659_a(world, player, hand);
            if (!player.func_70093_af() && eatActionResult.func_188397_a() == EnumActionResult.SUCCESS) {
                return eatActionResult;
            }
            if (player.func_70093_af()) {
                EnumType type = ItemMarshmallowStick.getType(itemMainHand);
                if (itemOffhand.func_77973_b() == ModuleTechBasic.Items.MARSHMALLOW) {
                    if (type == EnumType.MARSHMALLOW && itemOffhand.func_190916_E() < itemOffhand.func_77976_d()) {
                        player.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack((Item)ModuleTechBasic.Items.MARSHMALLOW, itemOffhand.func_190916_E() + 1));
                        ItemStack newItemStack = new ItemStack((Item)ModuleTechBasic.Items.MARSHMALLOW_STICK_EMPTY, 1, itemOffhand.func_77952_i());
                        this.setCooldownOnMarshmallows(player);
                        return new ActionResult(EnumActionResult.SUCCESS, (Object)newItemStack);
                    }
                } else if (itemOffhand.func_190926_b()) {
                    boolean shouldDamage = false;
                    switch (type) {
                        case MARSHMALLOW_BURNED: {
                            player.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack((Item)ModuleTechBasic.Items.MARSHMALLOW_BURNED));
                            shouldDamage = true;
                            break;
                        }
                        case MARSHMALLOW_ROASTED: {
                            ItemStack stack = new ItemStack((Item)ModuleTechBasic.Items.MARSHMALLOW_ROASTED);
                            ItemMarshmallow.setRoastedAtTimestamp(stack, ItemMarshmallowStick.getRoastedAtTimestamp(itemMainHand));
                            player.func_184201_a(EntityEquipmentSlot.OFFHAND, stack);
                            shouldDamage = true;
                            break;
                        }
                        case MARSHMALLOW: {
                            player.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack((Item)ModuleTechBasic.Items.MARSHMALLOW));
                        }
                    }
                    ItemStack newItemStack = new ItemStack((Item)ModuleTechBasic.Items.MARSHMALLOW_STICK_EMPTY, 1, itemMainHand.func_77952_i());
                    if (shouldDamage) {
                        newItemStack.func_77972_a(1, (EntityLivingBase)player);
                    }
                    this.setCooldownOnMarshmallows(player);
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)newItemStack);
                }
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        RayTraceResult rayTraceResult;
        if (!(player instanceof EntityPlayer)) {
            return;
        }
        long roastByTimestamp = ItemMarshmallowStick.getRoastByTimestamp(stack);
        World world = player.field_70170_p;
        if (!(roastByTimestamp >= Long.MAX_VALUE || (rayTraceResult = this.func_77621_a(world, (EntityPlayer)player, false)) != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK && this.isRoastingBlock(world, rayTraceResult.func_178782_a()) && this.isWithinRoastingRange(player, rayTraceResult.func_178782_a()))) {
            player.func_184597_cx();
            this.setCooldownOnMarshmallows((EntityPlayer)player);
        }
        if (world.field_72995_K) {
            long totalWorldTime = world.func_82737_E();
            if (roastByTimestamp < Long.MAX_VALUE) {
                EnumType type = ItemMarshmallowStick.getType(stack);
                if (type == EnumType.MARSHMALLOW_ROASTED && totalWorldTime >= roastByTimestamp + (long)ModuleTechBasicConfig.CAMPFIRE_MARSHMALLOWS.ROASTING_BURN_DURATION_TICKS) {
                    ItemMarshmallowStick.setType(EnumType.MARSHMALLOW_BURNED, stack);
                } else if (type == EnumType.MARSHMALLOW && totalWorldTime >= roastByTimestamp) {
                    ItemMarshmallowStick.setType(EnumType.MARSHMALLOW_ROASTED, stack);
                }
            }
        }
    }

    private boolean isWithinRoastingRange(EntityLivingBase player, BlockPos blockPos) {
        return player.func_174831_c(blockPos) <= (double)(ModuleTechBasicConfig.CAMPFIRE_MARSHMALLOWS.ROASTING_RANGE_BLOCKS * ModuleTechBasicConfig.CAMPFIRE_MARSHMALLOWS.ROASTING_RANGE_BLOCKS);
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase player, int timeLeft) {
        if (!(player instanceof EntityPlayer)) {
            return;
        }
        if (ItemMarshmallowStick.getRoastedAtTimestamp(stack) > 0L) {
            return;
        }
        long totalWorldTime = world.func_82737_E();
        long roastTimestamp = ItemMarshmallowStick.getRoastByTimestamp(stack);
        if (roastTimestamp < Long.MAX_VALUE) {
            if (totalWorldTime >= roastTimestamp + (long)ModuleTechBasicConfig.CAMPFIRE_MARSHMALLOWS.ROASTING_BURN_DURATION_TICKS) {
                ItemMarshmallowStick.setType(EnumType.MARSHMALLOW_BURNED, stack);
                if (!world.field_72995_K) {
                    MinecraftServer minecraftServer;
                    ItemMarshmallowStick.setRoastedAtTimestamp(stack, world.func_82737_E());
                    if (ModuleTechBasicConfig.CAMPFIRE_MARSHMALLOWS.ENABLE_BURNED_MARSHMALLOW_BROADCAST_MESSAGE && (minecraftServer = world.func_73046_m()) != null) {
                        PlayerList playerList = minecraftServer.func_184103_al();
                        for (EntityPlayerMP playerMP : playerList.func_181057_v()) {
                            playerMP.func_145747_a((ITextComponent)new TextComponentTranslation("gui.pyrotech.marshmallow.burned.broadcast.message", new Object[]{player.func_70005_c_()}));
                        }
                    }
                }
            } else if (totalWorldTime >= roastTimestamp) {
                ItemMarshmallowStick.setType(EnumType.MARSHMALLOW_ROASTED, stack);
                if (!world.field_72995_K) {
                    ItemMarshmallowStick.setRoastedAtTimestamp(stack, world.func_82737_E());
                }
            }
            ItemMarshmallowStick.setRoastByTimestamp(stack, Long.MAX_VALUE);
        }
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, @Nonnull World world, EntityLivingBase player) {
        if (!(player instanceof EntityPlayer)) {
            return stack;
        }
        if (this.canEat(stack)) {
            ItemStack newItemStack = new ItemStack((Item)ModuleTechBasic.Items.MARSHMALLOW_STICK_EMPTY, 1, stack.func_77952_i());
            EnumType type = ItemMarshmallowStick.getType(stack);
            if (type != EnumType.MARSHMALLOW) {
                newItemStack.func_77972_a(1, player);
            }
            switch (type) {
                case MARSHMALLOW: {
                    ItemMarshmallow.applyMarshmallowEffects(ModuleTechBasicConfig.CAMPFIRE_MARSHMALLOWS.MARSHMALLOW_SPEED_DURATION_TICKS, ModuleTechBasicConfig.CAMPFIRE_MARSHMALLOWS.MAX_MARSHMALLOW_SPEED_DURATION_TICKS, player, MobEffects.field_76424_c, true);
                    break;
                }
                case MARSHMALLOW_ROASTED: {
                    double potency = ItemMarshmallow.calculatePotency(world, ItemMarshmallowStick.getRoastedAtTimestamp(stack));
                    ItemMarshmallow.applyMarshmallowEffects((int)((double)ModuleTechBasicConfig.CAMPFIRE_MARSHMALLOWS.ROASTED_MARSHMALLOW_SPEED_DURATION_TICKS * potency), ModuleTechBasicConfig.CAMPFIRE_MARSHMALLOWS.MAX_ROASTED_MARSHMALLOW_SPEED_DURATION_TICKS, player, MobEffects.field_76424_c, true);
                    break;
                }
                case MARSHMALLOW_BURNED: {
                    MinecraftServer minecraftServer;
                    if (!world.field_72995_K && ModuleTechBasicConfig.CAMPFIRE_MARSHMALLOWS.ENABLE_BURNED_MARSHMALLOW_EAT_BROADCAST_MESSAGE && (minecraftServer = world.func_73046_m()) != null) {
                        PlayerList playerList = minecraftServer.func_184103_al();
                        for (EntityPlayerMP playerMP : playerList.func_181057_v()) {
                            playerMP.func_145747_a((ITextComponent)new TextComponentTranslation("gui.pyrotech.marshmallow.burned.eat.broadcast.message", new Object[]{player.func_70005_c_()}));
                        }
                    }
                    ItemMarshmallow.applyMarshmallowEffects(ModuleTechBasicConfig.CAMPFIRE_MARSHMALLOWS.BURNED_MARSHMALLOW_SLOW_DURATION_TICKS, ModuleTechBasicConfig.CAMPFIRE_MARSHMALLOWS.BURNED_MARSHMALLOW_SLOW_DURATION_TICKS, player, MobEffects.field_76421_d, false);
                }
            }
            super.func_77654_b(stack, world, player);
            this.setCooldownOnMarshmallows((EntityPlayer)player);
            return newItemStack;
        }
        ItemMarshmallowStick.setRoastByTimestamp(stack, Long.MAX_VALUE);
        ItemMarshmallowStick.setType(EnumType.MARSHMALLOW_BURNED, stack);
        if (!world.field_72995_K) {
            ItemMarshmallowStick.setRoastedAtTimestamp(stack, world.func_82737_E());
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag tooltipFlag) {
        super.func_77624_a(stack, world, tooltip, tooltipFlag);
        if (world != null && ItemMarshmallowStick.getType(stack) == EnumType.MARSHMALLOW_ROASTED) {
            long roastedAtTimestamp = ItemMarshmallowStick.getRoastedAtTimestamp(stack);
            double potency = ItemMarshmallow.calculatePotency(world, roastedAtTimestamp);
            int displayPotency = (int)Math.round(potency * 100.0);
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"gui.pyrotech.tooltip.potency", (Object[])new Object[]{String.valueOf(displayPotency)}));
        }
    }

    private boolean canEat(ItemStack stack) {
        return ItemMarshmallowStick.getRoastedAtTimestamp(stack) > 0L || ItemMarshmallowStick.getType(stack) == EnumType.MARSHMALLOW;
    }

    public boolean isRoastingBlock(World world, BlockPos blockPos) {
        return world.func_175625_s(blockPos) instanceof TileCampfire;
    }

    private void setCooldownOnMarshmallows(EntityPlayer player) {
        player.func_184811_cZ().func_185145_a((Item)this, 10);
        player.func_184811_cZ().func_185145_a((Item)ModuleTechBasic.Items.MARSHMALLOW_STICK_EMPTY, 10);
        player.func_184811_cZ().func_185145_a((Item)ModuleTechBasic.Items.MARSHMALLOW, 10);
        player.func_184811_cZ().func_185145_a((Item)ModuleTechBasic.Items.MARSHMALLOW_ROASTED, 10);
        player.func_184811_cZ().func_185145_a((Item)ModuleTechBasic.Items.MARSHMALLOW_BURNED, 10);
    }

    static {
        try {
            entityLivingBase$activeItemStackUseCountSetter = MethodHandles.lookup().unreflectSetter(ObfuscationReflectionHelper.findField(EntityLivingBase.class, (String)"field_184628_bn"));
        }
        catch (Throwable t) {
            throw new RuntimeException(String.format("Error unreflecting setter for field %s", "field_184628_bn"), t);
        }
    }

    public static enum EnumType {
        MARSHMALLOW(0),
        MARSHMALLOW_ROASTED(1),
        MARSHMALLOW_BURNED(2);

        private static final Int2ObjectMap<EnumType> TYPES;
        private final int id;

        public static EnumType from(int id) {
            return (EnumType)((Object)TYPES.get(id));
        }

        private EnumType(int id) {
            this.id = id;
        }

        static {
            TYPES = new Int2ObjectOpenHashMap(EnumType.values().length);
            Arrays.stream(EnumType.values()).forEach(enumType -> {
                EnumType cfr_ignored_0 = (EnumType)((Object)((Object)TYPES.put(enumType.id, (Object)enumType)));
            });
        }
    }
}

