/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.event;

import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.TileCampfire;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public final class CampfireEffectTracker {
    public static final Map<UUID, Set<BlockPos>> TRACKING_CAMPFIRES = new HashMap<UUID, Set<BlockPos>>();
    private int intervalCounter;

    @SubscribeEvent
    public void on(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        ++this.intervalCounter;
        if (this.intervalCounter >= 10) {
            this.intervalCounter = 0;
            MinecraftServer minecraftServer = FMLCommonHandler.instance().getMinecraftServerInstance();
            PlayerList playerList = minecraftServer.func_184103_al();
            List players = playerList.func_181057_v();
            for (EntityPlayerMP player : players) {
                this.updateTracking((EntityPlayer)player);
            }
        }
    }

    private void updateTracking(@Nonnull EntityPlayer entity) {
        long worldTime;
        boolean effectsActive;
        World world = entity.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        UUID uuid = entity.func_110124_au();
        Set trackingCampfires = TRACKING_CAMPFIRES.getOrDefault(uuid, Collections.emptySet());
        if (!trackingCampfires.isEmpty()) {
            Iterator it = trackingCampfires.iterator();
            while (it.hasNext()) {
                BlockPos blockPos = (BlockPos)it.next();
                TileEntity tileEntity = world.func_175625_s(blockPos);
                if (!(tileEntity instanceof TileCampfire)) {
                    it.remove();
                    continue;
                }
                TileCampfire tileCampfire = (TileCampfire)tileEntity;
                if (tileCampfire.workerIsActive() && tileCampfire.isEntityInEffectRange((EntityLivingBase)entity)) continue;
                it.remove();
            }
        }
        boolean bl = effectsActive = (worldTime = world.func_72820_D() % 24000L) >= (long)ModuleTechBasicConfig.CAMPFIRE_EFFECTS.EFFECTS_START_TIME && worldTime <= (long)ModuleTechBasicConfig.CAMPFIRE_EFFECTS.EFFECTS_STOP_TIME;
        if (trackingCampfires.isEmpty() || !effectsActive) {
            String message;
            Map activePotionMap = entity.func_193076_bZ();
            if (activePotionMap.containsKey((Object)ModuleTechBasic.Potions.COMFORT)) {
                entity.func_184589_d((Potion)ModuleTechBasic.Potions.COMFORT);
                if (ModuleTechBasicConfig.CAMPFIRE_EFFECTS.DEBUG) {
                    if (trackingCampfires.isEmpty()) {
                        message = "Removed comfort effect due to no tracking campfires";
                        ModuleCore.LOGGER.debug(message);
                        entity.func_145747_a((ITextComponent)new TextComponentString(message));
                    } else if (!effectsActive) {
                        message = "Removed comfort effect due to time";
                        ModuleCore.LOGGER.debug(message);
                        entity.func_145747_a((ITextComponent)new TextComponentString(message));
                    }
                }
            }
            if (activePotionMap.containsKey((Object)ModuleTechBasic.Potions.RESTING)) {
                entity.func_184589_d((Potion)ModuleTechBasic.Potions.RESTING);
                if (ModuleTechBasicConfig.CAMPFIRE_EFFECTS.DEBUG) {
                    if (trackingCampfires.isEmpty()) {
                        message = "Removed resting effect due to no tracking campfires";
                        ModuleCore.LOGGER.debug(message);
                        entity.func_145747_a((ITextComponent)new TextComponentString(message));
                    } else if (!effectsActive) {
                        message = "Removed resting effect due to time";
                        ModuleCore.LOGGER.debug(message);
                        entity.func_145747_a((ITextComponent)new TextComponentString(message));
                    }
                }
            }
        }
    }
}

