/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.event;

import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.FoodStats;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class CampfireComfortEffectEventHandler {
    private static MethodHandle itemFood$alwaysEdibleGetter;

    private boolean isAlwaysEdible(ItemFood itemFood) {
        try {
            return itemFood$alwaysEdibleGetter.invokeExact(itemFood);
        }
        catch (Throwable throwable) {
            ModuleCore.LOGGER.error("", throwable);
            return false;
        }
    }

    @SubscribeEvent
    public void on(PlayerInteractEvent.RightClickItem event) {
        ItemStack itemStack = event.getItemStack();
        Item item = itemStack.func_77973_b();
        if (!(item instanceof ItemFood)) {
            return;
        }
        ItemFood itemFood = (ItemFood)item;
        if (this.isAlwaysEdible(itemFood)) {
            return;
        }
        EntityLivingBase entityLiving = event.getEntityLiving();
        if (!(entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        if (player.func_71043_e(false)) {
            return;
        }
        PotionEffect effect = player.func_70660_b((Potion)ModuleTechBasic.Potions.COMFORT);
        if (effect == null) {
            return;
        }
        World world = player.func_130014_f_();
        EnumHand hand = event.getHand();
        if (world.field_72995_K) {
            int itemStackCount = itemStack.func_190916_E();
            ActionResult<ItemStack> actionResult = this.useFood(itemStack, world, player, hand);
            ItemStack resultItemStack = (ItemStack)actionResult.func_188398_b();
            if (resultItemStack != itemStack || resultItemStack.func_190916_E() != itemStackCount) {
                player.func_184611_a(hand, resultItemStack);
                if (resultItemStack.func_190926_b()) {
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)itemStack, (EnumHand)hand);
                }
            }
        } else {
            int i = itemStack.func_190916_E();
            int j = itemStack.func_77960_j();
            ItemStack copyBeforeUse = itemStack.func_77946_l();
            ActionResult<ItemStack> actionResult = this.useFood(itemStack, world, player, hand);
            ItemStack resultItemStack = (ItemStack)actionResult.func_188398_b();
            player.func_184611_a(hand, resultItemStack);
            if (player.func_184812_l_()) {
                resultItemStack.func_190920_e(i);
                if (resultItemStack.func_77984_f()) {
                    resultItemStack.func_77964_b(j);
                }
            }
            if (resultItemStack.func_190926_b()) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)copyBeforeUse, (EnumHand)hand);
                player.func_184611_a(hand, ItemStack.field_190927_a);
            }
            if (!player.func_184587_cr()) {
                ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
            }
        }
        event.setCanceled(true);
    }

    private ActionResult<ItemStack> useFood(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        ActionResult actionResult = itemStack.func_77957_a(world, player, hand);
        if (actionResult.func_188397_a() == EnumActionResult.FAIL) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        return actionResult;
    }

    @SubscribeEvent
    public void on(LivingEntityUseItemEvent.Finish event) {
        ItemStack itemStack;
        Item item;
        EntityLivingBase entityLiving = event.getEntityLiving();
        if (entityLiving.func_130014_f_().field_72995_K) {
            return;
        }
        PotionEffect effect = entityLiving.func_70660_b((Potion)ModuleTechBasic.Potions.COMFORT);
        if (effect == null) {
            return;
        }
        if (entityLiving instanceof EntityPlayer && (item = (itemStack = event.getItem()).func_77973_b()) instanceof ItemFood) {
            ItemFood itemFood = (ItemFood)item;
            int healAmount = (int)Math.max(0.0, (double)itemFood.func_150905_g(itemStack) * ModuleTechBasicConfig.CAMPFIRE_EFFECTS.COMFORT_HUNGER_MODIFIER);
            float saturationModifier = (float)Math.max(0.0, (double)itemFood.func_150906_h(itemStack) * ModuleTechBasicConfig.CAMPFIRE_EFFECTS.COMFORT_SATURATION_MODIFIER);
            FoodStats foodStats = ((EntityPlayer)entityLiving).func_71024_bL();
            foodStats.func_75122_a(healAmount, saturationModifier);
        }
    }

    static {
        try {
            itemFood$alwaysEdibleGetter = MethodHandles.lookup().unreflectGetter(ObfuscationReflectionHelper.findField(ItemFood.class, (String)"field_77852_bZ"));
        }
        catch (IllegalAccessException e) {
            ModuleCore.LOGGER.error("", (Throwable)e);
        }
    }
}

