/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.client.render;

import com.codetaylor.mc.athenaeum.interaction.api.InteractionRenderers;
import com.codetaylor.mc.athenaeum.interaction.api.Transform;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteractionRenderer;
import com.codetaylor.mc.pyrotech.library.CompactingBinRecipeBase;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.TileCompactingBin;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class CompactingBinInteractionInputRenderer
implements IInteractionRenderer<TileCompactingBin.InteractionInput> {
    public static final CompactingBinInteractionInputRenderer INSTANCE = new CompactingBinInteractionInputRenderer();

    public void renderSolidPass(TileCompactingBin.InteractionInput interaction, World world, RenderItem renderItem, BlockPos pos, IBlockState blockState, float partialTicks) {
        TileCompactingBin tile = interaction.getTile();
        CompactingBinRecipeBase currentRecipe = tile.getCurrentRecipe();
        if (currentRecipe == null) {
            return;
        }
        double max = tile.getInputCapacity() * currentRecipe.getAmount();
        double currentTotal = tile.getInputStackHandler().getTotalItemCount();
        double height = currentTotal / max * 0.8125 + 0.09375;
        Transform transform = new Transform(Transform.translate((double)0.5, (double)height, (double)0.5), Transform.rotate(), Transform.scale((double)0.75, (double)0.0625, (double)0.75));
        InteractionRenderers.renderItemModel((RenderItem)renderItem, (ItemStack)currentRecipe.getOutput(), (Transform)transform);
    }

    public void renderSolidPassText(TileCompactingBin.InteractionInput interaction, World world, FontRenderer fontRenderer, int yaw, Vec3d offset, BlockPos pos, IBlockState blockState, float partialTicks) {
        TileCompactingBin tile = interaction.getTile();
        CompactingBinRecipeBase currentRecipe = tile.getCurrentRecipe();
        if (!interaction.isEmpty() && currentRecipe != null && currentRecipe.getAmount() > 0) {
            int currentTotal = tile.getInputStackHandler().getTotalItemCount();
            int count = currentTotal / currentRecipe.getAmount();
            ItemStack itemStack = interaction.getStackInSlot();
            Transform transform = interaction.getTransform(world, pos, blockState, itemStack, partialTicks);
            GlStateManager.func_179094_E();
            if (transform != Transform.IDENTITY) {
                GlStateManager.func_179137_b((double)transform.translation.field_72450_a, (double)transform.translation.field_72448_b, (double)transform.translation.field_72449_c);
            }
            InteractionRenderers.renderItemCount((FontRenderer)fontRenderer, (int)yaw, (int)count, (Vec3d)offset);
            GlStateManager.func_179121_F();
        }
    }

    public boolean renderAdditivePass(TileCompactingBin.InteractionInput interaction, World world, RenderItem renderItem, EnumFacing hitSide, Vec3d hitVec, BlockPos hitPos, IBlockState blockState, ItemStack heldItemMainHand, float partialTicks) {
        TileCompactingBin tile = interaction.getTile();
        CompactingBinRecipeBase currentRecipe = tile.getCurrentRecipe();
        if (currentRecipe != null) {
            double max = tile.getInputCapacity() * currentRecipe.getAmount();
            double currentTotal = tile.getInputStackHandler().getTotalItemCount();
            if (currentTotal == max) {
                return false;
            }
        }
        if (interaction.isItemStackValid(heldItemMainHand)) {
            Transform transform = interaction.getTransform(world, hitPos, blockState, heldItemMainHand, partialTicks);
            InteractionRenderers.setupAdditiveGLState();
            InteractionRenderers.renderItemModelCustom((RenderItem)renderItem, (ItemStack)heldItemMainHand, (Transform)transform);
            InteractionRenderers.cleanupAdditiveGLState();
            return true;
        }
        return false;
    }
}

