/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.client.render;

import com.codetaylor.mc.athenaeum.interaction.api.InteractionRenderers;
import com.codetaylor.mc.athenaeum.interaction.api.Transform;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteractionRenderer;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.TileCampfire;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class CampfireInteractionLogRenderer
implements IInteractionRenderer<TileCampfire.InteractionLog> {
    public static final CampfireInteractionLogRenderer INSTANCE = new CampfireInteractionLogRenderer();

    public void renderSolidPass(TileCampfire.InteractionLog interaction, World world, RenderItem renderItem, BlockPos pos, IBlockState blockState, float partialTicks) {
        int logCount = interaction.getLogCount();
        for (int i = 0; i < logCount; ++i) {
            this.renderLog(renderItem, i, interaction.getLog(i));
        }
    }

    public void renderSolidPassText(TileCampfire.InteractionLog interaction, World world, FontRenderer fontRenderer, int yaw, Vec3d offset, BlockPos pos, IBlockState blockState, float partialTicks) {
    }

    public boolean renderAdditivePass(TileCampfire.InteractionLog interaction, World world, RenderItem renderItem, EnumFacing hitSide, Vec3d hitVec, BlockPos hitPos, IBlockState blockState, ItemStack heldItemMainHand, float partialTicks) {
        ItemStack log;
        int logCount = interaction.getLogCount();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (logCount < 8 && interaction.shouldRenderAdditivePassForHeldItem(heldItemMainHand)) {
            if (interaction.isItemStackValid(heldItemMainHand)) {
                InteractionRenderers.setupAdditiveGLState();
                this.renderLogCustom(logCount, heldItemMainHand, renderItem);
                InteractionRenderers.cleanupAdditiveGLState();
                return true;
            }
        } else if (logCount > 0 && interaction.shouldRenderAdditivePassForStackInSlot(player.func_70093_af(), heldItemMainHand) && !(log = interaction.getLog(logCount - 1)).func_190926_b()) {
            InteractionRenderers.setupAdditiveGLState();
            this.renderLogCustom(logCount - 1, log, renderItem);
            InteractionRenderers.cleanupAdditiveGLState();
            return true;
        }
        return false;
    }

    private void renderLog(RenderItem renderItem, int i, ItemStack log) {
        this.renderLogPre(i);
        InteractionRenderers.renderItemModel((RenderItem)renderItem, (ItemStack)log, (Transform)Transform.IDENTITY);
        this.renderLogPost();
    }

    private void renderLogCustom(int i, ItemStack log, RenderItem renderItem) {
        this.renderLogPre(i);
        InteractionRenderers.renderItemModelCustom((RenderItem)renderItem, (ItemStack)log, (Transform)Transform.IDENTITY);
        this.renderLogPost();
    }

    private void renderLogPre(int i) {
        GlStateManager.func_179094_E();
        if (i < 4) {
            GlStateManager.func_179137_b((double)0.5, (double)0.2, (double)0.5);
            GlStateManager.func_179114_b((float)(90 * (i % 4)), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.375, (double)0.0, (double)0.0);
            GlStateManager.func_179114_b((float)67.5f, (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            GlStateManager.func_179137_b((double)0.5, (double)0.125, (double)0.5);
            GlStateManager.func_179114_b((float)(90 * (i % 4) + 45), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.4375, (double)0.0, (double)0.0);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GlStateManager.func_179139_a((double)0.25, (double)0.5, (double)0.25);
    }

    private void renderLogPost() {
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    private CampfireInteractionLogRenderer() {
    }
}

