/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.block.spi;

import com.codetaylor.mc.athenaeum.interaction.spi.IBlockInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.spi.BlockPartialBase;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.spi.TileAnvilBase;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.ModuleTechBloomery;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.ModuleTechBloomeryConfig;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public abstract class BlockAnvilBase
extends BlockPartialBase
implements IBlockInteractable {
    public static final IProperty<Integer> DAMAGE = PropertyInteger.func_177719_a((String)"damage", (int)0, (int)3);
    public static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);

    public BlockAnvilBase(Material material) {
        super(material);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        ItemStackHandler stackHandler;
        ItemStack stackInSlot;
        Item item;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileAnvilBase && (item = (stackInSlot = (stackHandler = ((TileAnvilBase)tileEntity).getStackHandler()).getStackInSlot(0)).func_77973_b()) instanceof ItemBlock) {
            Block block = ((ItemBlock)item).func_179223_d();
            return block.func_149750_m(block.func_176223_P());
        }
        return super.getLightValue(state, world, pos);
    }

    private boolean hasBloom(World world, BlockPos pos) {
        TileEntity tileEntity;
        if (ModuleTechBloomery.Items.BLOOM != null && (tileEntity = world.func_175625_s(pos)) instanceof TileAnvilBase) {
            ItemStackHandler stackHandler = ((TileAnvilBase)tileEntity).getStackHandler();
            ItemStack stackInSlot = stackHandler.getStackInSlot(0);
            return stackInSlot.func_77973_b() == ModuleTechBloomery.Items.BLOOM;
        }
        return false;
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        if (ModuleTechBloomeryConfig.BLOOM.ENTITY_WALK_DAMAGE > 0.0 && this.hasBloom(world, pos) && !entity.func_70045_F() && entity instanceof EntityLivingBase && !EnchantmentHelper.func_189869_j((EntityLivingBase)((EntityLivingBase)entity))) {
            entity.func_70097_a(DamageSource.field_190095_e, (float)ModuleTechBloomeryConfig.BLOOM.ENTITY_WALK_DAMAGE);
        }
        super.func_176199_a(world, pos, entity);
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        return this.interactionRayTrace(super.func_180636_a(blockState, world, pos, start, end), blockState, world, pos, start, end);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.interact(IInteraction.EnumType.MouseClick, world, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(@Nonnull World world, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof TileAnvilBase) {
            StackHelper.spawnStackHandlerContentsOnTop((World)world, (ItemStackHandler)((TileAnvilBase)tileEntity).getStackHandler(), (BlockPos)pos);
        }
        super.func_180657_a(world, player, pos, state, te, stack);
        if (!world.field_72995_K) {
            world.func_175698_g(pos);
        }
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        drops.add((Object)StackHelper.createItemStackFromTileEntity((Block)this.getBlock(), (int)1, (int)((Integer)state.func_177229_b(DAMAGE)), (TileEntity)world.func_175625_s(pos)));
    }

    protected abstract Block getBlock();

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return this.createTileEntity();
    }

    protected abstract TileEntity createTileEntity();

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DAMAGE});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(DAMAGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b(DAMAGE);
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b(DAMAGE);
    }

    public boolean isSideSolid(IBlockState base_state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.hasBloom(world, pos)) {
            double x = (double)pos.func_177958_n() + 0.5;
            double y = (double)pos.func_177956_o() + 0.625 + rand.nextDouble() * 2.0 / 16.0;
            double z = (double)pos.func_177952_p() + 0.5;
            if (rand.nextDouble() < 0.1) {
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            for (int i = 0; i < 4; ++i) {
                double offsetX = (rand.nextDouble() * 2.0 - 1.0) * 0.2;
                double offsetY = (rand.nextDouble() * 2.0 - 1.0) * 0.2;
                double offsetZ = (rand.nextDouble() * 2.0 - 1.0) * 0.2;
                world.func_175688_a(EnumParticleTypes.FLAME, x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public static class ItemAnvil
    extends ItemBlock {
        public ItemAnvil(Block block) {
            super(block);
        }

        public int func_77647_b(int damage) {
            return damage;
        }
    }
}

