/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.block;

import com.codetaylor.mc.athenaeum.interaction.spi.IBlockInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.spi.BlockPartialBase;
import com.codetaylor.mc.athenaeum.spi.IBlockVariant;
import com.codetaylor.mc.athenaeum.spi.IVariant;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.library.spi.block.IBlockIgnitableAdjacentFire;
import com.codetaylor.mc.pyrotech.library.spi.block.IBlockIgnitableAdjacentIgniterBlock;
import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.ignition.item.ItemIgniterBase;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.TileKilnPit;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public class BlockKilnPit
extends BlockPartialBase
implements IBlockVariant<EnumType>,
IBlockInteractable,
IBlockIgnitableAdjacentFire,
IBlockIgnitableAdjacentIgniterBlock {
    public static final String NAME = "kiln_pit";
    public static final IProperty<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    public static final AxisAlignedBB AABB_EMPTY = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);
    public static final AxisAlignedBB AABB_THATCH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0);

    public BlockKilnPit() {
        super(Material.field_151575_d);
        this.func_149711_c(0.6f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumType.EMPTY)));
    }

    @Nonnull
    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        switch ((EnumType)((Object)state.func_177229_b(VARIANT))) {
            case EMPTY: {
                return SoundType.field_185849_b;
            }
            case THATCH: {
                return SoundType.field_185850_c;
            }
            case WOOD: {
                return SoundType.field_185848_a;
            }
            case ACTIVE: {
                return SoundType.field_185848_a;
            }
            case COMPLETE: {
                return SoundType.field_185855_h;
            }
        }
        return SoundType.field_185848_a;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.func_177229_b(VARIANT) == EnumType.EMPTY) {
            return AABB_EMPTY;
        }
        return field_185505_j;
    }

    public boolean func_149730_j(IBlockState state) {
        EnumType type = (EnumType)((Object)state.func_177229_b(VARIANT));
        return type == EnumType.WOOD || type == EnumType.ACTIVE || type == EnumType.COMPLETE;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        EnumType type = (EnumType)((Object)state.func_177229_b(VARIANT));
        if (face == EnumFacing.DOWN) {
            return type != EnumType.EMPTY;
        }
        return this.func_149730_j(state);
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        EnumType type = (EnumType)((Object)state.func_177229_b(VARIANT));
        if (face == EnumFacing.DOWN) {
            return type != EnumType.EMPTY;
        }
        return this.func_149730_j(state);
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        return world.func_180495_p(pos).func_177229_b(VARIANT) == EnumType.ACTIVE;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.fromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMeta();
    }

    public int func_180651_a(IBlockState state) {
        return EnumType.EMPTY.getMeta();
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileKilnPit) {
            ((TileKilnPit)tileEntity).setNeedStructureValidation();
        }
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    @ParametersAreNonnullByDefault
    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean isActualState) {
        if (state.func_177229_b(VARIANT) == EnumType.THATCH) {
            BlockKilnPit.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_THATCH);
        } else {
            super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entity, isActualState);
        }
    }

    @Override
    public void igniteWithAdjacentFire(World world, BlockPos pos, IBlockState blockState, EnumFacing facing) {
        if (facing == EnumFacing.UP && blockState.func_177229_b(VARIANT) == EnumType.WOOD) {
            world.func_175656_a(pos, blockState.func_177226_a(VARIANT, (Comparable)((Object)EnumType.ACTIVE)));
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TileKilnPit) {
                ((TileKilnPit)tileEntity).setActive(true);
            }
        }
    }

    @Override
    public void igniteWithAdjacentIgniterBlock(World world, BlockPos pos, IBlockState blockState, EnumFacing facing) {
        if (blockState.func_177229_b(VARIANT) == EnumType.WOOD && Util.canSetFire(world, pos.func_177984_a())) {
            world.func_180501_a(pos.func_177984_a(), Blocks.field_150480_ab.func_176223_P(), 3);
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileKilnPit();
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        return this.interactionRayTrace(super.func_180636_a(blockState, world, pos, start, end), blockState, world, pos, start, end);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184614_ca();
        Item item = heldItem.func_77973_b();
        if (item instanceof ItemIgniterBase || item == Items.field_151033_d || item == Items.field_151059_bz) {
            return false;
        }
        return this.interact(IInteraction.EnumType.MouseClick, world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileKilnPit) {
            TileKilnPit tileKiln = (TileKilnPit)tileEntity;
            ItemStackHandler stackHandler = tileKiln.getStackHandler();
            StackHelper.spawnStackOnTop((World)world, (ItemStack)stackHandler.getStackInSlot(0), (BlockPos)pos);
            stackHandler = tileKiln.getOutputStackHandler();
            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                StackHelper.spawnStackOnTop((World)world, (ItemStack)stackHandler.getStackInSlot(i), (BlockPos)pos);
            }
            stackHandler = tileKiln.getLogStackHandler();
            StackHelper.spawnStackHandlerContentsOnTop((World)world, (ItemStackHandler)stackHandler, (BlockPos)pos);
        }
        super.func_180663_b(world, pos, state);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        EnumType type = (EnumType)((Object)state.func_177229_b(VARIANT));
        if (type == EnumType.COMPLETE || type == EnumType.ACTIVE) {
            return 0;
        }
        return super.quantityDropped(state, fortune, random);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        EnumType type = (EnumType)((Object)state.func_177229_b(VARIANT));
        if (type == EnumType.WOOD || type == EnumType.THATCH) {
            drops.add((Object)new ItemStack((Block)ModuleCore.Blocks.THATCH, 1, 0));
        }
        super.getDrops(drops, world, pos, state, fortune);
    }

    @Nonnull
    public String getModelName(ItemStack stack) {
        return EnumType.fromMeta(stack.func_77960_j()).func_176610_l();
    }

    @Nonnull
    public IProperty<EnumType> getVariant() {
        return VARIANT;
    }

    public static enum EnumType implements IVariant
    {
        EMPTY(0, "empty"),
        THATCH(1, "thatch"),
        WOOD(2, "wood"),
        ACTIVE(3, "active"),
        COMPLETE(4, "complete");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static EnumType fromMeta(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = (EnumType[])Stream.of(EnumType.values()).sorted(Comparator.comparing(EnumType::getMeta)).toArray(EnumType[]::new);
        }
    }
}

