/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.block;

import com.codetaylor.mc.athenaeum.interaction.spi.IBlockInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.spi.BlockPartialBase;
import com.codetaylor.mc.athenaeum.util.AABBHelper;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.modules.core.block.BlockRock;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.TileCompostBin;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class BlockCompostBin
extends BlockPartialBase
implements IBlockInteractable {
    public static final String NAME = "compost_bin";
    public static final AxisAlignedBB AABB = AABBHelper.create((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final int PROPERTY_STATE_DRY = 0;
    public static final int PROPERTY_STATE_WET = 1;
    public static final int PROPERTY_STATE_READY = 2;
    public static final PropertyInteger PROPERTY_STATE = PropertyInteger.func_177719_a((String)"state", (int)0, (int)2);
    public static final PropertyInteger PROPERTY_COMPOST_VALUE = PropertyInteger.func_177719_a((String)"compost_value", (int)0, (int)5);
    public static final boolean DEBUG = false;

    public BlockCompostBin() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149752_b(0.5f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)PROPERTY_STATE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)PROPERTY_COMPOST_VALUE, (Comparable)Integer.valueOf(0)));
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        return this.interactionRayTrace(super.func_180636_a(blockState, world, pos, start, end), blockState, world, pos, start, end);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.interact(IInteraction.EnumType.MouseClick, world, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    @ParametersAreNonnullByDefault
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof TileCompostBin) {
            TileCompostBin tileCompostBin = (TileCompostBin)tileEntity;
            TileCompostBin.InputStackHandler inputStackHandler = tileCompostBin.getInputStackHandler();
            TileCompostBin.OutputStackHandler outputStackHandler = tileCompostBin.getOutputStackHandler();
            StackHelper.spawnStackHandlerSlotContentsOnTop((World)world, (ItemStackHandler)inputStackHandler, (int)0, (BlockPos)pos);
            StackHelper.spawnStackHandlerSlotContentsOnTop((World)world, (ItemStackHandler)outputStackHandler, (int)0, (BlockPos)pos);
            for (int i = 0; i < tileCompostBin.getStoredCompostValue(); ++i) {
                StackHelper.spawnStackOnTop((World)world, (ItemStack)BlockRock.EnumType.DIRT.asStack(), (BlockPos)pos);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileCompostBin();
    }

    public boolean isSideSolid(IBlockState base_state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROPERTY_STATE, PROPERTY_COMPOST_VALUE});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileCompostBin) {
            int maxCompostValueCapacity;
            TileCompostBin tileCompostBin = (TileCompostBin)tileEntity;
            float moistureLevel = tileCompostBin.getMoistureLevel();
            state = moistureLevel == 0.0f ? state.func_177226_a((IProperty)PROPERTY_STATE, (Comparable)Integer.valueOf(0)) : (!tileCompostBin.getOutputStackHandler().getFirstNonEmptyItemStack().func_190926_b() ? state.func_177226_a((IProperty)PROPERTY_STATE, (Comparable)Integer.valueOf(2)) : state.func_177226_a((IProperty)PROPERTY_STATE, (Comparable)Integer.valueOf(1)));
            int totalCompostValue = tileCompostBin.getTotalCompostValue();
            float percentFull = (float)totalCompostValue / (float)(maxCompostValueCapacity = tileCompostBin.getMaxCompostValueCapacity());
            float usedCapacity = Math.max(0.0f, Math.min(1.0f, percentFull)) * 100.0f;
            if (usedCapacity == 0.0f) {
                state = state.func_177226_a((IProperty)PROPERTY_COMPOST_VALUE, (Comparable)Integer.valueOf(0));
            } else if (usedCapacity > 0.0f && usedCapacity < 25.0f) {
                state = state.func_177226_a((IProperty)PROPERTY_COMPOST_VALUE, (Comparable)Integer.valueOf(1));
            } else if (usedCapacity >= 25.0f && usedCapacity < 50.0f) {
                state = state.func_177226_a((IProperty)PROPERTY_COMPOST_VALUE, (Comparable)Integer.valueOf(2));
            } else if (usedCapacity >= 50.0f && usedCapacity < 75.0f) {
                state = state.func_177226_a((IProperty)PROPERTY_COMPOST_VALUE, (Comparable)Integer.valueOf(3));
            } else if (usedCapacity >= 75.0f && usedCapacity < 100.0f) {
                state = state.func_177226_a((IProperty)PROPERTY_COMPOST_VALUE, (Comparable)Integer.valueOf(4));
            } else if (usedCapacity == 100.0f) {
                state = state.func_177226_a((IProperty)PROPERTY_COMPOST_VALUE, (Comparable)Integer.valueOf(5));
            }
        }
        return state;
    }
}

