/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.block;

import com.codetaylor.mc.athenaeum.interaction.spi.IBlockInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.spi.BlockPartialBase;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.TileChoppingBlock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class BlockChoppingBlock
extends BlockPartialBase
implements IBlockInteractable {
    public static final String NAME = "chopping_block";
    public static final IProperty<Integer> DAMAGE = PropertyInteger.func_177719_a((String)"damage", (int)0, (int)5);
    public static final IProperty<Integer> SAWDUST = PropertyInteger.func_177719_a((String)"sawdust", (int)0, (int)5);
    public static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);

    public BlockChoppingBlock() {
        super(Material.field_151575_d);
        this.func_149711_c(0.75f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        return this.interactionRayTrace(super.func_180636_a(blockState, world, pos, start, end), blockState, world, pos, start, end);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.interact(IInteraction.EnumType.MouseClick, world, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(@Nonnull World world, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof TileChoppingBlock) {
            TileChoppingBlock tile = (TileChoppingBlock)tileEntity;
            StackHelper.spawnStackHandlerContentsOnTop((World)world, (ItemStackHandler)tile.getStackHandler(), (BlockPos)pos);
            tile.setSawdust(0);
        }
        super.func_180657_a(world, player, pos, state, te, stack);
        if (!world.field_72995_K) {
            world.func_175698_g(pos);
        }
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        drops.add((Object)StackHelper.createItemStackFromTileEntity((Block)ModuleTechBasic.Blocks.CHOPPING_BLOCK, (int)1, (int)((Integer)state.func_177229_b(DAMAGE)), (TileEntity)world.func_175625_s(pos)));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileChoppingBlock();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DAMAGE, SAWDUST});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(DAMAGE, (Comparable)Integer.valueOf(meta)).func_177226_a(SAWDUST, (Comparable)Integer.valueOf(0));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b(DAMAGE);
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b(DAMAGE);
    }

    public boolean isSideSolid(IBlockState base_state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileChoppingBlock) {
            int sawdust = ((TileChoppingBlock)tileEntity).getSawdust();
            return state.func_177226_a(SAWDUST, (Comparable)Integer.valueOf(sawdust));
        }
        return super.func_176221_a(state, world, pos);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public static class ItemChoppingBlock
    extends ItemBlock {
        public ItemChoppingBlock(Block block) {
            super(block);
        }

        public int func_77647_b(int damage) {
            return damage;
        }
    }
}

