/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.storage.tile.spi;

import com.codetaylor.mc.athenaeum.interaction.api.InteractionBounds;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.ITileInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionBucketBase;
import com.codetaylor.mc.athenaeum.inventory.ObservableFluidTank;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataBoolean;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataFluidTank;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataFluidTank;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileEntityDataBase;
import com.codetaylor.mc.athenaeum.util.SoundHelper;
import com.codetaylor.mc.pyrotech.modules.core.network.SCPacketParticleCombust;
import com.codetaylor.mc.pyrotech.modules.storage.ModuleStorage;
import com.codetaylor.mc.pyrotech.modules.storage.block.spi.BlockTankBase;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class TileTankBase
extends TileEntityDataBase
implements ITileInteractable,
ITickable {
    private final TileDataFluidTank<Tank> tileDataFluidTank;
    private final TileDataBoolean tileDataConnectionStateUp;
    private final TileDataBoolean tileDataConnectionStateDown;
    private final Tank tank = new Tank(this, this.getTankCapacity());
    private final FluidHandler fluidHandler;
    private final IInteraction[] interactions;
    private final List<TileTankBase> tankGroup;
    private boolean firstTickComplete = false;

    public TileTankBase() {
        super(ModuleStorage.TILE_DATA_SERVICE);
        this.tank.addObserver((fluidTank, amount) -> this.func_70296_d());
        this.fluidHandler = new FluidHandler(this);
        this.tankGroup = new ArrayList<TileTankBase>();
        this.tileDataFluidTank = new TileDataFluidTank((FluidTank)this.tank);
        this.tileDataConnectionStateUp = new TileDataBoolean(false);
        this.tileDataConnectionStateDown = new TileDataBoolean(false);
        this.registerTileDataForNetwork(new ITileData[]{this.tileDataFluidTank, this.tileDataConnectionStateUp, this.tileDataConnectionStateDown});
        this.interactions = new IInteraction[]{new InteractionBucket(this.fluidHandler)};
    }

    public FluidTank getFluidTank() {
        return this.tank;
    }

    public BlockTankBase.EnumConnection getConnectionState() {
        if (this.tileDataConnectionStateUp.get() && this.tileDataConnectionStateDown.get()) {
            return BlockTankBase.EnumConnection.BOTH;
        }
        if (this.tileDataConnectionStateUp.get()) {
            return BlockTankBase.EnumConnection.UP;
        }
        if (this.tileDataConnectionStateDown.get()) {
            return BlockTankBase.EnumConnection.DOWN;
        }
        return BlockTankBase.EnumConnection.NONE;
    }

    public boolean isConnectedUp() {
        BlockTankBase.EnumConnection connectionState = this.getConnectionState();
        return connectionState == BlockTankBase.EnumConnection.BOTH || connectionState == BlockTankBase.EnumConnection.UP;
    }

    public boolean isConnectedDown() {
        BlockTankBase.EnumConnection connectionState = this.getConnectionState();
        return connectionState == BlockTankBase.EnumConnection.BOTH || connectionState == BlockTankBase.EnumConnection.DOWN;
    }

    public void setTileDataConnectionStateUp(boolean connected) {
        this.tileDataConnectionStateUp.set(connected);
    }

    public void setTileDataConnectionStateDown(boolean connected) {
        this.tileDataConnectionStateDown.set(connected);
    }

    protected abstract int getTankCapacity();

    protected abstract boolean canHoldHotFluids();

    protected abstract int getHotFluidTemperature();

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        if (!this.isConnectedDown()) {
            return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + this.tankGroup.size()), (double)(this.field_174879_c.func_177952_p() + 1));
        }
        return super.getRenderBoundingBox();
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1 && !this.isConnectedDown() && this.tank.getFluidAmount() > 0;
    }

    private TileTankBase findLowestConnectedTank() {
        BlockPos.MutableBlockPos tankPos = new BlockPos.MutableBlockPos();
        Block blockToMatch = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        for (int y = this.field_174879_c.func_177956_o(); y >= 0; --y) {
            TileTankBase tileTankBase;
            tankPos.func_181079_c(this.field_174879_c.func_177958_n(), y, this.field_174879_c.func_177952_p());
            TileEntity tileEntity = this.field_145850_b.func_175625_s((BlockPos)tankPos);
            IBlockState blockState = this.field_145850_b.func_180495_p((BlockPos)tankPos);
            Block block = blockState.func_177230_c();
            if (!(tileEntity instanceof TileTankBase) || block != blockToMatch || (tileTankBase = (TileTankBase)tileEntity).isConnectedDown()) continue;
            return tileTankBase;
        }
        return this;
    }

    public void updateTankGroups() {
        ArrayList<TileTankBase> tankGroup = new ArrayList<TileTankBase>();
        TileTankBase tank = this.findLowestConnectedTank();
        while (tank != null) {
            tankGroup.add(tank);
            if (!tank.isConnectedUp()) break;
            tank = (TileTankBase)this.field_145850_b.func_175625_s(tank.field_174879_c.func_177984_a());
        }
        for (TileTankBase tileTankBase : tankGroup) {
            tileTankBase.tankGroup.clear();
            tileTankBase.tankGroup.addAll(tankGroup);
        }
    }

    public List<TileTankBase> getTankGroup() {
        return this.tankGroup;
    }

    private boolean canConnectTo(TileTankBase tile) {
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        IBlockState otherBlockState = this.field_145850_b.func_180495_p(tile.func_174877_v());
        if (blockState.func_177230_c() != otherBlockState.func_177230_c()) {
            return false;
        }
        FluidTank fluidTank = this.getFluidTank();
        FluidStack fluidStack = fluidTank.getFluid();
        FluidTank otherFluidTank = tile.getFluidTank();
        FluidStack otherFluidStack = otherFluidTank.getFluid();
        if (fluidStack == null || otherFluidStack == null) {
            return true;
        }
        return fluidStack.isFluidEqual(otherFluidStack);
    }

    public int getActualFluidAmount() {
        int result = 0;
        List<TileTankBase> tankGroup = this.getTankGroup();
        for (TileTankBase tileTankBase : tankGroup) {
            result += tileTankBase.getFluidTank().getFluidAmount();
        }
        return result;
    }

    public int getActualFluidCapacity() {
        List<TileTankBase> tankGroup = this.getTankGroup();
        return tankGroup.size() * this.getTankCapacity();
    }

    public void updateConnectionState() {
        TileTankBase tileTankBase;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        if (tileEntity instanceof TileTankBase) {
            tileTankBase = (TileTankBase)tileEntity;
            this.setTileDataConnectionStateUp(tileTankBase.canConnectTo(this));
        } else {
            this.setTileDataConnectionStateUp(false);
        }
        tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        if (tileEntity instanceof TileTankBase) {
            tileTankBase = (TileTankBase)tileEntity;
            this.setTileDataConnectionStateDown(tileTankBase.canConnectTo(this));
        } else {
            this.setTileDataConnectionStateDown(false);
        }
    }

    public void settleFluids() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        List<TileTankBase> tankGroup = this.getTankGroup();
        for (int i = 1; i < tankGroup.size(); ++i) {
            FluidStack drain;
            int filled;
            TileTankBase tileTank = tankGroup.get(i);
            TileTankBase tileTankDown = tankGroup.get(i - 1);
            int fluidAmount = tileTank.tank.getFluidAmount();
            if (fluidAmount <= 0 || (filled = tileTankDown.tank.fill(drain = tileTank.tank.drain(fluidAmount, false), false)) <= 0) continue;
            tileTankDown.tank.fill(tileTank.tank.drain(filled, true), true);
        }
    }

    public void func_73660_a() {
        if (!this.firstTickComplete) {
            this.firstTickComplete = true;
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
            this.updateTankGroups();
        }
    }

    public void onTileDataUpdate() {
        if (this.tileDataFluidTank.isDirty()) {
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
        }
        if (this.tileDataConnectionStateUp.isDirty() || this.tileDataConnectionStateDown.isDirty()) {
            this.updateTankGroups();
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.fluidHandler;
        }
        return null;
    }

    protected void func_190201_b(World world) {
        this.field_145850_b = world;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        compound.func_74757_a("connectionUp", this.tileDataConnectionStateUp.get());
        compound.func_74757_a("connectionDown", this.tileDataConnectionStateDown.get());
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.tank.readFromNBT(compound.func_74775_l("tank"));
        this.tileDataConnectionStateUp.set(compound.func_74767_n("connectionUp"));
        this.tileDataConnectionStateDown.set(compound.func_74767_n("connectionDown"));
    }

    public IInteraction[] getInteractions() {
        return this.interactions;
    }

    private class Tank
    extends ObservableFluidTank
    implements ITileDataFluidTank {
        private final TileTankBase tile;

        Tank(TileTankBase tile, int capacity) {
            super(capacity);
            this.tile = tile;
        }

        public int fill(FluidStack resource, boolean doFill) {
            int filled = super.fill(resource, doFill);
            if (!this.tile.canHoldHotFluids()) {
                Fluid fluid;
                World world = this.tile.field_145850_b;
                BlockPos pos = this.tile.field_174879_c;
                if (resource != null && (fluid = resource.getFluid()).getTemperature(resource) >= this.tile.getHotFluidTemperature()) {
                    if (!world.field_72995_K) {
                        world.func_175698_g(pos);
                        SoundHelper.playSoundServer((World)world, (BlockPos)pos, (SoundEvent)SoundEvents.field_187635_cQ, (SoundCategory)SoundCategory.PLAYERS);
                        FluidUtil.tryPlaceFluid(null, (World)world, (BlockPos)pos, (IFluidHandler)this, (FluidStack)resource);
                        ModuleStorage.PACKET_SERVICE.sendToAllAround((IMessage)new SCPacketParticleCombust((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.5, 0.5, 0.5), (TileEntity)this.tile);
                    }
                    world.func_180500_c(EnumSkyBlock.BLOCK, pos);
                }
            }
            return filled;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            if (this.fluid != null) {
                this.fluid.writeToNBT(nbt);
            } else {
                nbt.func_74778_a("Empty", "");
            }
            return nbt;
        }

        public FluidTank readFromNBT(NBTTagCompound nbt) {
            if (nbt.func_74764_b("Empty") && (!nbt.func_74764_b("Amount") || nbt.func_74762_e("Amount") <= 0)) {
                this.setFluid(null);
                return this;
            }
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
            this.setFluid(fluid);
            return this;
        }
    }

    public class InteractionBucket
    extends InteractionBucketBase<TileTankBase> {
        InteractionBucket(IFluidHandler fluidHandler) {
            super(fluidHandler, EnumFacing.field_82609_l, InteractionBounds.BLOCK);
        }
    }

    private static class FluidHandler
    implements IFluidHandler {
        private final TileTankBase tile;

        private FluidHandler(TileTankBase tile) {
            this.tile = tile;
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[0];
        }

        public int fill(FluidStack resource, boolean doFill) {
            TileTankBase tileTankBase;
            FluidStack otherFluidStack;
            FluidStack resourceCopy = resource.copy();
            List<TileTankBase> tankGroup = this.tile.getTankGroup();
            if (tankGroup.size() > 0 && (otherFluidStack = (tileTankBase = tankGroup.get(0)).tank.getFluid()) != null && !resource.isFluidEqual(otherFluidStack)) {
                return 0;
            }
            for (TileTankBase tileTankBase2 : tankGroup) {
                FluidTank fluidTank = tileTankBase2.getFluidTank();
                resourceCopy.amount -= fluidTank.fill(resourceCopy, doFill);
                if (resourceCopy.amount > 0) continue;
                break;
            }
            return resource.amount - resourceCopy.amount;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            FluidStack result = null;
            FluidStack resourceCopy = resource.copy();
            List<TileTankBase> tankGroup = this.tile.getTankGroup();
            for (int i = tankGroup.size() - 1; i >= 0; --i) {
                TileTankBase tileTankBase = tankGroup.get(i);
                FluidTank fluidTank = tileTankBase.getFluidTank();
                FluidStack drained = fluidTank.drain(resourceCopy, doDrain);
                if (drained != null) {
                    if (result == null) {
                        result = drained;
                    } else {
                        result.amount += drained.amount;
                    }
                    resourceCopy.amount -= drained.amount;
                }
                if (resourceCopy.amount <= 0) break;
            }
            return result;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            FluidStack result = null;
            List<TileTankBase> tankGroup = this.tile.getTankGroup();
            for (int i = tankGroup.size() - 1; i >= 0; --i) {
                TileTankBase tileTankBase = tankGroup.get(i);
                FluidTank fluidTank = tileTankBase.getFluidTank();
                FluidStack drained = fluidTank.drain(maxDrain, doDrain);
                if (drained != null) {
                    if (result == null) {
                        result = drained;
                    } else {
                        result.amount += drained.amount;
                    }
                    maxDrain -= drained.amount;
                }
                if (maxDrain <= 0) break;
            }
            return result;
        }
    }
}

