/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.storage.tile.spi;

import com.codetaylor.mc.athenaeum.interaction.api.Transform;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.ITileInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionBase;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionItemStack;
import com.codetaylor.mc.athenaeum.inventory.LargeDynamicItemLimitedStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataLargeItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileEntityDataBase;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.athenaeum.util.RandomHelper;
import com.codetaylor.mc.pyrotech.modules.storage.ModuleStorage;
import com.codetaylor.mc.pyrotech.modules.storage.block.spi.BlockBagBase;
import com.codetaylor.mc.pyrotech.modules.storage.client.render.BagInteractionInputRenderer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileBagBase
extends TileEntityDataBase
implements ITileInteractable {
    protected StackHandler stackHandler = new StackHandler(this.getItemCapacity(), this::isItemValidForInsertion);
    protected IInteraction[] interactions;

    protected TileBagBase() {
        super(ModuleStorage.TILE_DATA_SERVICE);
        this.stackHandler.addObserver((handler, slot) -> this.func_70296_d());
        this.registerTileDataForNetwork(new ITileData[]{new TileDataLargeItemStackHandler((ItemStackHandler)this.stackHandler)});
        this.interactions = new IInteraction[]{new InteractionInput(this, this.stackHandler), new InteractionToggleOpen()};
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.allowAutomation() && facing == EnumFacing.DOWN && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.allowAutomation() && facing == EnumFacing.DOWN && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.stackHandler);
        }
        return null;
    }

    public abstract boolean allowAutomation();

    public abstract int getItemCapacity();

    public void setOpen(boolean open) {
        if (open && !this.isOpen()) {
            IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_180501_a(this.field_174879_c, blockState.func_177226_a(BlockBagBase.TYPE, (Comparable)((Object)BlockBagBase.EnumType.OPEN)), 3);
        } else if (!open && this.isOpen()) {
            IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_180501_a(this.field_174879_c, blockState.func_177226_a(BlockBagBase.TYPE, (Comparable)((Object)BlockBagBase.EnumType.CLOSED)), 3);
        }
    }

    public StackHandler getStackHandler() {
        return this.stackHandler;
    }

    public int getItemCount() {
        return this.stackHandler.getTotalItemCount();
    }

    protected boolean isItemValidForInsertion(ItemStack itemStack) {
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        Block block = blockState.func_177230_c();
        if (block instanceof BlockBagBase) {
            return ((BlockBagBase)block).isItemValidForInsertion(itemStack);
        }
        return false;
    }

    public boolean isOpen() {
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        Block block = blockState.func_177230_c();
        if (block instanceof BlockBagBase) {
            return ((BlockBagBase)block).isOpen(blockState);
        }
        return false;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("stackHandler", (NBTBase)this.stackHandler.serializeNBT());
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.stackHandler.deserializeNBT(compound.func_74775_l("stackHandler"));
    }

    public IInteraction[] getInteractions() {
        return this.interactions;
    }

    public EnumFacing getTileFacing(World world, BlockPos pos, IBlockState blockState) {
        if (blockState.func_177230_c() instanceof BlockBagBase) {
            return (EnumFacing)blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        }
        return super.getTileFacing(world, pos, blockState);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    public static class StackHandler
    extends LargeDynamicItemLimitedStackHandler
    implements ITileDataItemStackHandler {
        private final Predicate<ItemStack> filter;

        public StackHandler(int itemCapacity, Predicate<ItemStack> filter) {
            super(10, itemCapacity);
            this.filter = filter;
        }

        public ItemStack insertItem(ItemStack itemStack, boolean simulate) {
            if (this.filter.test(itemStack)) {
                return super.insertItem(itemStack, simulate);
            }
            return itemStack;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (this.filter.test(stack)) {
                return super.insertItem(stack, simulate);
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            for (int i = this.getSlots() - 1; i >= 0; --i) {
                if (this.getStackInSlot(i).func_190926_b()) continue;
                return super.extractItem(i, amount, simulate);
            }
            return ItemStack.field_190927_a;
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return Integer.MAX_VALUE;
        }
    }

    public static class InteractionInput
    extends InteractionItemStack<TileBagBase> {
        private final TileBagBase tile;
        private final StackHandler stackHandler;

        InteractionInput(TileBagBase tile, StackHandler stackHandler) {
            super(new ItemStackHandler[]{stackHandler}, 0, new EnumFacing[]{EnumFacing.UP}, BlockBagBase.AABB_NORTH, new Transform(Transform.translate((double)0.5, (double)0.625, (double)0.5), Transform.rotate(), Transform.scale((double)0.5, (double)0.5, (double)0.5)));
            this.tile = tile;
            this.stackHandler = stackHandler;
        }

        public TileBagBase getTile() {
            return this.tile;
        }

        public boolean isEnabled() {
            return this.tile.isOpen();
        }

        protected boolean doItemStackValidation(ItemStack itemStack) {
            return this.tile.isItemValidForInsertion(itemStack);
        }

        public boolean isEmpty() {
            return this.stackHandler.getTotalItemCount() == 0;
        }

        protected void onInsert(IInteraction.EnumType type, ItemStack itemStack, World world, EntityPlayer player, BlockPos pos) {
            super.onInsert(type, itemStack, world, player, pos);
            if (!world.field_72995_K && type == IInteraction.EnumType.MouseClick) {
                world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187552_ah, SoundCategory.BLOCKS, 0.5f, (float)(1.0 + RandomHelper.random().nextGaussian() * (double)0.4f));
            }
        }

        public void renderSolidPass(World world, RenderItem renderItem, BlockPos pos, IBlockState blockState, float partialTicks) {
            BagInteractionInputRenderer.INSTANCE.renderSolidPass(this, world, renderItem, pos, blockState, partialTicks);
        }

        public void renderSolidPassText(World world, FontRenderer fontRenderer, int yaw, Vec3d offset, BlockPos pos, IBlockState blockState, float partialTicks) {
            BagInteractionInputRenderer.INSTANCE.renderSolidPassText(this, world, fontRenderer, yaw, offset, pos, blockState, partialTicks);
        }

        public boolean renderAdditivePass(World world, RenderItem renderItem, EnumFacing hitSide, Vec3d hitVec, BlockPos hitPos, IBlockState blockState, ItemStack heldItemMainHand, float partialTicks) {
            return BagInteractionInputRenderer.INSTANCE.renderAdditivePass(this, world, renderItem, hitSide, hitVec, hitPos, blockState, heldItemMainHand, partialTicks);
        }
    }

    public static class InteractionToggleOpen
    extends InteractionBase<TileBagBase> {
        InteractionToggleOpen() {
            super(EnumFacing.field_82609_l, BlockBagBase.AABB_NORTH);
        }

        public boolean interact(IInteraction.EnumType type, TileBagBase tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            if (type == IInteraction.EnumType.MouseClick) {
                tile.setOpen(!tile.isOpen());
                return true;
            }
            return false;
        }
    }
}

