/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.storage.tile;

import com.codetaylor.mc.athenaeum.integration.gamestages.Stages;
import com.codetaylor.mc.athenaeum.interaction.api.Transform;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.ITileInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionItemStack;
import com.codetaylor.mc.athenaeum.inventory.LargeObservableStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataLargeItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileEntityDataBase;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.modules.storage.ModuleStorage;
import com.codetaylor.mc.pyrotech.modules.storage.ModuleStorageConfig;
import com.codetaylor.mc.pyrotech.modules.storage.block.spi.BlockShelfBase;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileShelf
extends TileEntityDataBase
implements ITileInteractable {
    private StackHandler stackHandler = new StackHandler(this.getMaxStacks());
    private IInteraction[] interactions;

    public TileShelf() {
        super(ModuleStorage.TILE_DATA_SERVICE);
        this.stackHandler.addObserver((handler, slot) -> this.func_70296_d());
        this.registerTileDataForNetwork(new ITileData[]{new TileDataLargeItemStackHandler((ItemStackHandler)this.stackHandler)});
        this.interactions = new IInteraction[12];
        ArrayList<ShelfInteraction> interactionList = new ArrayList<ShelfInteraction>();
        for (int i = 0; i < 9; ++i) {
            int x = i % 3;
            int y = i / 3;
            interactionList.add(new ShelfInteraction(this, (ItemStackHandler)this.stackHandler, i, x, y));
        }
        this.interactions = interactionList.toArray(new IInteraction[0]);
    }

    protected int getMaxStacks() {
        return ModuleStorageConfig.SHELF.MAX_STACKS;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.allowAutomation() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.allowAutomation() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.stackHandler);
        }
        return null;
    }

    protected boolean allowAutomation() {
        return ModuleStorageConfig.SHELF.ALLOW_AUTOMATION;
    }

    public void dropContents() {
        StackHelper.spawnStackHandlerContentsOnTop((World)this.field_145850_b, (ItemStackHandler)this.stackHandler, (BlockPos)this.field_174879_c);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.stackHandler.deserializeNBT(compound.func_74775_l("shelfStackHandler"));
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("shelfStackHandler", (NBTBase)this.stackHandler.serializeNBT());
        return compound;
    }

    @Nullable
    public Stages getStages() {
        return ModuleStorageConfig.STAGES_SHELF;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    public IInteraction[] getInteractions() {
        return this.interactions;
    }

    public EnumFacing getTileFacing(World world, BlockPos pos, IBlockState blockState) {
        if (blockState.func_177230_c() == ModuleStorage.Blocks.SHELF || blockState.func_177230_c() == ModuleStorage.Blocks.SHELF_STONE) {
            return (EnumFacing)blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        }
        return super.getTileFacing(world, pos, blockState);
    }

    private class StackHandler
    extends LargeObservableStackHandler
    implements ITileDataItemStackHandler {
        private final int maxStacks;

        StackHandler(int maxStacks) {
            super(9);
            this.maxStacks = maxStacks;
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return stack.func_77976_d() * this.maxStacks;
        }
    }

    private class ShelfInteraction
    extends InteractionItemStack<TileShelf> {
        private static final double ONE_THIRD = 0.3333333333333333;
        private static final double ONE_SIXTH = 0.16666666666666666;
        private final Transform forwardTransform;
        private final AxisAlignedBB forwardBounds;
        private final TileShelf tile;

        ShelfInteraction(TileShelf tile, ItemStackHandler stackHandler, int slot, double x, int y) {
            super(new ItemStackHandler[]{stackHandler}, slot, new EnumFacing[]{EnumFacing.NORTH}, new AxisAlignedBB(x * 0.3333333333333333, (double)y * 0.3333333333333333, 0.75, x * 0.3333333333333333 + 0.3333333333333333, (double)y * 0.3333333333333333 + 0.3333333333333333, 1.0), new Transform(Transform.translate((double)(x * 0.3083333333333333 + 0.16666666666666666 + 0.025), (double)((double)y * 0.3083333333333333 + 0.16666666666666666), (double)0.8083333333333332), Transform.rotate((double)0.0, (double)1.0, (double)0.0, (double)180.0), Transform.scale((double)0.2, (double)0.2, (double)0.2)));
            this.tile = tile;
            this.forwardBounds = new AxisAlignedBB(x * 0.3333333333333333, (double)y * 0.3333333333333333, 0.125, x * 0.3333333333333333 + 0.3333333333333333, (double)y * 0.3333333333333333 + 0.3333333333333333, 0.375);
            this.forwardTransform = new Transform(Transform.translate((double)(x * 0.3083333333333333 + 0.16666666666666666 + 0.025), (double)((double)y * 0.3083333333333333 + 0.16666666666666666), (double)0.14166666666666666), Transform.rotate((double)0.0, (double)1.0, (double)0.0, (double)180.0), Transform.scale((double)0.2, (double)0.2, (double)0.2));
        }

        public Transform getTransform(World world, BlockPos pos, IBlockState blockState, ItemStack itemStack, float partialTicks) {
            BlockShelfBase.EnumType type;
            if (blockState.func_177230_c() instanceof BlockShelfBase && (type = (BlockShelfBase.EnumType)((Object)blockState.func_177229_b(BlockShelfBase.TYPE))) == BlockShelfBase.EnumType.FORWARD) {
                return this.forwardTransform;
            }
            return super.getTransform(world, pos, blockState, itemStack, partialTicks);
        }

        public AxisAlignedBB getInteractionBounds(World world, BlockPos pos, IBlockState blockState) {
            BlockShelfBase.EnumType type;
            if (blockState.func_177230_c() instanceof BlockShelfBase && (type = (BlockShelfBase.EnumType)((Object)blockState.func_177229_b(BlockShelfBase.TYPE))) == BlockShelfBase.EnumType.FORWARD) {
                return this.forwardBounds;
            }
            return super.getInteractionBounds(world, pos, blockState);
        }

        public Vec3d getTextOffset(EnumFacing tileFacing, EnumFacing playerHorizontalFacing, EnumFacing sideHit) {
            return new Vec3d(0.0, 0.125, 0.0);
        }
    }
}

