/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.storage.client.render;

import com.codetaylor.mc.athenaeum.parser.recipe.item.MalformedRecipeItemException;
import com.codetaylor.mc.athenaeum.parser.recipe.item.RecipeItemParser;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.pyrotech.library.util.BlockMetaMatcher;
import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.modules.storage.ModuleStorage;
import com.codetaylor.mc.pyrotech.modules.storage.ModuleStorageConfig;
import com.codetaylor.mc.pyrotech.modules.storage.block.spi.BlockFaucetBase;
import com.codetaylor.mc.pyrotech.modules.storage.tile.spi.TileFaucetBase;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class TESRFaucet
extends TileEntitySpecialRenderer<TileFaucetBase> {
    private static final Map<BlockMetaMatcher, Integer> BLOCK_META_MATCHERS = new LinkedHashMap<BlockMetaMatcher, Integer>();
    private static final float PX = 0.0625f;

    public static void updateBlockMatchersFromConfig() {
        BLOCK_META_MATCHERS.clear();
        Map<String, Integer> map = ModuleStorageConfig.FAUCET_COMMON.FLUID_RENDER_CUTOFF;
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            try {
                BlockMetaMatcher blockMetaMatcher = Util.parseBlockStringWithWildcard(entry.getKey(), RecipeItemParser.INSTANCE);
                BLOCK_META_MATCHERS.put(blockMetaMatcher, Math.max(0, Math.min(16, entry.getValue())));
            }
            catch (MalformedRecipeItemException e) {
                ModuleStorage.LOGGER.error("Error parsing block string: " + entry.getKey(), (Throwable)e);
            }
        }
    }

    public final void render(TileFaucetBase tile, double x, double y, double z, float partialTicks, int destroyStage, float partial) {
        if (!tile.isActive()) {
            return;
        }
        World world = this.func_178459_a();
        IBlockState blockState = world.func_180495_p(tile.func_174877_v());
        if (!(blockState.func_177230_c() instanceof BlockFaucetBase)) {
            return;
        }
        EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        this.func_147499_a(TextureMap.field_110575_b);
        RenderHelper.func_74518_a();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.5, (double)0.0, (double)0.5);
        switch (facing) {
            case EAST: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179114_b((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)-270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)-0.5);
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        this.renderTileEntityFast(tile, x, y, z, partialTicks, destroyStage, partial, buffer);
        buffer.func_178969_c(0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        RenderHelper.func_74519_b();
    }

    public void renderTileEntityFast(TileFaucetBase tile, double x, double y, double z, float partialTicks, int destroyStage, float partial, BufferBuilder buffer) {
        FluidStack fluidStack = tile.getFluid();
        if (fluidStack == null) {
            return;
        }
        World world = tile.func_145831_w();
        BlockPos downPos = tile.func_174877_v().func_177977_b();
        IBlockState downState = world.func_180495_p(downPos);
        double maxHeight = -0.9375;
        for (Map.Entry<BlockMetaMatcher, Integer> entry : BLOCK_META_MATCHERS.entrySet()) {
            if (!entry.getKey().test(downState)) continue;
            maxHeight = (float)(-entry.getValue().intValue()) / 16.0f;
            break;
        }
        Fluid fluid = fluidStack.getFluid();
        TextureMap textureMapBlocks = Minecraft.func_71410_x().func_147117_R();
        TextureAtlasSprite still = textureMapBlocks.func_110572_b(fluid.getStill(fluidStack).toString());
        TextureAtlasSprite flowing = textureMapBlocks.func_110572_b(fluid.getFlowing(fluidStack).toString());
        int color = fluid.getColor(fluidStack);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color >> 0 & 0xFF) / 255.0f;
        BlockPos blockpos = new BlockPos((Vec3i)tile.func_174877_v());
        int i = tile.func_145831_w().func_175667_e(blockpos) ? tile.func_145831_w().func_175626_b(blockpos, 0) : 0;
        int j = i >> 16 & 0xFFFF;
        int k = i & 0xFFFF;
        buffer.func_181662_b(0.625, 0.625, 1.0).func_181666_a(r, g, b, 1.0f).func_187315_a((double)flowing.func_94214_a(5.0), (double)flowing.func_94207_b(0.0)).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(0.375, 0.625, 1.0).func_181666_a(r, g, b, 1.0f).func_187315_a((double)flowing.func_94214_a(3.0), (double)flowing.func_94207_b(0.0)).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(0.375, 0.625, 0.5).func_181666_a(r, g, b, 1.0f).func_187315_a((double)flowing.func_94214_a(3.0), (double)flowing.func_94207_b(4.0)).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(0.625, 0.625, 0.5).func_181666_a(r, g, b, 1.0f).func_187315_a((double)flowing.func_94214_a(5.0), (double)flowing.func_94207_b(4.0)).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(0.625, maxHeight, 0.625).func_181666_a(r, g, b, 1.0f).func_187315_a((double)still.func_94214_a(7.0), (double)still.func_94207_b(0.0)).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(0.375, maxHeight, 0.625).func_181666_a(r, g, b, 1.0f).func_187315_a((double)still.func_94214_a(3.0), (double)still.func_94207_b(0.0)).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(0.375, maxHeight, 0.5).func_181666_a(r, g, b, 1.0f).func_187315_a((double)still.func_94214_a(3.0), (double)still.func_94207_b(2.0)).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(0.625, maxHeight, 0.5).func_181666_a(r, g, b, 1.0f).func_187315_a((double)still.func_94214_a(7.0), (double)still.func_94207_b(2.0)).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(0.625, 0.625, 0.625).func_181666_a(r, g, b, 1.0f).func_187315_a((double)flowing.func_94214_a(1.0), (double)flowing.func_94207_b(0.0)).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(0.625, 0.625, 0.5).func_181666_a(r, g, b, 1.0f).func_187315_a((double)flowing.func_94214_a(0.0), (double)flowing.func_94207_b(0.0)).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(0.625, maxHeight, 0.5).func_181666_a(r, g, b, 1.0f).func_187315_a((double)flowing.func_94214_a(0.0), (double)flowing.func_94207_b(5.0 + -maxHeight * 8.0)).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(0.625, maxHeight, 0.625).func_181666_a(r, g, b, 1.0f).func_187315_a((double)flowing.func_94214_a(1.0), (double)flowing.func_94207_b(5.0 + -maxHeight * 8.0)).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(0.375, 0.625, 0.625).func_181666_a(r, g, b, 1.0f).func_187315_a((double)flowing.func_94214_a(1.0), (double)flowing.func_94207_b(0.0)).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(0.375, 0.625, 0.5).func_181666_a(r, g, b, 1.0f).func_187315_a((double)flowing.func_94214_a(0.0), (double)flowing.func_94207_b(0.0)).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(0.375, maxHeight, 0.5).func_181666_a(r, g, b, 1.0f).func_187315_a((double)flowing.func_94214_a(0.0), (double)flowing.func_94207_b(5.0 + -maxHeight * 8.0)).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(0.375, maxHeight, 0.625).func_181666_a(r, g, b, 1.0f).func_187315_a((double)flowing.func_94214_a(1.0), (double)flowing.func_94207_b(5.0 + -maxHeight * 8.0)).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(0.625, 0.625, 0.5).func_181666_a(r, g, b, 1.0f).func_187315_a((double)flowing.func_94214_a(2.0), (double)flowing.func_94207_b(0.0)).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(0.375, 0.625, 0.5).func_181666_a(r, g, b, 1.0f).func_187315_a((double)flowing.func_94214_a(0.0), (double)flowing.func_94207_b(0.0)).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(0.375, maxHeight, 0.5).func_181666_a(r, g, b, 1.0f).func_187315_a((double)flowing.func_94214_a(0.0), (double)flowing.func_94207_b(5.0 + -maxHeight * 8.0)).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(0.625, maxHeight, 0.5).func_181666_a(r, g, b, 1.0f).func_187315_a((double)flowing.func_94214_a(2.0), (double)flowing.func_94207_b(5.0 + -maxHeight * 8.0)).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(0.625, 0.25, 0.625).func_181666_a(r, g, b, 1.0f).func_187315_a((double)flowing.func_94214_a(2.0), (double)flowing.func_94207_b(0.0)).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(0.375, 0.25, 0.625).func_181666_a(r, g, b, 1.0f).func_187315_a((double)flowing.func_94214_a(0.0), (double)flowing.func_94207_b(0.0)).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(0.375, maxHeight, 0.625).func_181666_a(r, g, b, 1.0f).func_187315_a((double)flowing.func_94214_a(0.0), (double)flowing.func_94207_b(2.0 + -maxHeight * 8.0)).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(0.625, maxHeight, 0.625).func_181666_a(r, g, b, 1.0f).func_187315_a((double)flowing.func_94214_a(2.0), (double)flowing.func_94207_b(2.0 + -maxHeight * 8.0)).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(0.625, 0.625, 1.0).func_181666_a(r, g, b, 1.0f).func_187315_a((double)flowing.func_94214_a(2.0), (double)flowing.func_94207_b(0.0)).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(0.375, 0.625, 1.0).func_181666_a(r, g, b, 1.0f).func_187315_a((double)flowing.func_94214_a(0.0), (double)flowing.func_94207_b(0.0)).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(0.375, 0.375, 1.0).func_181666_a(r, g, b, 1.0f).func_187315_a((double)flowing.func_94214_a(0.0), (double)flowing.func_94207_b(2.0)).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(0.625, 0.375, 1.0).func_181666_a(r, g, b, 1.0f).func_187315_a((double)flowing.func_94214_a(2.0), (double)flowing.func_94207_b(2.0)).func_187314_a(j, k).func_181675_d();
    }
}

