/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.storage.block.spi;

import com.codetaylor.mc.athenaeum.interaction.spi.IBlockInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.spi.BlockPartialBase;
import com.codetaylor.mc.athenaeum.spi.IVariant;
import com.codetaylor.mc.athenaeum.util.BlockHelper;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.modules.storage.tile.spi.TileTankBase;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public abstract class BlockTankBase
extends BlockPartialBase
implements IBlockInteractable {
    public static final IProperty<EnumConnection> CONNECTION = PropertyEnum.func_177709_a((String)"connection", EnumConnection.class);

    public BlockTankBase() {
        super(Material.field_151576_e);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(2.0f);
    }

    @ParametersAreNonnullByDefault
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        this.updateConnectionState(world, pos);
        this.updateTankGroups(world, pos);
        this.settleFluids(world, pos);
    }

    @ParametersAreNonnullByDefault
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.updateConnectionState(world, pos);
    }

    private void updateConnectionState(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileTankBase) {
            TileTankBase tileTankBase = (TileTankBase)tileEntity;
            tileTankBase.updateConnectionState();
            BlockHelper.notifyBlockUpdate((World)world, (BlockPos)pos);
        }
    }

    private void updateTankGroups(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileTankBase) {
            TileTankBase tileTankBase = (TileTankBase)tileEntity;
            tileTankBase.updateTankGroups();
        }
    }

    private void settleFluids(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileTankBase) {
            TileTankBase tileTankBase = (TileTankBase)tileEntity;
            tileTankBase.settleFluids();
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileTankBase) {
            TileTankBase tile = (TileTankBase)tileEntity;
            FluidTank fluidTank = tile.getFluidTank();
            FluidStack fluid = fluidTank.getFluid();
            int fluidAmount = fluidTank.getFluidAmount();
            if (fluid != null && fluidAmount > 0) {
                int luminosity = fluid.getFluid().getLuminosity(fluid);
                return MathHelper.func_76125_a((int)luminosity, (int)0, (int)15);
            }
        }
        return super.getLightValue(state, world, pos);
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        RayTraceResult result = super.func_180636_a(blockState, world, pos, start, end);
        return this.interactionRayTrace(result, blockState, world, pos, start, end);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.interact(IInteraction.EnumType.MouseClick, world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(@Nonnull World world, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        if (!world.field_72995_K) {
            world.func_175698_g(pos);
        }
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileTankBase) {
            if (this.canHoldContentsWhenBroken()) {
                drops.add((Object)StackHelper.createItemStackFromTileEntity((Block)this, (int)1, (int)0, (TileEntity)tileEntity));
            } else {
                super.getDrops(drops, world, pos, state, fortune);
            }
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean isSideSolid(IBlockState base_state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        return true;
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    @ParametersAreNonnullByDefault
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return super.canRenderInLayer(state, layer);
    }

    public void func_190948_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flag) {
        NBTTagCompound tileTag;
        NBTTagCompound stackTag = stack.func_77978_p();
        if (stackTag == null) {
            this.addInformationCapacity(tooltip);
        } else if (stackTag.func_74764_b("BlockEntityTag") && (tileTag = stackTag.func_74775_l("BlockEntityTag")).func_74764_b("tank")) {
            NBTTagCompound tankTag = tileTag.func_74775_l("tank");
            if (tankTag.func_74764_b("Empty") && (!tankTag.func_74764_b("Amount") || tankTag.func_74762_e("Amount") <= 0)) {
                this.addInformationCapacity(tooltip);
            } else {
                FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tankTag);
                if (fluidStack != null) {
                    String localizedName = fluidStack.getLocalizedName();
                    int amount = fluidStack.amount;
                    int capacity = this.getCapacity();
                    tooltip.add(I18n.func_74837_a((String)"gui.pyrotech.tooltip.fluid", (Object[])new Object[]{localizedName, amount, capacity}));
                }
            }
        }
        boolean hotFluids = this.canHoldHotFluids();
        tooltip.add((hotFluids ? TextFormatting.GREEN : TextFormatting.RED) + I18n.func_74837_a((String)("gui.pyrotech.tooltip.hot.fluids." + hotFluids), (Object[])new Object[0]));
        boolean holdsContents = this.canHoldContentsWhenBroken();
        tooltip.add((holdsContents ? TextFormatting.GREEN : TextFormatting.RED) + I18n.func_74837_a((String)("gui.pyrotech.tooltip.contents.retain." + holdsContents), (Object[])new Object[0]));
    }

    protected abstract int getCapacity();

    protected abstract boolean canHoldHotFluids();

    protected abstract boolean canHoldContentsWhenBroken();

    private void addInformationCapacity(@Nonnull List<String> tooltip) {
        int capacity = this.getCapacity();
        tooltip.add(I18n.func_74837_a((String)"gui.pyrotech.tooltip.fluid.capacity", (Object[])new Object[]{capacity}));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileTankBase) {
            state = state.func_177226_a(CONNECTION, (Comparable)((Object)((TileTankBase)tileEntity).getConnectionState()));
        }
        return super.func_176221_a(state, world, pos);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CONNECTION});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public static enum EnumConnection implements IVariant
    {
        NONE(0, "none"),
        UP(1, "up"),
        DOWN(2, "down"),
        BOTH(3, "both");

        private static final EnumConnection[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumConnection(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public static EnumConnection fromMeta(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = (EnumConnection[])Stream.of(EnumConnection.values()).sorted(Comparator.comparing(EnumConnection::getMeta)).toArray(EnumConnection[]::new);
        }
    }
}

