/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.ignition.tile.spi;

import com.codetaylor.mc.athenaeum.interaction.api.InteractionBounds;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.ITileInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionBucketBase;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionUseItemBase;
import com.codetaylor.mc.athenaeum.spi.TileEntityBase;
import com.codetaylor.mc.athenaeum.util.SoundHelper;
import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.modules.ignition.block.spi.BlockTorchBase;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public abstract class TileTorchBase
extends TileEntityBase
implements ITileInteractable,
ITickable {
    private int duration = (int)((double)this.getDuration() + (Math.random() * 2.0 - 1.0) * (double)this.getDurationVariant());
    private long lastTimeStamp;
    private IInteraction[] interactions = new IInteraction[]{new InteractionBucket(), new InteractionUseItemToActivate(Items.field_151033_d, EnumFacing.field_82609_l)};
    private boolean firstLightCheck;

    public void activate() {
        if (!this.isLit() && !this.shouldDouse()) {
            this.setLit();
        }
    }

    private void setLit() {
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_175656_a(this.field_174879_c, blockState.func_177226_a(BlockTorchBase.TYPE, (Comparable)((Object)BlockTorchBase.EnumType.LIT)));
    }

    private boolean isLit() {
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        return blockState.func_177229_b(BlockTorchBase.TYPE) == BlockTorchBase.EnumType.LIT;
    }

    private void setDoused() {
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_175656_a(this.field_174879_c, blockState.func_177226_a(BlockTorchBase.TYPE, (Comparable)((Object)BlockTorchBase.EnumType.DOUSED)));
    }

    private boolean shouldDouse() {
        return this.isExtinguishedByRain() && this.field_145850_b.func_175727_C(this.field_174879_c.func_177984_a());
    }

    protected abstract boolean isExtinguishedByRain();

    protected abstract boolean shouldBurnUp();

    protected abstract int getDuration();

    protected abstract int getDurationVariant();

    public void func_73660_a() {
        if (!this.firstLightCheck) {
            this.firstLightCheck = true;
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
        }
    }

    public void randomUpdate() {
        if (this.isLit()) {
            if (this.shouldDouse()) {
                this.setDoused();
            } else if (this.shouldBurnUp()) {
                if (this.lastTimeStamp == 0L) {
                    this.lastTimeStamp = this.field_145850_b.func_82737_E();
                } else {
                    long totalWorldTime = this.field_145850_b.func_82737_E();
                    this.duration = (int)((long)this.duration - (totalWorldTime - this.lastTimeStamp));
                    this.lastTimeStamp = totalWorldTime;
                }
                if (this.duration <= 0) {
                    this.field_145850_b.func_175698_g(this.field_174879_c);
                }
            }
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("duration", this.duration);
        compound.func_74772_a("lastTimeStamp", this.lastTimeStamp);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.duration = compound.func_74762_e("duration");
        this.lastTimeStamp = compound.func_74763_f("lastTimeStamp");
        this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
    }

    protected void func_190201_b(World world) {
        this.func_145834_a(world);
    }

    public IInteraction[] getInteractions() {
        return this.interactions;
    }

    public class InteractionUseItemToActivate
    extends InteractionUseItemBase<TileTorchBase> {
        private final Item item;

        InteractionUseItemToActivate(Item item, EnumFacing[] sides) {
            super(sides, InteractionBounds.BLOCK);
            this.item = item;
        }

        public AxisAlignedBB getInteractionBounds(World world, BlockPos pos, IBlockState blockState) {
            return blockState.func_177230_c().func_185496_a(blockState, (IBlockAccess)world, pos);
        }

        protected boolean allowInteraction(TileTorchBase tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            return player.func_184586_b(hand).func_77973_b() == this.item;
        }

        protected boolean doInteraction(TileTorchBase tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            if (!world.field_72995_K && !tile.shouldDouse()) {
                tile.activate();
                world.func_184133_a(null, hitPos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, Util.RANDOM.nextFloat() * 0.4f + 0.8f);
            }
            return true;
        }
    }

    private class InteractionBucket
    extends InteractionBucketBase<TileTorchBase> {
        InteractionBucket() {
            super((IFluidHandler)new FluidTank(1000){

                public boolean canFillFluidType(FluidStack fluid) {
                    return fluid != null && fluid.getFluid() == FluidRegistry.WATER;
                }

                public int fillInternal(FluidStack resource, boolean doFill) {
                    int filled = super.fillInternal(resource, doFill);
                    this.setFluid(null);
                    return filled;
                }
            }, EnumFacing.field_82609_l, InteractionBounds.BLOCK);
        }

        protected boolean doInteraction(TileTorchBase tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            if (!tile.isLit()) {
                return false;
            }
            if (super.doInteraction((TileEntity)tile, world, hitPos, state, player, hand, hitSide, hitX, hitY, hitZ)) {
                tile.setDoused();
                if (!world.field_72995_K) {
                    SoundHelper.playSoundServer((World)world, (BlockPos)tile.func_174877_v(), (SoundEvent)SoundEvents.field_187646_bt, (SoundCategory)SoundCategory.BLOCKS);
                }
                tile.lastTimeStamp = 0L;
                return true;
            }
            return false;
        }
    }
}

