/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.ignition.block.spi;

import com.codetaylor.mc.athenaeum.interaction.spi.IBlockInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.spi.IVariant;
import com.codetaylor.mc.pyrotech.library.spi.block.IBlockIgnitableWithIgniterItem;
import com.codetaylor.mc.pyrotech.modules.ignition.item.ItemIgniterBase;
import com.codetaylor.mc.pyrotech.modules.ignition.tile.spi.TileTorchBase;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockTorchBase
extends BlockTorch
implements IBlockInteractable,
IBlockIgnitableWithIgniterItem {
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);
    private static final AxisAlignedBB STANDING_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.75, 0.625);
    private static final AxisAlignedBB TORCH_NORTH_AABB = new AxisAlignedBB((double)0.35f, (double)0.2f, (double)0.7f, (double)0.65f, 0.875, 1.0);
    private static final AxisAlignedBB TORCH_SOUTH_AABB = new AxisAlignedBB((double)0.35f, (double)0.2f, 0.0, (double)0.65f, 0.875, (double)0.3f);
    private static final AxisAlignedBB TORCH_WEST_AABB = new AxisAlignedBB((double)0.7f, (double)0.2f, (double)0.35f, 1.0, 0.875, (double)0.65f);
    private static final AxisAlignedBB TORCH_EAST_AABB = new AxisAlignedBB(0.0, (double)0.2f, (double)0.35f, (double)0.3f, 0.875, (double)0.65f);

    public BlockTorchBase() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176596_a, (Comparable)EnumFacing.UP).func_177226_a(TYPE, (Comparable)((Object)EnumType.UNLIT)));
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)field_176596_a)) {
            case EAST: {
                return TORCH_EAST_AABB;
            }
            case WEST: {
                return TORCH_WEST_AABB;
            }
            case SOUTH: {
                return TORCH_SOUTH_AABB;
            }
            case NORTH: {
                return TORCH_NORTH_AABB;
            }
        }
        return STANDING_AABB;
    }

    @Override
    public void igniteWithIgniterItem(World world, BlockPos pos, IBlockState blockState, EnumFacing facing) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileTorchBase) {
            ((TileTorchBase)tileEntity).activate();
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumType type = (EnumType)((Object)state.func_177229_b(TYPE));
        if (type == EnumType.LIT) {
            return this.getLightValue();
        }
        return super.getLightValue(state, world, pos);
    }

    protected abstract int getLightValue();

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileTorchBase) {
            ((TileTorchBase)tile).randomUpdate();
            world.func_175684_a(pos, state.func_177230_c(), (10 + rand.nextInt(10)) * 20);
        }
    }

    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (state.func_177229_b(TYPE) == EnumType.LIT) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)field_176596_a);
            double x = (double)pos.func_177958_n() + 0.5 + (rand.nextDouble() * 2.0 - 1.0) * 0.1;
            double y = (double)pos.func_177956_o() + 0.7 + 0.125;
            double z = (double)pos.func_177952_p() + 0.5 + (rand.nextDouble() * 2.0 - 1.0) * 0.1;
            if (enumfacing.func_176740_k().func_176722_c()) {
                EnumFacing enumfacing1 = enumfacing.func_176734_d();
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + 0.17 * (double)enumfacing1.func_82601_c(), y + 0.22, z + 0.17 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, x + 0.17 * (double)enumfacing1.func_82601_c(), y + 0.22, z + 0.17 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
            } else {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return this.createTileEntity();
    }

    public abstract TileEntity createTileEntity();

    public void func_185477_a(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB entityBox, @Nonnull List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean isActualState) {
        if (entity == null) {
            super.func_185477_a(state, world, pos, entityBox, collidingBoxes, null, isActualState);
        }
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return this.func_185496_a(blockState, world, pos);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        int fireDamage;
        if (state.func_177229_b(TYPE) == EnumType.LIT && (fireDamage = this.getFireDamage()) > 0) {
            AxisAlignedBB torchBox = this.func_180646_a(state, (IBlockAccess)world, pos);
            AxisAlignedBB entityBox = entity.func_174813_aQ();
            if (torchBox != null && torchBox.func_186670_a(pos).func_72326_a(entityBox)) {
                entity.func_70097_a(DamageSource.field_76372_a, (float)fireDamage);
            }
        }
    }

    protected abstract int getFireDamage();

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        return this.interactionRayTrace(super.func_180636_a(blockState, world, pos, start, end), blockState, world, pos, start, end);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem.func_77973_b() instanceof ItemIgniterBase) {
            return false;
        }
        return this.interact(IInteraction.EnumType.MouseClick, world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    @ParametersAreNonnullByDefault
    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        EnumType type = (EnumType)((Object)state.func_177229_b(TYPE));
        if (type == EnumType.UNLIT) {
            super.getDrops(drops, world, pos, state, fortune);
        } else {
            this.getLitDrops(drops);
        }
    }

    protected abstract void getLitDrops(NonNullList<ItemStack> var1);

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(@Nonnull World world, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        if (!world.field_72995_K) {
            world.func_175698_g(pos);
        }
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176596_a, TYPE});
    }

    public int func_176201_c(@Nonnull IBlockState blockState) {
        EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)field_176596_a);
        if (facing == EnumFacing.DOWN) {
            facing = EnumFacing.UP;
        }
        return facing.func_176745_a() - 1 + ((EnumType)((Object)blockState.func_177229_b(TYPE))).getMeta() * 5;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        int encodedFacing = meta % 5;
        int facingIndex = encodedFacing + 1;
        int type = (meta - encodedFacing) / 5;
        return this.func_176223_P().func_177226_a((IProperty)field_176596_a, (Comparable)EnumFacing.field_82609_l[facingIndex]).func_177226_a(TYPE, (Comparable)((Object)EnumType.fromMeta(type)));
    }

    public static enum EnumType implements IVariant
    {
        LIT(0, "lit"),
        UNLIT(1, "unlit"),
        DOUSED(2, "doused");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public static EnumType fromMeta(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = (EnumType[])Stream.of(EnumType.values()).sorted(Comparator.comparing(EnumType::getMeta)).toArray(EnumType[]::new);
        }
    }
}

