/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.core.plugin.top;

import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.apiimpl.client.ElementTextRender;
import mcjty.theoneprobe.network.NetworkTools;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;

public class PluginTOP {
    private static int ELEMENT_TEXT_LOCALIZED;
    private static int ELEMENT_ITEM_LABEL;
    private static int ELEMENT_TANK_LABEL;

    public static class ElementTankLabel
    implements IElement {
        private final String textFormatting;
        private final FluidStack fluidStack;
        private final int capacity;
        private String renderText;
        public static final String LANG_KEY = "gui.pyrotech.waila.tank.fluid";

        public ElementTankLabel(@Nullable TextFormatting textFormatting, FluidStack fluidStack, int capacity) {
            this.textFormatting = textFormatting == null ? null : textFormatting.toString();
            this.fluidStack = (FluidStack)Preconditions.checkNotNull((Object)fluidStack);
            this.capacity = capacity;
        }

        public ElementTankLabel(ByteBuf buf) {
            NBTTagCompound compound;
            int length = buf.readInt();
            this.textFormatting = length > 0 ? new PacketBuffer(buf).func_150789_c(length) : null;
            try {
                compound = new PacketBuffer(buf).func_150793_b();
            }
            catch (IOException e) {
                this.fluidStack = null;
                throw new RuntimeException("", e);
            }
            this.capacity = buf.readInt();
            this.fluidStack = compound != null ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound) : null;
            if (this.fluidStack != null) {
                StringBuilder builder = new StringBuilder();
                if (this.textFormatting != null) {
                    String localizedName = this.fluidStack.getLocalizedName();
                    this.renderText = this.textFormatting + Util.translateFormatted(LANG_KEY, localizedName, this.fluidStack.amount, this.capacity);
                } else {
                    String localizedName = this.fluidStack.getLocalizedName();
                    this.renderText = Util.translateFormatted(LANG_KEY, localizedName, this.fluidStack.amount, this.capacity);
                }
            }
        }

        public void render(int x, int y) {
            if (this.renderText != null) {
                ElementTextRender.render((String)this.renderText, (int)x, (int)y);
            }
        }

        public int getWidth() {
            if (this.renderText != null) {
                return ElementTextRender.getWidth((String)this.renderText);
            }
            return 10;
        }

        public int getHeight() {
            return 10;
        }

        public void toBytes(ByteBuf buf) {
            if (this.textFormatting == null) {
                buf.writeInt(0);
            } else {
                buf.writeInt(this.textFormatting.length());
                new PacketBuffer(buf).func_180714_a(this.textFormatting);
            }
            NBTTagCompound compound = this.fluidStack.writeToNBT(new NBTTagCompound());
            new PacketBuffer(buf).func_150786_a(compound);
            buf.writeInt(this.capacity);
        }

        public int getID() {
            return ELEMENT_TANK_LABEL;
        }
    }

    public static class ElementTextLocalized
    implements IElement {
        private static final byte DATA_TYPE_STRING = 0;
        private static final byte DATA_TYPE_FLOAT = 1;
        private static final byte DATA_TYPE_DOUBLE = 2;
        private static final byte DATA_TYPE_INT = 3;
        private static final byte DATA_TYPE_LONG = 4;
        private static final byte DATA_TYPE_ITEM_STACK = 5;
        private static final byte DATA_TYPE_FLUID_STACK = 6;
        private String textFormatting;
        private String langKey;
        private Object[] args;
        private String renderText;

        public ElementTextLocalized(String langKey, Object ... args) {
            this(null, langKey, args);
        }

        public ElementTextLocalized(@Nullable TextFormatting textFormatting, String langKey, Object ... args) {
            this.textFormatting = textFormatting != null ? textFormatting.toString() : null;
            this.langKey = langKey;
            this.args = args;
        }

        ElementTextLocalized(ByteBuf buf) {
            this.fromBytes(buf);
            this.renderText = this.textFormatting != null ? this.textFormatting + Util.translateFormatted(this.langKey, this.args) : Util.translateFormatted(this.langKey, this.args);
        }

        public void render(int x, int y) {
            ElementTextRender.render((String)this.renderText, (int)x, (int)y);
        }

        public int getWidth() {
            return ElementTextRender.getWidth((String)this.renderText);
        }

        public int getHeight() {
            return 10;
        }

        public void toBytes(ByteBuf buf) {
            PacketBuffer b = new PacketBuffer(buf);
            b.writeInt(this.langKey.length());
            b.func_180714_a(this.langKey);
            if (this.textFormatting == null) {
                b.writeInt(0);
            } else {
                b.writeInt(this.textFormatting.length());
                b.func_180714_a(this.textFormatting);
            }
            if (this.args == null || this.args.length == 0) {
                b.writeInt(0);
            } else {
                b.writeInt(this.args.length);
                for (Object arg : this.args) {
                    if (arg instanceof String) {
                        b.writeByte(0);
                        b.writeInt(((String)arg).length());
                        b.func_180714_a((String)arg);
                        continue;
                    }
                    if (arg instanceof Float) {
                        b.writeByte(1);
                        b.writeFloat(((Float)arg).floatValue());
                        continue;
                    }
                    if (arg instanceof Double) {
                        b.writeByte(2);
                        b.writeDouble(((Double)arg).doubleValue());
                        continue;
                    }
                    if (arg instanceof Integer) {
                        b.writeByte(3);
                        b.writeInt(((Integer)arg).intValue());
                        continue;
                    }
                    if (arg instanceof Long) {
                        b.writeByte(4);
                        b.writeLong(((Long)arg).longValue());
                        continue;
                    }
                    if (arg instanceof ItemStack) {
                        b.writeByte(5);
                        b.func_150788_a((ItemStack)arg);
                        continue;
                    }
                    if (arg instanceof FluidStack) {
                        b.writeByte(6);
                        b.func_150786_a(((FluidStack)arg).writeToNBT(new NBTTagCompound()));
                        continue;
                    }
                    throw new RuntimeException("Unknown data type: " + arg.getClass());
                }
            }
        }

        private void fromBytes(ByteBuf buf) {
            PacketBuffer b = new PacketBuffer(buf);
            this.langKey = b.func_150789_c(b.readInt());
            int textFormattingStringLength = b.readInt();
            if (textFormattingStringLength > 0) {
                this.textFormatting = b.func_150789_c(textFormattingStringLength);
            }
            int argCount = b.readInt();
            this.args = new Object[argCount];
            for (int i = 0; i < argCount; ++i) {
                byte dataType = b.readByte();
                if (dataType == 0) {
                    int length = b.readInt();
                    String key = b.func_150789_c(length);
                    this.args[i] = Util.translateFormatted(key, new Object[0]);
                    continue;
                }
                if (dataType == 1) {
                    this.args[i] = Float.valueOf(b.readFloat());
                    continue;
                }
                if (dataType == 2) {
                    this.args[i] = b.readDouble();
                    continue;
                }
                if (dataType == 3) {
                    this.args[i] = b.readInt();
                    continue;
                }
                if (dataType == 4) {
                    this.args[i] = b.readLong();
                    continue;
                }
                if (dataType == 5) {
                    try {
                        this.args[i] = b.func_150791_c().func_82833_r();
                    }
                    catch (IOException e) {
                        ModuleCore.LOGGER.error("", (Throwable)e);
                        this.args[i] = "ERROR";
                    }
                    continue;
                }
                if (dataType == 6) {
                    try {
                        NBTTagCompound compound = b.func_150793_b();
                        FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound);
                        if (fluidStack == null) {
                            this.args[i] = "ERROR";
                            continue;
                        }
                        this.args[i] = fluidStack.getLocalizedName();
                    }
                    catch (Exception e) {
                        ModuleCore.LOGGER.error("", (Throwable)e);
                        this.args[i] = "ERROR";
                    }
                    continue;
                }
                throw new RuntimeException("Unknown data type: " + dataType);
            }
        }

        public int getID() {
            return ELEMENT_TEXT_LOCALIZED;
        }
    }

    public static class ElementItemLabel
    implements IElement {
        private final String textFormatting;
        private final ItemStack itemStack;

        public ElementItemLabel(@Nullable TextFormatting textFormatting, ItemStack itemStack) {
            this(textFormatting == null ? null : textFormatting.toString(), itemStack);
        }

        public ElementItemLabel(@Nullable String textFormatting, ItemStack itemStack) {
            this.textFormatting = textFormatting;
            this.itemStack = itemStack;
        }

        public ElementItemLabel(ByteBuf buf) {
            int length = buf.readInt();
            this.textFormatting = length > 0 ? new PacketBuffer(buf).func_150789_c(length) : null;
            this.itemStack = buf.readBoolean() ? NetworkTools.readItemStack((ByteBuf)buf) : ItemStack.field_190927_a;
        }

        public void render(int x, int y) {
            if (!this.itemStack.func_190926_b()) {
                String text = this.itemStack.func_82833_r();
                if (this.textFormatting == null) {
                    ElementTextRender.render((String)text, (int)x, (int)y);
                } else {
                    ElementTextRender.render((String)(this.textFormatting + text), (int)x, (int)y);
                }
            }
        }

        public int getWidth() {
            if (!this.itemStack.func_190926_b()) {
                String text = this.itemStack.func_82833_r();
                return ElementTextRender.getWidth((String)text);
            }
            return 10;
        }

        public int getHeight() {
            return 10;
        }

        public void toBytes(ByteBuf buf) {
            if (this.textFormatting == null) {
                buf.writeInt(0);
            } else {
                buf.writeInt(this.textFormatting.length());
                new PacketBuffer(buf).func_180714_a(this.textFormatting);
            }
            if (!this.itemStack.func_190926_b()) {
                buf.writeBoolean(true);
                NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)this.itemStack);
            } else {
                buf.writeBoolean(false);
            }
        }

        public int getID() {
            return ELEMENT_ITEM_LABEL;
        }
    }

    public static class Callback
    implements Function<ITheOneProbe, Void> {
        @Override
        public Void apply(ITheOneProbe top) {
            ELEMENT_TEXT_LOCALIZED = top.registerElementFactory(ElementTextLocalized::new);
            ELEMENT_ITEM_LABEL = top.registerElementFactory(ElementItemLabel::new);
            ELEMENT_TANK_LABEL = top.registerElementFactory(ElementTankLabel::new);
            return null;
        }
    }
}

