/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.core.network;

import com.codetaylor.mc.athenaeum.util.ParticleHelper;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCoreConfig;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SCPacketParticleProgress
implements IMessage,
IMessageHandler<SCPacketParticleProgress, IMessage> {
    private int amount;
    private double x;
    private double y;
    private double z;
    private double rangeX;
    private double rangeY;
    private double rangeZ;

    public SCPacketParticleProgress() {
    }

    public SCPacketParticleProgress(double x, double y, double z, int amount) {
        this(x, y, z, 0.5, 0.15, 0.5, amount);
    }

    public SCPacketParticleProgress(double x, double y, double z, double rangeX, double rangeY, double rangeZ, int amount) {
        this.rangeX = rangeX;
        this.rangeY = rangeY;
        this.rangeZ = rangeZ;
        this.amount = amount;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.amount);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.rangeX);
        buf.writeDouble(this.rangeY);
        buf.writeDouble(this.rangeZ);
    }

    public void fromBytes(ByteBuf buf) {
        this.amount = buf.readInt();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.rangeX = buf.readDouble();
        this.rangeY = buf.readDouble();
        this.rangeZ = buf.readDouble();
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(SCPacketParticleProgress message, MessageContext ctx) {
        if (ModuleCoreConfig.CLIENT.SHOW_RECIPE_PROGRESSION_PARTICLES) {
            if (message.amount == 0) {
                message.amount = 15;
            }
            ParticleHelper.spawnProgressParticlesClient((int)message.amount, (double)message.x, (double)message.y, (double)message.z, (double)message.rangeX, (double)message.rangeY, (double)message.rangeZ);
        }
        return null;
    }
}

