/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.core.block;

import com.codetaylor.mc.athenaeum.spi.BlockPartialBase;
import com.codetaylor.mc.athenaeum.util.AABBHelper;
import com.codetaylor.mc.athenaeum.util.Properties;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockStrawBed
extends BlockPartialBase {
    public static final String NAME = "straw_bed";
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);
    public static final PropertyBool OCCUPIED = PropertyBool.func_177716_a((String)"occupied");
    private static final AxisAlignedBB AABB = AABBHelper.create((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);

    public BlockStrawBed() {
        super(Material.field_151580_n);
        this.func_149672_a(SoundType.field_185850_c);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return MapColor.field_151658_d;
    }

    @Nullable
    private EntityPlayer getPlayerInBed(World world, BlockPos pos) {
        for (EntityPlayer entityplayer : world.field_73010_i) {
            if (!entityplayer.func_70608_bn() || !entityplayer.field_71081_bT.equals((Object)pos)) continue;
            return entityplayer;
        }
        return null;
    }

    private boolean isFoot(IBlockState state) {
        return state.func_177230_c() == this && state.func_177229_b(TYPE) == EnumType.FOOT;
    }

    private boolean isHead(IBlockState state) {
        return state.func_177230_c() == this && state.func_177229_b(TYPE) == EnumType.HEAD;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_190946_v(@Nonnull IBlockState state) {
        return true;
    }

    @Nonnull
    public EnumPushReaction func_149656_h(@Nonnull IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    @ParametersAreNonnullByDefault
    public boolean isBed(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable Entity player) {
        return this.isFoot(state) || this.isHead(state) || super.isBed(state, world, pos, player);
    }

    public boolean isBedFoot(IBlockAccess world, @Nonnull BlockPos pos) {
        return this.isFoot(world.func_180495_p(pos));
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, @Nonnull Random rand, int fortune) {
        return state.func_177229_b(TYPE) == EnumType.FOOT ? Items.field_190931_a : Item.func_150898_a((Block)this);
    }

    @ParametersAreNonnullByDefault
    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (this.isHead(state)) {
            super.func_180653_a(world, pos, state, chance, fortune);
        }
    }

    @ParametersAreNonnullByDefault
    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockPos blockpos;
        if (player.field_71075_bZ.field_75098_d && this.isFoot(state) && world.func_180495_p(blockpos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL))).func_177230_c() == this) {
            world.func_175698_g(blockpos);
        }
    }

    @ParametersAreNonnullByDefault
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (this.isFoot(state) && (state = world.func_180495_p(pos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL)))).func_177230_c() != this) {
            return true;
        }
        WorldProvider.WorldSleepResult sleepResult = world.field_73011_w.canSleepAt(player, pos);
        if (sleepResult == WorldProvider.WorldSleepResult.DENY) {
            return true;
        }
        if (sleepResult == WorldProvider.WorldSleepResult.BED_EXPLODES) {
            this.explode(world, pos, state);
            return true;
        }
        if (((Boolean)state.func_177229_b((IProperty)OCCUPIED)).booleanValue()) {
            EntityPlayer entityplayer = this.getPlayerInBed(world, pos);
            if (entityplayer != null) {
                TextComponentTranslation message = new TextComponentTranslation("tile.bed.occupied", new Object[0]);
                player.func_146105_b((ITextComponent)message, true);
                return true;
            }
            state = state.func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.valueOf(false));
            world.func_180501_a(pos, state, 4);
        }
        switch (player.func_180469_a(pos)) {
            case OK: {
                state = state.func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.valueOf(true));
                world.func_180501_a(pos, state, 4);
                break;
            }
            case NOT_POSSIBLE_NOW: {
                TextComponentTranslation message = new TextComponentTranslation("tile.bed.noSleep", new Object[0]);
                player.func_146105_b((ITextComponent)message, true);
                break;
            }
            case NOT_SAFE: {
                TextComponentTranslation message = new TextComponentTranslation("tile.bed.notSafe", new Object[0]);
                player.func_146105_b((ITextComponent)message, true);
                break;
            }
            case TOO_FAR_AWAY: {
                TextComponentTranslation message = new TextComponentTranslation("tile.bed.tooFarAway", new Object[0]);
                player.func_146105_b((ITextComponent)message, true);
                break;
            }
        }
        return true;
    }

    private void explode(World world, BlockPos pos, IBlockState state) {
        world.func_175698_g(pos);
        BlockPos blockpos = pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL)).func_176734_d());
        if (world.func_180495_p(blockpos).func_177230_c() == this) {
            world.func_175698_g(blockpos);
        }
        world.func_72885_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 5.0f, true, true);
    }

    @ParametersAreNonnullByDefault
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        if (this.isFoot(state)) {
            BlockPos posOffset = pos.func_177972_a(enumfacing);
            if (world.func_180495_p(posOffset).func_177230_c() != this) {
                world.func_175698_g(pos);
            }
        } else {
            BlockPos posOffset = pos.func_177972_a(enumfacing.func_176734_d());
            if (world.func_180495_p(posOffset).func_177230_c() != this) {
                if (!world.field_72995_K) {
                    this.func_176226_b(world, pos, state, 0);
                }
                world.func_175698_g(pos);
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{Properties.FACING_HORIZONTAL, TYPE, OCCUPIED});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)meta);
        if ((meta & 8) > 0) {
            return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.HEAD)).func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)enumfacing).func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.valueOf((meta & 4) > 0));
        }
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.FOOT)).func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)enumfacing);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState iblockstate;
        if (this.isFoot(state) && (iblockstate = world.func_180495_p(pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL)))).func_177230_c() == this) {
            state = state.func_177226_a((IProperty)OCCUPIED, iblockstate.func_177229_b((IProperty)OCCUPIED));
        }
        return state;
    }

    @Nonnull
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        EnumFacing rotatedFacing = rot.func_185831_a(facing);
        return state.func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)rotatedFacing);
    }

    @Nonnull
    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        Rotation rotation = mirror.func_185800_a(facing);
        return state.func_185907_a(rotation);
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL)).func_176736_b();
        if (this.isHead(state)) {
            i |= 8;
            if (((Boolean)state.func_177229_b((IProperty)OCCUPIED)).booleanValue()) {
                i |= 4;
            }
        }
        return i;
    }

    public static enum EnumType implements IStringSerializable
    {
        HEAD("head"),
        FOOT("foot");

        private final String name;

        private EnumType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }
    }
}

