/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.core.block;

import com.codetaylor.mc.athenaeum.util.BlockHelper;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCoreConfig;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockRockNetherrack
extends Block {
    public static final String NAME = "rock_netherrack";
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);

    public BlockRockNetherrack() {
        super(Material.field_151576_e);
        this.func_149711_c(0.1f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149675_a(true);
    }

    public int func_149738_a(World world) {
        return 40;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        IBlockState bs2 = world.func_180495_p(pos.func_177977_b());
        Material material = bs2.func_185904_a();
        if ((material == Material.field_151576_e || material == Material.field_151578_c || material == Material.field_151577_b) && bs2.func_185913_b()) {
            world.func_180501_a(pos.func_177977_b(), Blocks.field_150424_aL.func_176223_P(), 3);
        }
        int range = Math.max(0, Math.min(16, ModuleCoreConfig.ROCKS.NETHERRACK_SPREAD_RADIUS));
        BlockHelper.forBlocksInRangeShuffled((World)world, (BlockPos)pos, (int)range, (w, p, bs) -> {
            Material material = bs.func_185904_a();
            if (material == Material.field_151576_e || material == Material.field_151578_c || material == Material.field_151577_b) {
                boolean isNetherrackAdjacent = false;
                if (bs.func_185913_b()) {
                    for (EnumFacing facing : EnumFacing.values()) {
                        if (w.func_180495_p(p.func_177972_a(facing)).func_177230_c() != Blocks.field_150424_aL) continue;
                        isNetherrackAdjacent = true;
                        break;
                    }
                    if (isNetherrackAdjacent) {
                        w.func_180501_a(p, Blocks.field_150424_aL.func_176223_P(), 3);
                        return false;
                    }
                }
            }
            return true;
        });
    }

    public boolean func_176196_c(World world, @Nonnull BlockPos pos) {
        return world.isSideSolid(pos.func_177977_b(), EnumFacing.UP) && super.func_176196_c(world, pos);
    }

    public boolean func_176200_f(IBlockAccess world, @Nonnull BlockPos pos) {
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.func_176196_c(world, pos)) {
            world.func_175655_b(pos, true);
        }
    }

    public boolean isSideSolid(IBlockState base_state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return this.func_149730_j(state);
    }

    public boolean func_149662_c(IBlockState state) {
        return this.func_149730_j(state);
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_149730_j(state);
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return field_185506_k;
    }
}

