/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.core.block;

import com.codetaylor.mc.athenaeum.spi.IBlockVariant;
import com.codetaylor.mc.athenaeum.spi.IVariant;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCoreConfig;
import java.util.Comparator;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockRock
extends Block
implements IBlockVariant<EnumType> {
    public static final String NAME = "rock";
    public static final IProperty<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);

    public BlockRock() {
        super(Material.field_151578_c);
        this.func_149711_c(0.1f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    @Nonnull
    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        EnumType type = (EnumType)((Object)state.func_177229_b(VARIANT));
        if (type == EnumType.SAND || type == EnumType.SAND_RED) {
            return SoundType.field_185855_h;
        }
        if (type == EnumType.DIRT || type == EnumType.WOOD_CHIPS) {
            return SoundType.field_185849_b;
        }
        return SoundType.field_185851_d;
    }

    public boolean canHarvestBlock(IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        IBlockState state;
        if (ModuleCoreConfig.TWEAKS.REQUIRE_SHOVEL_TO_PICKUP_WOOD_CHIPS && (state = world.func_180495_p(pos)).func_177230_c() instanceof BlockRock && state.func_177229_b(VARIANT) == EnumType.WOOD_CHIPS) {
            ItemStack itemMainhand = player.func_184614_ca();
            Item item = itemMainhand.func_77973_b();
            return item.getToolClasses(itemMainhand).contains("shovel");
        }
        return super.canHarvestBlock(world, pos, player);
    }

    @Nullable
    public String getHarvestTool(@Nonnull IBlockState state) {
        if (ModuleCoreConfig.TWEAKS.REQUIRE_SHOVEL_TO_PICKUP_WOOD_CHIPS && state.func_177230_c() instanceof BlockRock && state.func_177229_b(VARIANT) == EnumType.WOOD_CHIPS) {
            return "shovel";
        }
        return super.getHarvestTool(state);
    }

    public int getHarvestLevel(IBlockState state) {
        if (ModuleCoreConfig.TWEAKS.REQUIRE_SHOVEL_TO_PICKUP_WOOD_CHIPS && state.func_177230_c() instanceof BlockRock && state.func_177229_b(VARIANT) == EnumType.WOOD_CHIPS) {
            return 0;
        }
        return super.getHarvestLevel(state);
    }

    public boolean func_176196_c(World world, @Nonnull BlockPos pos) {
        return world.isSideSolid(pos.func_177977_b(), EnumFacing.UP) && super.func_176196_c(world, pos);
    }

    public boolean func_176200_f(IBlockAccess world, @Nonnull BlockPos pos) {
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.func_176196_c(world, pos)) {
            world.func_175655_b(pos, true);
        }
    }

    public boolean isSideSolid(IBlockState base_state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return this.func_149730_j(state);
    }

    public boolean func_149662_c(IBlockState state) {
        return this.func_149730_j(state);
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_149730_j(state);
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> list) {
        for (EnumType type : EnumType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, type.getMeta()));
        }
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.fromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMeta();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Nonnull
    public String getModelName(ItemStack itemStack) {
        return EnumType.fromMeta(itemStack.func_77960_j()).func_176610_l();
    }

    @Nonnull
    public IProperty<EnumType> getVariant() {
        return VARIANT;
    }

    public static enum EnumType implements IVariant
    {
        STONE(0, "rock_stone"),
        GRANITE(1, "rock_granite"),
        DIORITE(2, "rock_diorite"),
        ANDESITE(3, "rock_andesite"),
        DIRT(4, "rock_dirt"),
        SAND(5, "rock_sand"),
        SANDSTONE(6, "rock_sandstone"),
        WOOD_CHIPS(7, "rock_wood_chips"),
        LIMESTONE(8, "rock_limestone"),
        SAND_RED(9, "rock_sand_red"),
        SANDSTONE_RED(10, "rock_sandstone_red");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public ItemStack asStack() {
            return this.asStack(1);
        }

        public ItemStack asStack(int amount) {
            return new ItemStack((Block)ModuleCore.Blocks.ROCK, amount, this.meta);
        }

        public static EnumType fromMeta(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = (EnumType[])Stream.of(EnumType.values()).sorted(Comparator.comparing(EnumType::getMeta)).toArray(EnumType[]::new);
        }
    }
}

