/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.bucket.item;

import com.codetaylor.mc.athenaeum.spi.IVariant;
import com.codetaylor.mc.athenaeum.util.FluidHelper;
import com.codetaylor.mc.athenaeum.util.FluidUtilFix;
import com.codetaylor.mc.athenaeum.util.SoundHelper;
import com.codetaylor.mc.pyrotech.ModPyrotech;
import com.codetaylor.mc.pyrotech.library.util.Util;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class ItemBucketBase
extends UniversalBucket {
    public ItemBucketBase() {
        this.func_77627_a(true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @ParametersAreNonnullByDefault
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.func_77973_b() != newStack.func_77973_b()) {
            return true;
        }
        if (oldStack.func_77960_j() != newStack.func_77960_j()) {
            return true;
        }
        FluidStack oldFluidStack = this.getFluid(oldStack);
        FluidStack newFluidStack = this.getFluid(newStack);
        if (oldFluidStack == null && newFluidStack == null) {
            return slotChanged;
        }
        if (oldFluidStack == null) {
            return true;
        }
        if (newFluidStack == null) {
            return true;
        }
        return slotChanged || oldFluidStack.getFluid() != newFluidStack.getFluid();
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.hasFluid(stack) || stack.func_77960_j() == EnumType.MILK.getMeta() ? 1 : this.getBucketStackLimit();
    }

    protected abstract int getBucketStackLimit();

    public int getItemBurnTime(ItemStack stack) {
        FluidStack fluid = this.getFluid(stack);
        if (fluid != null && fluid.getFluid() == FluidRegistry.LAVA) {
            return 20000;
        }
        return 0;
    }

    @Nonnull
    public ItemStack getEmpty() {
        return new ItemStack((Item)this, 1, EnumType.EMPTY.getMeta());
    }

    @Nullable
    public Item func_77668_q() {
        return super.func_77668_q();
    }

    public boolean hasContainerItem(@Nonnull ItemStack stack) {
        return super.hasContainerItem(stack);
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack itemStack) {
        if (!this.getEmpty().func_190926_b()) {
            ItemStack copy = this.getEmpty().func_77946_l();
            this.setDurability(copy, this.getDurability(itemStack));
            return copy;
        }
        return super.getContainerItem(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        if (this.getDurability(stack) == this.getMaxDurability()) {
            tooltip.add(I18n.func_74837_a((String)"gui.pyrotech.tooltip.uses.full", (Object[])new Object[]{this.getDurability(stack)}));
        } else {
            tooltip.add(I18n.func_74837_a((String)"gui.pyrotech.tooltip.uses", (Object[])new Object[]{this.getDurability(stack), this.getMaxDurability()}));
        }
        if (this.getHotContainerDamagePerSecond() <= 0) {
            tooltip.add(TextFormatting.GREEN + I18n.func_74837_a((String)"gui.pyrotech.tooltip.hot.fluids.true", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.RED + I18n.func_74837_a((String)"gui.pyrotech.tooltip.hot.fluids.false", (Object[])new Object[0]));
        }
    }

    public void func_150895_a(@Nullable CreativeTabs tab, @Nonnull NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        subItems.add((Object)new ItemStack((Item)this));
        if (!this.showAllBuckets()) {
            return;
        }
        subItems.add((Object)new ItemStack((Item)this, 1, EnumType.MILK.getMeta()));
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            FluidStack fluidStack;
            ItemStack stack;
            BucketWrapper fluidHandler;
            if (fluid.getName().equals("milk") || (fluidHandler = new BucketWrapper(stack = new ItemStack((Item)this))).fill(fluidStack = new FluidStack(fluid, this.getCapacity()), false) != fluidStack.amount) continue;
            subItems.add((Object)this.createWithFluid(fluidStack));
        }
    }

    protected abstract boolean showAllBuckets();

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        if (stack.func_77960_j() != EnumType.EMPTY.getMeta()) {
            String fluidName = EnumType.fromMeta(stack.func_77960_j()).func_176610_l();
            return I18n.func_74838_a((String)("item." + Util.prefix(this.getLangKey() + "." + fluidName) + ".name"));
        }
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack == null) {
            return I18n.func_74838_a((String)("item." + Util.prefix(this.getLangKey() + ".empty") + ".name"));
        }
        String unlocalizedName = this.func_77657_g(stack);
        String name = fluidStack.getFluid().getName();
        if (I18n.func_94522_b((String)(unlocalizedName + "." + name))) {
            return I18n.func_74838_a((String)(unlocalizedName + "." + name));
        }
        return I18n.func_74837_a((String)(unlocalizedName + ".name"), (Object[])new Object[]{fluidStack.getLocalizedName()});
    }

    protected abstract String getLangKey();

    @ParametersAreNonnullByDefault
    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77960_j() == EnumType.MILK.getMeta()) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        RayTraceResult target = this.func_77621_a(world, player, !this.hasFluid(stack));
        ActionResult ret = ForgeEventFactory.onBucketUse((EntityPlayer)player, (World)world, (ItemStack)stack, (RayTraceResult)target);
        if (ret != null && ret.func_188397_a() == EnumActionResult.SUCCESS) {
            return ret;
        }
        if (target == null || target.field_72313_a != RayTraceResult.Type.BLOCK) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        BlockPos targetBlockPos = target.func_178782_a();
        ItemStack cauldronResult = this.interactWithCauldron(world, player, targetBlockPos, world.func_180495_p(targetBlockPos), stack);
        if (cauldronResult != null) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)cauldronResult);
        }
        ItemStack result = this.placeFluidFromContainer(world, player, targetBlockPos, target.field_178784_b, stack);
        if (result.func_190926_b()) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)result);
    }

    @Nullable
    private ItemStack interactWithCauldron(World world, EntityPlayer player, BlockPos pos, IBlockState blockState, ItemStack containerStack) {
        if (!(blockState.func_177230_c() instanceof BlockCauldron)) {
            return null;
        }
        int level = (Integer)blockState.func_177229_b((IProperty)BlockCauldron.field_176591_a);
        FluidStack fluidStack = this.getFluid(containerStack);
        int durability = this.getDurability(containerStack);
        if (fluidStack != null && fluidStack.getFluid() == FluidRegistry.WATER) {
            if (level < 3) {
                if (!world.field_72995_K) {
                    player.func_71029_a(StatList.field_188077_K);
                    Blocks.field_150383_bp.func_176590_a(world, pos, blockState, 3);
                    FluidHelper.playFluidEmptySoundServer((Fluid)FluidRegistry.WATER, (World)world, (BlockPos)pos);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    containerStack.func_190918_g(1);
                    ItemStack emptyStack = new ItemStack((Item)this, 1, EnumType.EMPTY.getMeta());
                    this.setDurability(emptyStack, durability - 1);
                    if (this.isBroken(emptyStack)) {
                        emptyStack = this.getBrokenItemStack();
                        SoundHelper.playSoundServer((World)world, (BlockPos)pos, (SoundEvent)SoundEvents.field_187635_cQ, (SoundCategory)SoundCategory.PLAYERS);
                    }
                    if (containerStack.func_190926_b()) {
                        return emptyStack;
                    }
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)emptyStack);
                    return containerStack;
                }
                return containerStack;
            }
        } else if (fluidStack == null) {
            if (level == 3) {
                if (!world.field_72995_K) {
                    player.func_71029_a(StatList.field_188078_L);
                    Blocks.field_150383_bp.func_176590_a(world, pos, blockState, 0);
                    FluidHelper.playFluidFillSoundServer((Fluid)FluidRegistry.WATER, (World)world, (BlockPos)pos);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    containerStack.func_190918_g(1);
                    FluidStack water = new FluidStack(FluidRegistry.WATER, 1000);
                    ItemStack filledBucket = this.createWithFluid(water);
                    this.setDurability(filledBucket, durability);
                    if (containerStack.func_190926_b()) {
                        return filledBucket;
                    }
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)filledBucket);
                    return containerStack;
                }
            }
            return containerStack;
        }
        return null;
    }

    @Nullable
    private FluidActionResult tryPlaceFluid(World world, EntityPlayer player, BlockPos pos, ItemStack containerStack, FluidStack fluidStack) {
        if (!world.field_72995_K && world.func_175660_a(player, pos)) {
            return FluidUtil.tryPlaceFluid((EntityPlayer)player, (World)world, (BlockPos)pos, (ItemStack)containerStack, (FluidStack)fluidStack);
        }
        return null;
    }

    private ItemStack placeFluidFromContainer(World world, EntityPlayer player, BlockPos pos, EnumFacing sideHit, ItemStack containerStack) {
        FluidStack fluidStack;
        FluidActionResult result;
        if (!world.func_175660_a(player, pos)) {
            return ItemStack.field_190927_a;
        }
        BlockPos targetPos = pos.func_177972_a(sideHit);
        if (player.func_175151_a(targetPos, sideHit, containerStack) && (result = FluidUtilFix.tryPlaceFluid((EntityPlayer)player, (World)world, (BlockPos)targetPos, (ItemStack)containerStack, (FluidStack)(fluidStack = this.getFluid(containerStack)))).isSuccess() && !player.field_71075_bZ.field_75098_d) {
            player.func_71029_a(StatList.func_188057_b((Item)this));
            int durability = this.getDurability(containerStack);
            containerStack.func_190918_g(1);
            ItemStack drained = result.getResult();
            ItemStack emptyStack = !drained.func_190926_b() ? drained.func_77946_l() : new ItemStack((Item)this);
            this.setDurability(emptyStack, durability - 1);
            if (this.isBroken(emptyStack)) {
                emptyStack = this.getBrokenItemStack();
                SoundHelper.playSoundServer((World)world, (BlockPos)pos, (SoundEvent)SoundEvents.field_187635_cQ, (SoundCategory)SoundCategory.PLAYERS);
            }
            if (containerStack.func_190926_b()) {
                return emptyStack;
            }
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)emptyStack);
            return containerStack;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        return stack.func_77960_j() == EnumType.MILK.getMeta() ? EnumAction.DRINK : EnumAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        return stack.func_77960_j() == EnumType.MILK.getMeta() ? 32 : 0;
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (stack.func_77960_j() != EnumType.MILK.getMeta()) {
            return stack;
        }
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)entityLiving;
            int durability = this.getDurability(stack);
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                stack = new ItemStack((Item)this);
                this.setDurability(stack, durability - 1);
                if (this.isBroken(stack)) {
                    stack = this.getBrokenItemStack();
                    SoundHelper.playSoundServer((World)world, (BlockPos)entityLiving.func_180425_c(), (SoundEvent)SoundEvents.field_187635_cQ, (SoundCategory)SoundCategory.PLAYERS);
                }
            }
            entityPlayer.func_71029_a(StatList.func_188057_b((Item)this));
        }
        if (!world.field_72995_K) {
            entityLiving.curePotionEffects(new ItemStack(Items.field_151117_aB));
        }
        return stack;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (this.isCowMilkDisabled()) {
            return false;
        }
        if (this.hasFluid(stack) || player.field_71075_bZ.field_75098_d) {
            return false;
        }
        if (target instanceof EntityCow) {
            int durability = this.getDurability(stack);
            player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
            if (stack.func_190916_E() == 1) {
                stack.func_77964_b(EnumType.MILK.getMeta());
                this.setDurability(stack, durability);
            } else {
                stack.func_190918_g(1);
                ItemStack result = EnumType.MILK.asStack(this);
                this.setDurability(result, durability);
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)result, (int)player.field_71071_by.field_70461_c);
            }
            return true;
        }
        return false;
    }

    protected abstract boolean isCowMilkDisabled();

    protected abstract int getMaxDurability();

    protected abstract int getHotTemperature();

    protected abstract int getHotContainerDamagePerSecond();

    protected abstract int getHotPlayerDamagePerSecond();

    protected abstract int getFullContainerDamagePerSecond();

    public boolean isBroken(ItemStack itemStack) {
        return this.getDurability(itemStack) <= 0;
    }

    protected ItemStack getBrokenItemStack() {
        return ItemStack.field_190927_a;
    }

    public void setDurability(ItemStack itemStack, int durability) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        tag.func_74768_a("durability", durability);
        itemStack.func_77982_d(tag);
    }

    public int getDurability(ItemStack itemStack) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null) {
            return this.getMaxDurability();
        }
        if (tag.func_74764_b("durability")) {
            return tag.func_74762_e("durability");
        }
        return this.getMaxDurability();
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getDurability(stack) < this.getMaxDurability();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getDurability(stack) / (double)this.getMaxDurability();
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.field_72995_K) {
            return;
        }
        if (world.func_82737_E() % 20L != 0L) {
            return;
        }
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack == null) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        int containerDamagePerSecond = this.getFullContainerDamagePerSecond();
        if (fluid.getTemperature(fluidStack) >= this.getHotTemperature()) {
            int playerDamagePerSecond = this.getHotPlayerDamagePerSecond();
            if (playerDamagePerSecond > 0) {
                entity.func_70097_a(DamageSource.field_76372_a, (float)playerDamagePerSecond);
                entity.func_70015_d(1);
            }
            containerDamagePerSecond += this.getHotContainerDamagePerSecond();
        }
        if (containerDamagePerSecond == 0) {
            return;
        }
        int durability = this.getDurability(stack);
        if ((durability -= containerDamagePerSecond) <= 0) {
            entity.func_174820_d(itemSlot, this.getBrokenItemStack());
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                BlockPos pos = player.func_180425_c();
                FluidActionResult fluidActionResult = this.tryPlaceFluid(player.func_130014_f_(), player, pos, stack, fluidStack);
                if (this.dropFluidSourceOnBreak() && fluidActionResult != null && fluidActionResult.isSuccess()) {
                    IBlockState blockState = world.func_180495_p(pos);
                    Block block = blockState.func_177230_c();
                    IBlockState defaultState = block.func_176223_P();
                    if (block instanceof IFluidBlock || block instanceof BlockLiquid) {
                        world.func_180501_a(pos, defaultState.func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(5)), 11);
                    }
                }
            }
            SoundHelper.playSoundServer((World)world, (BlockPos)entity.func_180425_c(), (SoundEvent)SoundEvents.field_187635_cQ, (SoundCategory)SoundCategory.PLAYERS);
        } else {
            this.setDurability(stack, durability);
        }
    }

    protected abstract boolean dropFluidSourceOnBreak();

    private ItemStack createWithFluid(FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return new ItemStack((Item)this, 0, EnumType.EMPTY.getMeta());
        }
        if ("milk".equals(fluid.getName())) {
            return new ItemStack((Item)this, 1, EnumType.MILK.getMeta());
        }
        ItemStack stack = new ItemStack((Item)this, 1, 0);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("fluids", (NBTBase)new FluidStack(fluidStack, 1000).writeToNBT(new NBTTagCompound()));
        stack.func_77982_d(tag);
        return stack;
    }

    @Nullable
    public FluidStack getFluid(@Nonnull ItemStack container) {
        if (container.func_77960_j() == EnumType.MILK.getMeta()) {
            return FluidRegistry.getFluidStack((String)"milk", (int)1000);
        }
        NBTTagCompound tags = container.func_77978_p();
        if (tags != null) {
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)tags.func_74775_l("fluids"));
        }
        return null;
    }

    public boolean hasFluid(ItemStack container) {
        return this.getFluid(container) != null;
    }

    public void onFillBucket(FillBucketEvent event) {
        EntityPlayer entityPlayer;
        FluidActionResult filledResult;
        IFluidTankProperties[] tankProperties;
        if (event.getResult() != Event.Result.DEFAULT) {
            return;
        }
        ItemStack emptyBucket = event.getEmptyBucket();
        if (emptyBucket.func_190926_b() || !emptyBucket.func_77969_a(this.getEmpty()) || this.isNbtSensitive() && ItemStack.func_77970_a((ItemStack)emptyBucket, (ItemStack)this.getEmpty())) {
            return;
        }
        RayTraceResult target = event.getTarget();
        if (target == null || target.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = target.func_178782_a();
        ItemStack singleBucket = emptyBucket.func_77946_l();
        singleBucket.func_190920_e(1);
        IFluidHandler fluidHandler = FluidUtil.getFluidHandler((World)world, (BlockPos)pos, (EnumFacing)target.field_178784_b);
        FluidStack fluidStack = null;
        if (fluidHandler != null && (tankProperties = fluidHandler.getTankProperties()) != null && tankProperties.length > 0) {
            fluidStack = tankProperties[0].getContents();
        }
        if ((filledResult = FluidUtil.tryPickUpFluid((ItemStack)singleBucket, (EntityPlayer)(entityPlayer = event.getEntityPlayer()), (World)world, (BlockPos)pos, (EnumFacing)target.field_178784_b)).isSuccess()) {
            ItemStack result = filledResult.getResult();
            if (result.func_190926_b() || this.isBroken(result)) {
                if (fluidStack != null) {
                    this.tryPlaceFluid(world, entityPlayer, entityPlayer.func_180425_c(), this.createWithFluid(fluidStack), fluidStack);
                }
                result = this.getBrokenItemStack();
                SoundHelper.playSoundServer((World)world, (BlockPos)pos, (SoundEvent)SoundEvents.field_187635_cQ, (SoundCategory)SoundCategory.PLAYERS);
            }
            event.setResult(Event.Result.ALLOW);
            event.setFilledBucket(result);
        } else {
            event.setCanceled(true);
        }
    }

    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, NBTTagCompound nbt) {
        return new BucketWrapper(stack);
    }

    public static enum EnumType implements IVariant
    {
        EMPTY(0, "empty"),
        MILK(1, "milk");

        private static final EnumType[] META_LOOKUP;
        private final String name;
        private final int meta;

        private EnumType(int meta, String name) {
            this.name = name;
            this.meta = meta;
        }

        public int getMeta() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name;
        }

        public ItemStack asStack(ItemBucketBase item) {
            return this.asStack(item, 1);
        }

        public ItemStack asStack(ItemBucketBase item, int amount) {
            return new ItemStack((Item)item, amount, this.meta);
        }

        public static EnumType fromMeta(int meta) {
            if (meta < 0 || meta > META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = (EnumType[])Stream.of(EnumType.values()).sorted(Comparator.comparing(EnumType::getMeta)).toArray(EnumType[]::new);
        }
    }

    private class BucketWrapper
    extends FluidBucketWrapper {
        BucketWrapper(ItemStack container) {
            super(container);
        }

        @Nullable
        public FluidStack getFluid() {
            return ItemBucketBase.this.getFluid(this.container);
        }

        protected void setFluid(@Nullable FluidStack fluidStack) {
            int durability = ItemBucketBase.this.getDurability(this.container);
            if (fluidStack == null) {
                this.container = new ItemStack((Item)ItemBucketBase.this, 1, 0);
                --durability;
            } else {
                this.container = ItemBucketBase.this.createWithFluid(fluidStack);
            }
            ItemBucketBase.this.setDurability(this.container, durability);
            if (ItemBucketBase.this.isBroken(this.container)) {
                this.container = ItemStack.field_190927_a;
                ModPyrotech.PROXY.playSound(SoundEvents.field_187635_cQ, SoundCategory.PLAYERS);
            }
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (this.container.func_190916_E() != 1 || resource == null || resource.amount < 1000 || this.getFluid() != null || !this.canFillFluidType(resource)) {
                return 0;
            }
            if (doFill) {
                this.setFluid(resource);
            }
            return 1000;
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return super.canFillFluidType(fluid);
        }
    }
}

