/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.library.util;

import java.util.ArrayDeque;
import java.util.HashSet;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FloodFill {
    public static boolean apply(World world, BlockPos pos, ICandidatePredicate candidatePredicate, IAction action, int limit) {
        BlockPos candidatePos;
        ArrayDeque<BlockPos> candidateQueue = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> visitedSet = new HashSet<BlockPos>();
        boolean result = false;
        candidateQueue.offer(pos);
        while (limit > 0 && (candidatePos = (BlockPos)candidateQueue.poll()) != null) {
            visitedSet.add(candidatePos);
            if (!candidatePredicate.apply(world, candidatePos)) continue;
            result = true;
            if (!action.execute(world, candidatePos)) break;
            --limit;
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                BlockPos offset = candidatePos.func_177972_a(facing);
                if (visitedSet.contains(offset)) continue;
                candidateQueue.offer(offset);
            }
        }
        return result;
    }

    private FloodFill() {
    }

    public static interface IAction {
        public boolean execute(World var1, BlockPos var2);
    }

    public static interface ICandidatePredicate {
        public boolean apply(World var1, BlockPos var2);
    }
}

