/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.library.patreon.data;

import com.codetaylor.mc.pyrotech.library.patreon.data.EffectDataList;
import com.codetaylor.mc.pyrotech.library.patreon.data.IEffectDataJsonAdapter;
import com.google.gson.Gson;
import java.io.Reader;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GsonEffectDataJsonAdapter
implements IEffectDataJsonAdapter {
    private static final Logger LOGGER = LogManager.getLogger(GsonEffectDataJsonAdapter.class);
    private final Gson gson;

    public GsonEffectDataJsonAdapter(Gson gson) {
        this.gson = gson;
    }

    @Override
    public Optional<EffectDataList> adaptJson(Reader in) {
        try {
            EffectDataList effectDataList = (EffectDataList)this.gson.fromJson(in, EffectDataList.class);
            return Optional.of(effectDataList);
        }
        catch (Exception e) {
            LOGGER.error("Error reading Patreon effect json", (Throwable)e);
            return Optional.empty();
        }
    }
}

