/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.library.patreon.data;

import com.codetaylor.mc.pyrotech.library.patreon.data.EffectDataBase;
import com.codetaylor.mc.pyrotech.library.patreon.data.GsonHelper;
import com.codetaylor.mc.pyrotech.library.patreon.data.IEffectDataFactory;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;

public class EffectDataGsonAdapter
extends TypeAdapter<EffectDataBase> {
    private final Map<String, IEffectDataFactory> effectDataFactoryMap;

    public EffectDataGsonAdapter(Map<String, IEffectDataFactory> effectDataFactoryMap) {
        this.effectDataFactoryMap = effectDataFactoryMap;
    }

    public void write(JsonWriter out, EffectDataBase value) throws IOException {
        throw new UnsupportedOperationException("Effect data is read only.");
    }

    public EffectDataBase read(JsonReader in) throws IOException {
        in.beginObject();
        GsonHelper.assertNextName(in, "uuid");
        String uuidString = in.nextString();
        UUID uuid = UUID.fromString(uuidString);
        GsonHelper.assertNextName(in, "effect");
        String effectID = in.nextString();
        IEffectDataFactory effectDataFactory = this.effectDataFactoryMap.get(effectID);
        if (effectDataFactory == null) {
            throw new IOException("No IEffectDataFactory registered for effect");
        }
        GsonHelper.assertNextName(in, "params");
        in.beginObject();
        Object effectData = effectDataFactory.createEffectData(uuid);
        ((EffectDataBase)effectData).read(in);
        in.endObject();
        in.endObject();
        return effectData;
    }
}

