/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.library;

import com.codetaylor.mc.athenaeum.util.FileHelper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Logger;

public class JsonInitializer {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static <T> T generateAndReadCustom(Path configurationPath, String generatedFilename, String customFilename, Class<T> dataClass, Supplier<? extends T> generatedDataClassSupplier, Logger logger) {
        if (!JsonInitializer.create(configurationPath, generatedFilename, customFilename, generatedDataClassSupplier, logger)) {
            return null;
        }
        return JsonInitializer.read(configurationPath, customFilename, dataClass, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <T> T read(Path configurationPath, String customFilename, Class<T> dataClass, @Nullable Logger logger) {
        Path customPath = Paths.get(configurationPath.toString(), customFilename);
        BufferedReader reader = null;
        try {
            reader = Files.newBufferedReader(customPath);
            Object object = GSON.fromJson((Reader)reader, dataClass);
            return (T)object;
        }
        catch (IOException e) {
            if (logger != null) {
                logger.error("", (Throwable)e);
            }
        }
        finally {
            FileHelper.closeSilently((Closeable)reader);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> boolean create(Path configurationPath, String generatedFilename, String customFilename, Supplier<? extends T> generatedDataClassSupplier, Logger logger) {
        Path generatedPath = Paths.get(configurationPath.toString(), generatedFilename);
        Path customPath = Paths.get(configurationPath.toString(), customFilename);
        if (!Files.exists(configurationPath, new LinkOption[0])) {
            try {
                Files.createDirectories(configurationPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
                return false;
            }
        }
        if (Files.exists(generatedPath, new LinkOption[0])) {
            try {
                Files.delete(generatedPath);
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
                return false;
            }
        }
        BufferedWriter writer = null;
        try {
            writer = Files.newBufferedWriter(generatedPath, new OpenOption[0]);
            GSON.toJson(generatedDataClassSupplier.get(), (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            boolean bl;
            try {
                logger.error("", (Throwable)e);
                bl = false;
            }
            catch (Throwable throwable) {
                FileHelper.closeSilently(writer);
                throw throwable;
            }
            FileHelper.closeSilently((Closeable)writer);
            return bl;
        }
        FileHelper.closeSilently((Closeable)writer);
        if (!Files.exists(customPath, new LinkOption[0])) {
            try {
                Files.copy(generatedPath, customPath, new CopyOption[0]);
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private JsonInitializer() {
    }
}

