/*
 * Decompiled with CFR 0.152.
 */
package advancedmotd.utils;

import advancedmotd.AdvancedMotd;
import advancedmotd.config.ConfigGeneral;
import advancedmotd.config.ConfigLang;
import advancedmotd.utils.MessageHelper;
import java.io.File;
import lumien.bloodmoon.server.BloodmoonHandler;
import net.minecraft.server.dedicated.PropertyManager;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;

public class Utils {
    public static String colorPrefix = "\u00a7";
    public static String resetColor = "\u00a7r";

    public static String[] removeElement(String[] original, int element) {
        String[] n = new String[original.length - 1];
        System.arraycopy(original, 0, n, 0, element);
        System.arraycopy(original, element + 1, n, element, original.length - element - 1);
        return n;
    }

    public static WorldServer getWorldServerFromID(int id) {
        WorldServer server = null;
        try {
            server = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(id);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return server;
    }

    public static boolean setMotd(String motd) {
        File sFile = new File("server.properties");
        if (!sFile.exists()) {
            return false;
        }
        PropertyManager settings = new PropertyManager(sFile);
        String formatMotd = MessageHelper.getFormattedText(motd);
        settings.func_73667_a("motd", (Object)formatMotd);
        AdvancedMotd.motdHandler.updateMotd(formatMotd);
        settings.func_73668_b();
        return true;
    }

    public static String getMotd() {
        File sFile = new File("server.properties");
        if (!sFile.exists()) {
            return "";
        }
        PropertyManager settings = new PropertyManager(sFile);
        return settings.func_73671_a("motd", "A Minecraft Server");
    }

    public static void reloadMotd() {
        File sFile = new File("server.properties");
        if (!sFile.exists()) {
            return;
        }
        PropertyManager settings = new PropertyManager(sFile);
        AdvancedMotd.motdHandler.updateMotd(settings.func_73671_a("motd", "A Minecraft Server"));
    }

    public static String formatSeason(WorldServer server) {
        String seasonName = "";
        String seasonColor = "";
        if (ConfigGeneral.considerSeasons.getBoolean() && Loader.isModLoaded((String)"sereneseasons")) {
            ISeasonState iss = SeasonHelper.getSeasonState((World)server);
            Season season = iss.getSeason();
            if (season == Season.SPRING) {
                seasonName = ConfigLang.msgSeasonSpring;
                seasonColor = ConfigGeneral.seasonSpring.getString();
            } else if (season == Season.SUMMER) {
                seasonName = ConfigLang.msgSeasonSummer;
                seasonColor = ConfigGeneral.seasonSummer.getString();
            } else if (season == Season.AUTUMN) {
                seasonName = ConfigLang.msgSeasonAutumn;
                seasonColor = ConfigGeneral.seasonAutumn.getString();
            } else if (season == Season.WINTER) {
                seasonName = ConfigLang.msgSeasonWinter;
                seasonColor = ConfigGeneral.seasonWinter.getString();
            }
        }
        return Utils.parseColor(seasonColor) + seasonName + resetColor;
    }

    public static String parseColor(String colorIn) {
        String colorOut = "";
        for (int i = 0; i < colorIn.length(); ++i) {
            colorOut = colorOut + colorPrefix + colorIn.charAt(i);
        }
        return colorOut;
    }

    /*
     * Unable to fully structure code
     */
    public static String formatDayTime(boolean dayTime, long ticks) {
        block7: {
            block6: {
                dayticks = ticks % 24000L;
                hours = (int)(dayticks / 1000L) + 6;
                if (hours >= 24) {
                    hours -= 24;
                }
                minutes = (int)(dayticks % 1000L * 3L / 50L);
                day = (int)(ticks / 24000L);
                week = day / ConfigGeneral.weeklength.getInt() + 1;
                dayofweek = day % ConfigGeneral.weeklength.getInt() + 1;
                formatted = ConfigGeneral.dateformat.getString().replace("%d", String.format("%d", new Object[]{++day})).replace("%w", String.format("%d", new Object[]{week})).replace("%h", String.format("%02d", new Object[]{hours})).replace("%m", String.format("%02d", new Object[]{minutes})).replace("%o", String.format("%d", new Object[]{dayofweek}));
                colour = "";
                form = "";
                if (ConfigGeneral.colorizeDayN.getInt() == 0) break block6;
                if (day % ConfigGeneral.colorizeDayN.getInt() != 0) break block6;
                if (dayticks <= (long)ConfigGeneral.dangerStart.getInt()) ** GOTO lbl-1000
                if (dayticks < (long)ConfigGeneral.dangerEnd.getInt()) {
                    form = ConfigGeneral.dangerColorAtDayN.getString();
                } else lbl-1000:
                // 2 sources

                {
                    form = ConfigGeneral.safetyColorAtDayN.getString();
                }
                break block7;
            }
            if (dayticks <= (long)ConfigGeneral.dangerStart.getInt()) ** GOTO lbl-1000
            if (dayticks < (long)ConfigGeneral.dangerEnd.getInt()) {
                form = ConfigGeneral.dangerColor.getString();
            } else lbl-1000:
            // 2 sources

            {
                form = ConfigGeneral.safetyColor.getString();
            }
        }
        if (ConfigGeneral.considerBloodmoon.getBoolean() && Loader.isModLoaded((String)"bloodmoon") && BloodmoonHandler.INSTANCE.isBloodmoonActive()) {
            form = ConfigGeneral.dangerColor.getString();
        }
        return Utils.parseColor(form) + formatted + Utils.resetColor;
    }

    public static String[] shiftArgs(String[] s) {
        if (s == null || s.length == 0) {
            return new String[0];
        }
        String[] s1 = new String[s.length - 1];
        System.arraycopy(s, 1, s1, 0, s1.length);
        return s1;
    }

    public static String[] shiftArgs(String[] s, int width) {
        if (s == null || s.length == 0) {
            return new String[0];
        }
        if (width <= 0) {
            width = 1;
        }
        String[] s1 = new String[s.length - width];
        System.arraycopy(s, width, s1, 0, s1.length);
        return s1;
    }
}

