/*
 * Decompiled with CFR 0.152.
 */
package advancedmotd.handler;

import advancedmotd.AdvancedMotd;
import advancedmotd.config.ConfigGeneral;
import advancedmotd.config.ConfigLang;
import advancedmotd.utils.Utils;
import net.minecraft.network.ServerStatusResponse;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class MotdHandler {
    private String baseMOTD = "";
    private WorldServer server;

    public MotdHandler() {
        this.updateMotd(Utils.getMotd());
    }

    public void updateMotd(String motd) {
        this.baseMOTD = motd;
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (this.server == null) {
            this.server = Utils.getWorldServerFromID(ConfigGeneral.dimID.getInt());
            if (this.server == null) {
                Object[] objectArray = new Object[1];
                objectArray[0] = ConfigGeneral.dimID.getInt();
                AdvancedMotd.getLogger().info(String.format(ConfigLang.infoNoDimension, objectArray));
                return;
            }
        }
        long ticks = this.server.func_72820_D();
        ServerStatusResponse response = FMLCommonHandler.instance().getMinecraftServerInstance().func_147134_at();
        String season = Utils.formatSeason(this.server);
        String dayTime = Utils.formatDayTime(this.server.func_72935_r(), ticks);
        String wholeMotd = ConfigGeneral.motdFormat.getString();
        wholeMotd = wholeMotd.replaceFirst("%motd%", this.baseMOTD + Utils.resetColor);
        wholeMotd = wholeMotd.replaceFirst("%daytime%", dayTime);
        wholeMotd = wholeMotd.replaceFirst("%season%", season);
        response.func_151315_a((ITextComponent)new TextComponentString(wholeMotd));
    }
}

