/*
 * Decompiled with CFR 0.152.
 */
package advancedmotd.config;

import advancedmotd.AdvancedMotd;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigGeneral {
    public static Property dateformat;
    public static Property motdFormat;
    public static Property weeklength;
    public static Property colorizeDayN;
    public static Property colorAtDayN;
    public static Property dangerStart;
    public static Property dangerEnd;
    public static Property dangerColor;
    public static Property safetyColor;
    public static Property dangerColorAtDayN;
    public static Property safetyColorAtDayN;
    public static Property considerBloodmoon;
    public static Property considerSeasons;
    public static Property seasonSpring;
    public static Property seasonSummer;
    public static Property seasonAutumn;
    public static Property seasonWinter;
    public static Property dimID;
    public static Property commandNameAliases;
    public static Property commandName;
    private Configuration cfg;
    public static final String CONFIG_VERSION = "v1.2";
    public static final String CONFIG_NAME = "configGeneral.cfg";
    public static final String CONFIG_DIR = "/advancedmotd";
    public String path = "";

    public ConfigGeneral(String cfgPath) {
        this.path = cfgPath;
        this.loadConfigurationFile(this.path);
    }

    public Configuration getConfig() {
        return this.cfg;
    }

    public void loadConfigurationFile(String cfgPath) {
        if (!cfgPath.isEmpty()) {
            File file = new File(cfgPath + CONFIG_DIR, CONFIG_NAME);
            this.cfg = new Configuration(file, CONFIG_VERSION, false);
            if (!this.cfg.getDefinedConfigVersion().equals(this.cfg.getLoadedConfigVersion())) {
                AdvancedMotd.getLogger().warn(" ");
                AdvancedMotd.getLogger().warn("################### WARNING ####################");
                AdvancedMotd.getLogger().warn("Config: " + cfgPath + CONFIG_DIR + "/" + CONFIG_NAME);
                AdvancedMotd.getLogger().warn("Version: Mismatch");
                AdvancedMotd.getLogger().warn("################################################");
                AdvancedMotd.getLogger().warn("Shut down the server after the boot is finished.");
                AdvancedMotd.getLogger().warn("Make a backup of your old config by renaming it.");
                AdvancedMotd.getLogger().warn("Start the server again to create the new config.");
                AdvancedMotd.getLogger().warn("Take over the old settings into the new config.");
                AdvancedMotd.getLogger().warn("################################################");
                AdvancedMotd.getLogger().warn(" ");
            }
            this.loadFromConfiguration();
            this.save();
        }
    }

    public void loadFromConfiguration() {
        this.cfg.setCategoryComment("general", "The main config of AdvancedMOTD.\n\nThe codes for color and format are defined as the following:\n0=BLACK, 1=DARK BLUE, 2=DARK GREEN, 3=DARK AQUA, 4=DARK RED,5=DARK PURPLE\n6=GOLD, 7=GRAY, 8=DARK GRAY, 9=INDIGO, a=GREEN, b=AQUA, c=RED, d=PINK\ne=YELLOW, f=WHITE, k=Obfuscated, l=Bold, m=Strikethrough, n=Underline\no=Italic, r=Reset\n\nRemember to set the color code first, then the format code!\n\nSee the minecraft formats at: https://minecraft.gamepedia.com/Formatting_codes");
        commandNameAliases = this.cfg.get("general", "commandNameAliases", new String[]{"amotd"}, "If you want to define an alias name for the command do it with this value.\nExample: amotd\nmotd\nResult: To call the command you can type /amotd or /motd\n[default: amotd]");
        commandName = this.cfg.get("general", "commandName", "advancedmotd", "If you want to redefine another command name for the mod do it with this value.\nThis option should be used, if the base command /advancedmotd is used by another mod.\nExample: motd\nResult: To call the command you need to type /motd\n[default: advancedmotd]");
        dimID = this.cfg.get("general", "dimension", 0, "Dimension ID to get the time/days/season from.\n[default: 0]", Integer.MIN_VALUE, Integer.MAX_VALUE);
        dateformat = this.cfg.get("general", "dateformat", "%h:%m", "Format of the time and date: %d=day, %w=week, %h=hour, %m=minute, %o=second\nExample: Time=%h:%m | Day=%d\nResult: Time=13:25 | Day=8\n[default: %h:%m]");
        motdFormat = this.cfg.get("general", "motdFormat", "%motd% | %daytime%", "Format of the entire motd message:\n%motd% = Message from the server.config\n%daytime% = The day / time of the given dimension\n%season% = Name of the current season (Serene Seasons)\nExample: %motd% | %daytime% | %season%\nResult: Your motd | 17:12 | Autumn\n[default: %motd% | %daytime%]");
        considerBloodmoon = this.cfg.get("bloodmoon", "considerBloodmoon", false, "Should Bloodmoon be considered? (Bloodmoon Mod)\nSee Bloodmoon at Curse: https://minecraft.curseforge.com/projects/bloodmoon\nIf Bloodmoon is active the config 'dangerColor' will be used.\n[default: false]");
        considerSeasons = this.cfg.get("seasons", "considerSeasons", false, "Should Serene Seasons be considered? (Serene Seasons Mod)\nSee Serene Seasons at Curse: https://minecraft.curseforge.com/projects/serene-seasons\n[default: false]");
        seasonSpring = this.cfg.get("seasons", "seasonSpring", "a", "What is the color of the spring?\nExample: a\nResult: The spring season will colorized GREEN\n[default: a]");
        seasonSummer = this.cfg.get("seasons", "seasonSummer", "e", "What is the color of the summer?\nExample: e\nResult: The summer season will colorized YELLOW\n[default: e]");
        seasonAutumn = this.cfg.get("seasons", "seasonAutumn", "6", "What is the color of the autumn?\nExample: 6\nResult: The autumn season will colorized GOLD\n[default: 6]");
        seasonWinter = this.cfg.get("seasons", "seasonWinter", "3", "What is the color of the winter?\nExample: 3\nResult: The winter season will colorized DARK AQUA\n[default: 3]");
        dangerStart = this.cfg.get("time", "dangerStart", 13183, "When the danger time starts.\nSee the minecraft ticks at: https://minecraft.gamepedia.com/Day-night_cycle#24-hour_Minecraft_day\n" + String.format("[range: %s ~ %s, default: %s]", 0, 24000, 13183), 0, 24000);
        dangerEnd = this.cfg.get("time", "dangerEnd", 23450, "When the danger time ends.\nSee the minecraft ticks at: https://minecraft.gamepedia.com/Day-night_cycle#24-hour_Minecraft_day\n" + String.format("[range: %s ~ %s, default: %s]", 0, 24000, 23450), 0, 24000);
        dangerColor = this.cfg.get("time", "dangerColor", "cn", "What is the color and/or format of the danger time?\nExample: cn\nResult: The danger time will be colorized RED and formated underlined\n[default: cn]");
        safetyColor = this.cfg.get("time", "safetyColor", "ao", "What is the color and/or format of the safety time?\nExample: ao\nResult: The danger time will be colorized GREEN and formated italic.\n[default: ao]");
        weeklength = this.cfg.get("time", "weeklength", 7, "Length (days) of week, for %w format\n" + String.format("[range: %s ~ %s, default: %s]", 1, Integer.MAX_VALUE, 7), 1, Integer.MAX_VALUE);
        colorizeDayN = this.cfg.get("time", "colorizeDayN", 0, "Colorize the n-th day?\nExample 1: 0=turned off\nExample 2: 7=colorize every 7th day especially\n" + String.format("[range: %s ~ %s, default: %s]", 0, Integer.MAX_VALUE, 0), 0, Integer.MAX_VALUE);
        dangerColorAtDayN = this.cfg.get("time", "dangerColorAtDayN", "4ln", "What is the color and/or format of the danger time at the n-th day?\nExample: 4ln\nResult: The danger time at the n-th day will be colorized DARD RED and formated bold and underlined.\n[default: 4ln]");
        safetyColorAtDayN = this.cfg.get("time", "safetyColorAtDayN", "eon", "What is the color and/or format of the safety time at the n-th day?\nExample: eon\nResult: The safety time at the n-th day will be colorized YELLOW and formated italic and underlined.\n[default: eon]");
    }

    public void save() {
        this.cfg.save();
    }

    public void load() {
        this.cfg.load();
        this.loadFromConfiguration();
    }
}

