/*
 * Decompiled with CFR 0.152.
 */
package advancedmotd.commands;

import advancedmotd.AdvancedMotd;
import advancedmotd.commands.Commands;
import advancedmotd.config.ConfigLang;
import advancedmotd.utils.MessageHelper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;

public class CommandHelp
extends Commands {
    public CommandHelp() {
        PermissionAPI.registerNode((String)this.getPermission(), (DefaultPermissionLevel)this.getPermissionLevel(), (String)this.getInfo());
    }

    @Override
    public String func_71517_b() {
        return "help";
    }

    @Override
    public String func_71518_a(ICommandSender sender) {
        return String.format(ConfigLang.cmdHelpUsage, "/" + super.func_71517_b() + " " + this.func_71517_b());
    }

    @Override
    public String getInfo() {
        return ConfigLang.cmdHelpInfo;
    }

    @Override
    public List<String> func_71514_a() {
        return Collections.emptyList();
    }

    @Override
    public DefaultPermissionLevel getPermissionLevel() {
        return DefaultPermissionLevel.OP;
    }

    @Override
    public String getPermission() {
        return "advancedmotd.commands." + ((Object)((Object)this)).getClass().getSimpleName();
    }

    @Override
    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        if (sender instanceof EntityPlayerMP) {
            return PermissionAPI.hasPermission((EntityPlayer)((EntityPlayerMP)sender), (String)this.getPermission());
        }
        return true;
    }

    @Override
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String retStr = "";
        TextFormatting format = TextFormatting.YELLOW;
        if (args.length > 0) {
            if (AdvancedMotd.commands.getCommandMap().containsKey(args[0])) {
                retStr = "\n" + args[0] + ": " + AdvancedMotd.commands.getCommandMap(server, sender).get(args[0]).func_71518_a(sender);
            } else {
                format = TextFormatting.RED;
                retStr = String.format(ConfigLang.errNoCommandAvailable, args[0]);
            }
        } else {
            format = TextFormatting.YELLOW;
            retStr = this.func_71518_a(sender);
            for (Map.Entry<String, Commands> entry : AdvancedMotd.commands.getCommandMap(server, sender).entrySet()) {
                retStr = retStr + "\n" + entry.getKey() + ": " + entry.getValue().getInfo();
            }
        }
        MessageHelper.sendText(sender, retStr, format, true, true);
    }
}

