/*
 * Decompiled with CFR 0.152.
 */
package yeelp.lifescroll.util;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Tuple;
import yeelp.lifescroll.item.ItemSpawnScroll;

public class InventoryUtil {
    public static boolean addToInventory(EntityPlayer player, ItemStack stack, int preferredSlot, boolean offHand) {
        if (stack.func_190926_b() || player == null) {
            return false;
        }
        if (stack.func_77973_b() instanceof ItemArmor) {
            ItemArmor armor = (ItemArmor)stack.func_77973_b();
            int slot = armor.field_77881_a.func_188454_b();
            NonNullList armorInv = player.field_71071_by.field_70460_b;
            return InventoryUtil.placeIfEmpty((List<ItemStack>)armorInv, stack, slot);
        }
        if (offHand) {
            return InventoryUtil.placeIfEmpty((List<ItemStack>)player.field_71071_by.field_184439_c, stack, 0);
        }
        NonNullList inv = player.field_71071_by.field_70462_a;
        if (!InventoryUtil.placeIfEmpty((List<ItemStack>)inv, stack, preferredSlot)) {
            int res = 0;
            int i = 0;
            while (i < inv.size() && res == 0) {
                res = InventoryUtil.toInt(InventoryUtil.placeIfEmpty((List<ItemStack>)inv, stack, i++));
            }
            return res > 0;
        }
        return true;
    }

    public static List<Tuple<Integer, ItemStack>> getScrollsFromInventory(List<ItemStack> lst) {
        return InventoryUtil.getFromListIf(lst, stack -> stack.func_77973_b() instanceof ItemSpawnScroll);
    }

    public static <T> List<Tuple<Integer, T>> getFromListIf(List<T> lst, Predicate<T> pred) {
        LinkedList<Tuple<Integer, T>> results = new LinkedList<Tuple<Integer, T>>();
        for (int i = 0; i < lst.size(); ++i) {
            T t = lst.get(i);
            if (!pred.test(t)) continue;
            results.add(new Tuple((Object)i, t));
        }
        return results;
    }

    private static boolean placeIfEmpty(List<ItemStack> lst, ItemStack stack, int index) {
        return InventoryUtil.placeIf(lst, stack, index, s -> s.func_190926_b());
    }

    private static <T> boolean placeIf(List<T> lst, T item, int index, Predicate<T> pred) {
        if (pred.test(lst.get(index))) {
            lst.set(index, item);
            return true;
        }
        return false;
    }

    private static int toInt(boolean b) {
        return b ? 1 : 0;
    }
}

